/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.buildings.placements.BeaconPlacement;
import com.solegendary.reignofnether.unit.UnitAction;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.Level;

public abstract class BeaconAbility
extends Ability {
    protected final MobEffect effect;
    public static final int CD_MAX = 100;

    public BeaconAbility(UnitAction action, MobEffect effect) {
        super(action, 100, 0.0f, 0.0f, false, true);
        this.effect = effect;
    }

    private void setToMaxCooldownAllAbiltities(BeaconPlacement beacon) {
        for (Ability ability : beacon.getAbilities()) {
            ability.setToMaxCooldown(beacon);
        }
    }

    @Override
    public void use(Level level, BuildingPlacement buildingUsing, BlockPos bp) {
        if (!(buildingUsing instanceof BeaconPlacement)) {
            return;
        }
        BeaconPlacement beacon = (BeaconPlacement)buildingUsing;
        beacon.setAuraEffect(this.effect);
        this.setToMaxCooldownAllAbiltities(beacon);
    }
}

