/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.SculkCatalystPlacement;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class Sacrifice
extends Ability {
    private static final int CD_MAX = 0;
    private static final int RANGE = 8;

    public Sacrifice() {
        super(UnitAction.SACRIFICE, 0, 8.0f, 0.0f, true, true);
        this.autocastEnableAction = UnitAction.SACRIFICE_AUTOCAST_ENABLE;
        this.autocastDisableAction = UnitAction.SACRIFICE_AUTOCAST_DISABLE;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, BuildingPlacement placement) {
        return new AbilityButton("Sacrifice", ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/iron_hoe.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.SACRIFICE || this.isAutocasting(placement), () -> false, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.SACRIFICE), () -> this.toggleAutocast(placement), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.sacrifice", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.sacrifice.tooltip1", (Object[])new Object[]{8}), (Style)MyRenderer.iconStyle), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.sacrifice.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.autocast", (Object[])new Object[0]), (Style)Style.f_131099_), this.getAutoSacrificeTooltip(placement)), (Ability)this, placement);
    }

    private FormattedCharSequence getAutoSacrificeTooltip(BuildingPlacement placement) {
        String unitType = "";
        if (placement instanceof SculkCatalystPlacement) {
            SculkCatalystPlacement sculkCat = (SculkCatalystPlacement)placement;
            unitType = sculkCat.autoSacrificeUnitType;
        }
        return unitType != null && !unitType.isBlank() && this.isAutocasting(placement) ? FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.sacrifice.tooltip4", (Object[])new Object[]{unitType}), (Style)Style.f_131099_) : FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.sacrifice.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_);
    }

    public boolean isValidTarget(Level level, BuildingPlacement buildingUsing, LivingEntity targetEntity) {
        Unit unit;
        return targetEntity instanceof Unit && (unit = (Unit)targetEntity).getOwnerName().equals(buildingUsing.ownerName) && !level.m_8055_(targetEntity.m_20097_()).m_60795_() && !BuildingUtils.isWithinRangeOfMaxedCatalyst(targetEntity) && !BuildingUtils.isPosInsideAnyBuilding(level.m_5776_(), targetEntity.m_20097_().m_7494_()) && targetEntity.m_20238_(Vec3.m_82512_((Vec3i)buildingUsing.centrePos)) < 64.0 && level.m_8055_(targetEntity.m_20097_()).m_60734_() != Blocks.f_220855_;
    }

    public String getGenericName(LivingEntity le) {
        String name = MiscUtil.getSimpleEntityName((Entity)le).toLowerCase();
        if (name.equals("husk") || name.equals("drowned")) {
            return "zombie";
        }
        if (name.equals("stray")) {
            return "skeleton";
        }
        if (name.equals("poison spider")) {
            return "spider";
        }
        return name;
    }

    @Override
    public void use(Level level, BuildingPlacement buildingUsing, LivingEntity targetEntity) {
        if (!(buildingUsing instanceof SculkCatalystPlacement)) {
            return;
        }
        SculkCatalystPlacement sculkCat = (SculkCatalystPlacement)buildingUsing;
        if (targetEntity instanceof Unit && this.isAutocasting(buildingUsing)) {
            sculkCat.autoSacrificeUnitType = this.getGenericName(targetEntity);
            if (level.m_5776_()) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.sacrifice.set_autocast_target", (Object[])new Object[]{sculkCat.autoSacrificeUnitType}));
            }
            return;
        }
        if (!level.m_5776_() && this.isValidTarget(level, buildingUsing, targetEntity)) {
            targetEntity.m_6074_();
        } else if (level.m_5776_()) {
            Unit unit;
            if (!(targetEntity instanceof Unit) || !(unit = (Unit)targetEntity).getOwnerName().equals(buildingUsing.ownerName)) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.sacrifice.only_own", (Object[])new Object[0]));
            } else if (targetEntity.m_20238_(Vec3.m_82512_((Vec3i)buildingUsing.centrePos)) >= 64.0) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.sacrifice.out_of_range", (Object[])new Object[0]));
            } else if (level.m_8055_(targetEntity.m_20097_()).m_60795_()) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.sacrifice.in_air", (Object[])new Object[0]));
            } else if (BuildingUtils.isWithinRangeOfMaxedCatalyst(targetEntity)) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.sacrifice.max_spread", (Object[])new Object[0]));
            } else if (BuildingUtils.isPosInsideAnyBuilding(level.m_5776_(), targetEntity.m_20097_().m_7494_()) || level.m_8055_(targetEntity.m_20097_()).m_60734_() == Blocks.f_220855_) {
                HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.sacrifice.not_spreadable", (Object[])new Object[0]));
            }
        }
    }

    public void autoSacrifice(BuildingPlacement buildingUsing) {
        if (!(buildingUsing instanceof SculkCatalystPlacement)) {
            return;
        }
        List<LivingEntity> entities = MiscUtil.getEntitiesWithinRange(Vec3.m_82512_((Vec3i)buildingUsing.centrePos), this.range, LivingEntity.class, buildingUsing.level);
        for (LivingEntity le : entities) {
            if (!(le instanceof Unit) || !this.getGenericName(le).equals(((SculkCatalystPlacement)buildingUsing).autoSacrificeUnitType) || !this.isValidTarget(buildingUsing.level, buildingUsing, le)) continue;
            le.m_6074_();
            return;
        }
    }
}

