/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.shared;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.goals.GenericTargetedSpellGoal;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.WretchedWraithUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class PlaceholderTargetedAbility
extends HeroAbility {
    public PlaceholderTargetedAbility() {
        super(3, 3, UnitAction.DEBUG1, 60, 3.0f, 0.0f, true);
    }

    @Override
    public boolean isCasting(Unit unit) {
        WretchedWraithUnit wretchedWraithUnit;
        GenericTargetedSpellGoal goal;
        if (unit instanceof WretchedWraithUnit && (goal = (wretchedWraithUnit = (WretchedWraithUnit)unit).getCastFrostblinkGoal()) != null) {
            return goal.isCasting();
        }
        return false;
    }

    @Override
    public boolean rankUp(HeroUnit hero) {
        if (super.rankUp(hero)) {
            this.updateStatsForRank(hero);
            return true;
        }
        return false;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        if (!(unit instanceof HeroUnit)) {
            return null;
        }
        HeroUnit hero = (HeroUnit)unit;
        return new AbilityButton("Placeholder Targeted", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/command_block_front.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.DEBUG1, () -> this.getRank(hero) == 0, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.DEBUG1), null, this.getTooltipLines(hero), (Ability)this, hero);
    }

    @Override
    public Button getRankUpButton(HeroUnit hero) {
        return super.getRankUpButtonProtected("Placeholder Targeted", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/command_block_front.png"), hero);
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs("Placeholder targeted"));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines(HeroUnit hero) {
        return List.of();
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        ((WretchedWraithUnit)unitUsing).getCastFrostblinkGoal().setAbility(this);
        ((WretchedWraithUnit)unitUsing).getCastFrostblinkGoal().setTarget(targetBp);
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        ((WretchedWraithUnit)unitUsing).getCastFrostblinkGoal().setAbility(this);
        ((WretchedWraithUnit)unitUsing).getCastFrostblinkGoal().setTarget(targetEntity);
    }
}

