/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.villager;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hero.HeroClientboundPacket;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.goals.GenericUntargetedSpellGoal;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.villagers.RoyalGuardUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class Avatar
extends HeroAbility {
    private static final int CD_MAX_SECONDS = 6000;
    public static final int DURATION = 1200;
    public static final float ATTACK_SPLASH_RADIUS = 2.5f;
    public static final float ATTACK_SPLASH_MULT = 0.5f;
    public static final float BONUS_HEALTH = 100.0f;

    public Avatar() {
        super(1, 100, UnitAction.AVATAR, 6000, 0.0f, 0.0f, false);
    }

    @Override
    public boolean isCasting(Unit unit) {
        RoyalGuardUnit royalGuardUnit;
        GenericUntargetedSpellGoal goal;
        if (unit instanceof RoyalGuardUnit && (goal = (royalGuardUnit = (RoyalGuardUnit)unit).getCastAvatarGoal()) != null) {
            return goal.isCasting();
        }
        return false;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey, Unit unit) {
        if (!(unit instanceof HeroUnit)) {
            return null;
        }
        HeroUnit hero = (HeroUnit)unit;
        return new AbilityButton("Avatar", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/vindicator.png"), hotkey, () -> false, () -> this.getRank(hero) == 0, () -> true, () -> UnitClientEvents.sendUnitCommand(UnitAction.AVATAR), null, this.getTooltipLines(hero), (Ability)this, hero);
    }

    @Override
    public Button getRankUpButton(HeroUnit hero) {
        return super.getRankUpButtonProtected("Avatar", ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/vindicator.png"), hero);
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.avatar", (Object[])new Object[0]), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.avatar.stats", (Object[])new Object[]{300, this.manaCost})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.avatar.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.avatar.tooltip2", (Object[])new Object[]{Float.valueOf(100.0f)})), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.avatar.tooltip3", (Object[])new Object[]{60})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines(HeroUnit hero) {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.avatar", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement(hero)}), this.getLevelReqStyle(hero)), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.avatar.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.avatar.tooltip2", (Object[])new Object[]{Float.valueOf(100.0f)})), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.avatar.tooltip3", (Object[])new Object[]{60})));
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        this.use(level, unitUsing);
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        this.use(level, unitUsing);
    }

    private void use(Level level, Unit unitUsing) {
        boolean isAvatarActive;
        boolean bl = isAvatarActive = ((RoyalGuardUnit)unitUsing).avatarTicksLeft > 0;
        if (level.m_5776_() && isAvatarActive) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.avatar.already_active", (Object[])new Object[0]));
        }
        if (!isAvatarActive) {
            ((RoyalGuardUnit)unitUsing).getCastAvatarGoal().setAbility(this);
            ((RoyalGuardUnit)unitUsing).getCastAvatarGoal().startCasting();
            ((RoyalGuardUnit)unitUsing).avatarScalingStarted = true;
            if (!level.m_5776_()) {
                SoundClientboundPacket.playSoundAtPos(SoundAction.BLOODLUST, ((LivingEntity)unitUsing).m_20097_().m_7494_());
                HeroClientboundPacket.activateAbilityClientside(((RoyalGuardUnit)unitUsing).m_19879_(), 3);
            }
        }
    }
}

