/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.alliance;

import com.solegendary.reignofnether.alliance.AllianceAction;
import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.registrars.PacketHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class AllianceClientboundPacket {
    AllianceAction action;
    public String player1;
    public String player2;
    public boolean boolValue;

    public static void addAlliance(String playerName1, String playerName2) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundPacket(AllianceAction.ACCEPT_REQUEST, playerName1, playerName2, true));
    }

    public static void addPendingAlliance(String toPlayer, String fromPlayer) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundPacket(AllianceAction.REQUEST, toPlayer, fromPlayer, true));
    }

    public static void cancelPendingAlliance(String toPlayer, String fromPlayer) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundPacket(AllianceAction.CANCEL_REQUEST, toPlayer, fromPlayer, true));
    }

    public static void removeAlliance(String playerName1, String playerName2) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundPacket(AllianceAction.DISBAND, playerName1, playerName2, false));
    }

    public static void resetAlliances() {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundPacket(AllianceAction.DISBAND, "", "", true));
    }

    public static void setAllyControl(String playerName1, boolean setValue) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundPacket(AllianceAction.SET_ALLY_CONTROL, playerName1, "", setValue));
    }

    public AllianceClientboundPacket(AllianceAction action, String player1, String player2, boolean boolValue) {
        this.action = action;
        this.player1 = player1;
        this.player2 = player2;
        this.boolValue = boolValue;
    }

    public AllianceClientboundPacket(FriendlyByteBuf buffer) {
        this.action = (AllianceAction)buffer.m_130066_(AllianceAction.class);
        this.player1 = buffer.m_130277_();
        this.player2 = buffer.m_130277_();
        this.boolValue = buffer.readBoolean();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130070_(this.player1);
        buffer.m_130070_(this.player2);
        buffer.writeBoolean(this.boolValue);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (this.action) {
                case REQUEST: {
                    AlliancesClient.addPendingAlliance(this.player1, this.player2);
                    break;
                }
                case CANCEL_REQUEST: {
                    AlliancesClient.cancelPendingAlliance(this.player1, this.player2);
                    break;
                }
                case ACCEPT_REQUEST: {
                    AlliancesClient.addAlliance(this.player1, this.player2);
                    break;
                }
                case DISBAND: {
                    if (this.boolValue) {
                        AlliancesClient.resetAllAlliances();
                        break;
                    }
                    AlliancesClient.removeAlliance(this.player1, this.player2);
                    break;
                }
                case SET_ALLY_CONTROL: {
                    if (this.boolValue) {
                        AlliancesClient.playersWithAlliedControl.add(this.player1);
                        break;
                    }
                    AlliancesClient.playersWithAlliedControl.remove(this.player1);
                }
            }
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

