/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.attackwarnings;

import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.registrars.SoundRegistrar;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AttackWarningClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final int ATTACK_WARNING_CD_MAX = 300;
    private static int attackWarningCd = 0;
    private static BlockPos lastAttackPos = null;
    private static final int FLICKER_SPEED = 10;
    private static int flickerTimer = 10;
    private static boolean showFrame = true;
    private static final int WARN_DURATION_MAX = 600;
    private static int warnDuration = 0;

    public static Button getWarningButton() {
        return new Button("Go to alert", 20, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/warning.png"), null, null, () -> showFrame, () -> lastAttackPos == null || warnDuration <= 0, () -> true, () -> {
            OrthoviewClientEvents.centreCameraOnPos(lastAttackPos);
            attackWarningCd = 300;
            lastAttackPos = null;
        }, () -> {
            attackWarningCd = 600;
            lastAttackPos = null;
        }, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"attack_warning.reignofnether.go_to", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"attack_warning.reignofnether.ignore", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    public static void checkAndTriggerAttackWarning(String attackedPlayerName, BlockPos attackPos) {
        if (AttackWarningClientEvents.MC.f_91074_ == null || !OrthoviewClientEvents.isEnabled()) {
            return;
        }
        if (!AttackWarningClientEvents.MC.f_91074_.m_7755_().getString().equals(attackedPlayerName)) {
            return;
        }
        Vec3 centrePos = MiscUtil.getOrthoviewCentreWorldPos(MC);
        float dist2dSqr = new Vec2((float)attackPos.m_123341_(), (float)attackPos.m_123343_()).m_165914_(new Vec2((float)centrePos.f_82479_, (float)centrePos.f_82481_));
        if (lastAttackPos != null) {
            lastAttackPos = attackPos;
        }
        if ((double)dist2dSqr > Math.pow(OrthoviewClientEvents.getZoom() * 2.0f, 2.0) && attackWarningCd <= 0) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"attack_warning.reignofnether.danger", (Object[])new Object[0]), 200);
            lastAttackPos = attackPos;
            if (AttackWarningClientEvents.MC.f_91074_ != null) {
                AttackWarningClientEvents.MC.f_91074_.m_5496_((SoundEvent)SoundRegistrar.UNDER_ATTACK.get(), 0.5f, 1.0f);
            }
            attackWarningCd = 300;
            warnDuration = 600;
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (attackWarningCd > 0) {
            --attackWarningCd;
        }
        if (--flickerTimer <= 0) {
            flickerTimer = 10;
            boolean bl = showFrame = !showFrame;
        }
        if (warnDuration > 0) {
            --warnDuration;
        }
    }
}

