/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.NetherConvertingBuilding;
import com.solegendary.reignofnether.building.buildings.placements.BeaconPlacement;
import com.solegendary.reignofnether.building.buildings.placements.SculkCatalystPlacement;
import com.solegendary.reignofnether.building.buildings.shared.AbstractBridge;
import com.solegendary.reignofnether.keybinds.Keybinding;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BuildingUtils {
    public static List<Keybinding> keybindings = Arrays.asList(new Keybinding[0]);

    public static int getTotalCompletedBuildingsOwned(boolean isClientSide, String ownerName) {
        List<BuildingPlacement> buildings = isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        return buildings.stream().filter(b -> b.isBuilt && b.ownerName.equals(ownerName)).toList().size();
    }

    public static boolean isBuildingBuildable(boolean isClientSide, BuildingPlacement building) {
        if (isClientSide) {
            return BuildingClientEvents.getBuildings().stream().map(b -> b.originPos).toList().contains(building.originPos) && building.getBlocksPlaced() < building.getBlocksTotal();
        }
        return BuildingServerEvents.getBuildings().stream().map(b -> b.originPos).toList().contains(building.originPos) && building.getBlocksPlaced() < building.getBlocksTotal();
    }

    public static ArrayList<BlockPos> getUniqueChunkBps(BuildingPlacement building) {
        AABB aabb = new AABB(building.minCorner, building.maxCorner.m_7918_(1, 1, 1));
        ArrayList<BlockPos> bps = new ArrayList<BlockPos>();
        double x = aabb.f_82288_;
        double z = aabb.f_82290_;
        while (true) {
            bps.add(new BlockPos((int)x, (int)aabb.f_82289_, (int)z));
            if ((x += 16.0) <= aabb.f_82291_) continue;
            x = aabb.f_82288_;
            if (!((z += 16.0) <= aabb.f_82293_)) break;
        }
        bps.add(new BlockPos((int)aabb.f_82291_, (int)aabb.f_82289_, (int)aabb.f_82290_));
        bps.add(new BlockPos((int)aabb.f_82288_, (int)aabb.f_82289_, (int)aabb.f_82293_));
        bps.add(new BlockPos((int)aabb.f_82291_, (int)aabb.f_82289_, (int)aabb.f_82293_));
        return bps;
    }

    public static BuildingPlacement getNewBuildingPlacement(Building building, Level level, BlockPos pos, Rotation rotation, String ownerName, boolean isDiagonalBridge) {
        BuildingPlacement buildingPlacement = null;
        if (building instanceof AbstractBridge) {
            AbstractBridge bridge = (AbstractBridge)building;
            buildingPlacement = bridge.createBuildingPlacement(level, pos, rotation, ownerName, isDiagonalBridge);
        } else {
            buildingPlacement = building.createBuildingPlacement(level, pos, rotation, ownerName);
        }
        if (buildingPlacement != null) {
            buildingPlacement.updateButtons();
            buildingPlacement.setLevel(level);
        }
        return buildingPlacement;
    }

    public static BuildingPlacement findBuilding(boolean isClientSide, BlockPos pos) {
        List<BuildingPlacement> buildings = isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        for (BuildingPlacement building : buildings) {
            if (!building.originPos.equals((Object)pos) && !building.isPosInsideBuilding(pos)) continue;
            return building;
        }
        return null;
    }

    public static BlockPos getMinCorner(ArrayList<BuildingBlock> blocks) {
        MinMaxValues minMax = BuildingUtils.calculateMinMax(blocks);
        return new BlockPos(minMax.minX, minMax.minY, minMax.minZ);
    }

    public static BlockPos getMaxCorner(ArrayList<BuildingBlock> blocks) {
        MinMaxValues minMax = BuildingUtils.calculateMinMax(blocks);
        return new BlockPos(minMax.maxX, minMax.maxY, minMax.maxZ);
    }

    public static BlockPos getCentrePos(ArrayList<BuildingBlock> blocks) {
        MinMaxValues minMax = BuildingUtils.calculateMinMax(blocks);
        return new BlockPos((minMax.minX + minMax.maxX) / 2, (minMax.minY + minMax.maxY) / 2, (minMax.minZ + minMax.maxZ) / 2);
    }

    private static MinMaxValues calculateMinMax(ArrayList<BuildingBlock> blocks) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BuildingBlock block : blocks) {
            BlockPos pos = block.getBlockPos();
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (z <= maxZ) continue;
            maxZ = z;
        }
        return new MinMaxValues(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static Vec3i getBuildingSize(ArrayList<BuildingBlock> blocks) {
        BlockPos min = BuildingUtils.getMinCorner(blocks);
        BlockPos max = BuildingUtils.getMaxCorner(blocks);
        return new Vec3i(max.m_123341_() - min.m_123341_(), max.m_123342_() - min.m_123342_(), max.m_123343_() - min.m_123343_());
    }

    public static ArrayList<BuildingBlock> getAbsoluteBlockData(ArrayList<BuildingBlock> staticBlocks, LevelAccessor level, BlockPos originPos, Rotation rotation, Vec3i blockOffset) {
        ArrayList<BuildingBlock> blocks = new ArrayList<BuildingBlock>();
        for (BuildingBlock block : staticBlocks) {
            block = block.rotate(level, rotation);
            BlockPos bp = block.getBlockPos();
            block.setBlockPos(new BlockPos(bp.m_123341_() + originPos.m_123341_() + blockOffset.m_123341_(), bp.m_123342_() + originPos.m_123342_() + blockOffset.m_123342_() + 1, bp.m_123343_() + originPos.m_123343_() + blockOffset.m_123343_()));
            blocks.add(block);
        }
        return blocks;
    }

    public static ArrayList<BuildingBlock> getAbsoluteBlockData(ArrayList<BuildingBlock> staticBlocks, LevelAccessor level, BlockPos originPos, Rotation rotation) {
        return BuildingUtils.getAbsoluteBlockData(staticBlocks, level, originPos, rotation, new Vec3i(0, 0, 0));
    }

    public static boolean isPosPartOfAnyBuilding(boolean isClientSide, BlockPos bp, boolean onlyPlacedBlocks, int range) {
        List<BuildingPlacement> buildings = isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        int rangeSquared = range * range;
        return buildings.stream().anyMatch(building -> (range == 0 || bp.m_123331_((Vec3i)building.centrePos) < (double)rangeSquared) && building.isPosPartOfBuilding(bp, onlyPlacedBlocks));
    }

    public static boolean isPosInsideAnyBuilding(boolean isClientSide, BlockPos bp) {
        List<BuildingPlacement> buildings = isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        for (BuildingPlacement building : buildings) {
            if (!building.isPosInsideBuilding(bp)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static BuildingPlacement findClosestBuilding(boolean isClientSide, Vec3 pos, Predicate<BuildingPlacement> condition) {
        List<BuildingPlacement> buildings = isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        double closestDist = 9999.0;
        BuildingPlacement closestBuilding = null;
        for (BuildingPlacement building : buildings) {
            BlockPos bp;
            Vec3 bpVec3;
            double dist;
            if (!condition.test(building) || !((dist = (bpVec3 = new Vec3((double)(bp = building.centrePos).m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_())).m_82557_(pos)) < closestDist)) continue;
            closestDist = dist;
            closestBuilding = building;
        }
        return closestBuilding;
    }

    public static boolean isInNetherRange(boolean isClientSide, BlockPos bp) {
        List<BuildingPlacement> buildings = BuildingUtils.getBuildingsList(isClientSide);
        for (BuildingPlacement building : buildings) {
            NetherConvertingBuilding ncb;
            if (!(building instanceof NetherConvertingBuilding) || !((ncb = (NetherConvertingBuilding)((Object)building)).getMaxNetherRange() > 0.0)) continue;
            double maxRangeSquared = Math.pow(ncb.getMaxNetherRange(), 2.0);
            if (!(bp.m_123331_((Vec3i)building.centrePos) <= maxRangeSquared)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWithinRangeOfMaxedCatalyst(LivingEntity entity) {
        List<BuildingPlacement> buildings = BuildingUtils.getBuildingsList(entity.m_9236_().m_5776_());
        double maxCatalystRangeSquared = 100.0;
        for (BuildingPlacement building : buildings) {
            if (!(building instanceof SculkCatalystPlacement)) continue;
            SculkCatalystPlacement sc = (SculkCatalystPlacement)building;
            if (!(entity.m_20238_(Vec3.m_82512_((Vec3i)sc.centrePos)) < maxCatalystRangeSquared) || !((float)sc.getUncappedNightRange() >= 75.0f)) continue;
            return true;
        }
        return false;
    }

    private static List<BuildingPlacement> getBuildingsList(boolean isClientSide) {
        return isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
    }

    public static BeaconPlacement getBeacon(boolean isClientSide) {
        List<BuildingPlacement> buildings = BuildingUtils.getBuildingsList(isClientSide);
        for (BuildingPlacement building : buildings) {
            if (!(building instanceof BeaconPlacement)) continue;
            BeaconPlacement beacon = (BeaconPlacement)building;
            return beacon;
        }
        return null;
    }

    public static void clearBuildingArea(BuildingPlacement building) {
        if (building != null) {
            for (int x = building.minCorner.m_123341_() - 1; x < building.maxCorner.m_123341_() + 2; ++x) {
                for (int y = building.minCorner.m_123342_(); y < building.maxCorner.m_123342_() + 2; ++y) {
                    for (int z = building.minCorner.m_123343_() - 1; z < building.maxCorner.m_123343_() + 2; ++z) {
                        if (BuildingUtils.isPosInsideAnyBuilding(building.level.m_5776_(), new BlockPos(x, y, z))) continue;
                        building.getLevel().m_46597_(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_());
                    }
                }
            }
        }
    }

    private static class MinMaxValues {
        int minX;
        int minY;
        int minZ;
        int maxX;
        int maxY;
        int maxZ;

        public MinMaxValues(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }
    }
}

