/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;

public interface GarrisonableBuilding {
    public int getAttackRange();

    public int getExternalAttackRangeBonus();

    @Nullable
    public BlockPos getEntryPosition();

    @Nullable
    public BlockPos getExitPosition();

    public int getCapacity();

    default public boolean isFull() {
        return GarrisonableBuilding.getNumOccupants((BuildingPlacement)((Object)this)) >= this.getCapacity();
    }

    public static BlockPos rotatePos(BlockPos pos, Rotation rot) {
        if (rot == Rotation.NONE) {
            return new BlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        if (rot == Rotation.CLOCKWISE_90) {
            return new BlockPos(-pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }
        if (rot == Rotation.CLOCKWISE_180) {
            return new BlockPos(-pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
        }
        return new BlockPos(pos.m_123341_(), pos.m_123342_(), -pos.m_123343_());
    }

    default public List<LivingEntity> getOccupants() {
        GarrisonableBuilding garrisonableBuilding = this;
        if (garrisonableBuilding instanceof BuildingPlacement) {
            BuildingPlacement building = (BuildingPlacement)((Object)garrisonableBuilding);
            if (building.level.m_5776_()) {
                return UnitClientEvents.getAllUnits().stream().filter(le -> {
                    Unit u;
                    return le instanceof Unit && GarrisonableBuilding.getGarrison(u = (Unit)le) == this;
                }).toList();
            }
            return UnitServerEvents.getAllUnits().stream().filter(le -> {
                Unit u;
                return le instanceof Unit && GarrisonableBuilding.getGarrison(u = (Unit)le) == this;
            }).toList();
        }
        return List.of();
    }

    public static GarrisonableBuilding getGarrison(Unit unit) {
        Entity entity = (Entity)unit;
        List<BuildingPlacement> buildings = entity.m_9236_().m_5776_() ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        for (BuildingPlacement building : buildings) {
            Block onBlock;
            GarrisonableBuilding garr;
            boolean isAllied = entity.m_9236_().m_5776_() ? AlliancesClient.isAllied(unit.getOwnerName(), building.ownerName) : AlliancesServerEvents.isAllied(unit.getOwnerName(), building.ownerName);
            if (!unit.getOwnerName().equals(building.ownerName) && !isAllied && (!unit.getOwnerName().isEmpty() || !building.ownerName.isEmpty()) || !(building instanceof GarrisonableBuilding) || (garr = (GarrisonableBuilding)((Object)building)).getCapacity() <= 0 || !building.isBuilt || !building.isPosInsideBuilding(((LivingEntity)unit).m_20097_().m_7494_()) || !(building.getBuilding() instanceof CustomBuilding ? (onBlock = entity.m_9236_().m_8055_(entity.m_20097_().m_7494_()).m_60734_()) == BlockRegistrar.GARRISON_ZONE_BLOCK.get() || onBlock == BlockRegistrar.GARRISON_ENTRY_BLOCK.get() : ((LivingEntity)unit).m_20097_().m_123342_() > building.originPos.m_123342_() + 2)) continue;
            return garr;
        }
        return null;
    }

    public static int getNumOccupants(BuildingPlacement building) {
        ArrayList<LivingEntity> entities = building.getLevel().m_5776_() ? UnitClientEvents.getAllUnits() : UnitServerEvents.getAllUnits();
        int numOccupants = 0;
        for (LivingEntity entity : entities) {
            if (!building.isPosInsideBuilding(entity.m_20097_().m_7494_())) continue;
            if (building.getBuilding() instanceof CustomBuilding) {
                Block onBlock = entity.m_9236_().m_8055_(entity.m_20097_().m_7494_()).m_60734_();
                if (onBlock != BlockRegistrar.GARRISON_ZONE_BLOCK.get() && onBlock != BlockRegistrar.GARRISON_ENTRY_BLOCK.get()) continue;
                ++numOccupants;
                continue;
            }
            if (entity.m_20097_().m_123342_() <= building.originPos.m_123342_() + 2) continue;
            ++numOccupants;
        }
        return numOccupants;
    }
}

