/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class AltarOfDarkness
extends ProductionBuilding {
    public static final String buildingName = "Altar of Darkness";
    public static final String structureName = "altar_of_darkness";
    public static final ResourceCost cost = ResourceCosts.ALTAR_OF_DARKNESS;

    public AltarOfDarkness() {
        super(structureName, cost, false);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50379_;
        this.icon = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/dark_prismarine.png");
        this.startingBlockTypes.add(Blocks.f_50379_);
        this.startingBlockTypes.add(Blocks.f_152498_);
        this.productions.add(ProductionItems.NECROMANCER, Keybindings.keyQ);
        this.productions.add(ProductionItems.NECROMANCER_REVIVE, Keybindings.keyQ);
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        ProductionPlacement pp = (ProductionPlacement)super.createBuildingPlacement(level, pos, rotation, ownerName);
        pp.allowProdWhileBuilding = true;
        return pp;
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public BuildingPlaceButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new BuildingPlaceButton(name, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/dark_prismarine.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.ALTAR_OF_DARKNESS, () -> !SandboxClientEvents.isSandboxPlayer() && !GameruleClient.allowHeroes, () -> BuildingClientEvents.hasFinishedBuilding(Buildings.MAUSOLEUM) || ResearchClient.hasCheat("modifythephasevariance"), List.of(MiscUtil.fcs(I18n.m_118938_((String)"buildings.monsters.reignofnether.altar_of_darkness", (Object[])new Object[0]), true), ResourceCosts.getFormattedCost(cost), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"buildings.monsters.reignofnether.altar_of_darkness.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"buildings.monsters.reignofnether.altar_of_darkness.tooltip2", (Object[])new Object[0]))), this);
    }
}

