/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.monsters;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.StrongholdPlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Stronghold
extends ProductionBuilding {
    public static final String buildingName = "Stronghold";
    public static final String structureName = "stronghold";
    public static final ResourceCost cost = ResourceCosts.STRONGHOLD;
    public static final int nightRange = 60;
    private final Set<BlockPos> nightBorderBps = new HashSet<BlockPos>();

    public Stronghold() {
        super(structureName, cost, false);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_220863_;
        this.icon = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/reinforced_deepslate_side.png");
        this.buildTimeModifier = 0.5f;
        this.startingBlockTypes.add(Blocks.f_50734_);
        this.startingBlockTypes.add(Blocks.f_152561_);
        this.startingBlockTypes.add(Blocks.f_50711_);
        this.startingBlockTypes.add(Blocks.f_152550_);
        this.productions.add(ProductionItems.WARDEN, Keybindings.keyQ);
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        return new StrongholdPlacement(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), true, 60, false, true);
    }

    @Override
    public BuildingPlaceButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new BuildingPlaceButton(name, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/reinforced_deepslate_side.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.STRONGHOLD, () -> false, () -> BuildingClientEvents.hasFinishedBuilding(Buildings.LABORATORY) && BuildingClientEvents.hasFinishedBuilding(Buildings.SPIDER_LAIR) && BuildingClientEvents.hasFinishedBuilding(Buildings.DUNGEON) || ResearchClient.hasCheat("modifythephasevariance"), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.stronghold", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.stronghold.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.stronghold.tooltip2", (Object[])new Object[]{7}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.stronghold.tooltip3", (Object[])new Object[]{60}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.monsters.reignofnether.stronghold.tooltip4", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }
}

