/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.neutral;

import com.solegendary.reignofnether.ability.abilities.BeaconHaste;
import com.solegendary.reignofnether.ability.abilities.BeaconRegeneration;
import com.solegendary.reignofnether.ability.abilities.BeaconResistance;
import com.solegendary.reignofnether.ability.abilities.BeaconStrength;
import com.solegendary.reignofnether.ability.abilities.BeaconWealth;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.BeaconPlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.util.Faction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Beacon
extends ProductionBuilding {
    public static final String buildingName = "Beacon";
    public static final String structureName = "beacon_t0";
    public static final String structureNameT1 = "beacon_t1";
    public static final String structureNameT2 = "beacon_t2";
    public static final String structureNameT3 = "beacon_t3";
    public static final String structureNameT4 = "beacon_t4";
    public static final String structureNameT5 = "beacon_t5";
    public static final ResourceCost cost = ResourceCosts.BEACON;
    public static final int MAX_UPGRADE_LEVEL = 5;

    public static int getTicksToWin(Level level) {
        if (level.f_46443_) {
            return (int)(GameruleClient.beaconWinMinutes * 20.0 * 60.0);
        }
        if (level.m_7654_() != null) {
            return ((GameRules.IntegerValue)level.m_7654_().m_129900_().m_46170_(GameRuleRegistrar.BEACON_WIN_MINUTES)).m_46288_() * 20 * 60;
        }
        return 24000;
    }

    public Beacon() {
        super(structureName, cost, false);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50273_;
        this.icon = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/nether_star.png");
        this.buildTimeModifier = 2.0f;
        this.capturable = false;
        this.invulnerable = false;
        this.shouldDestroyOnReset = true;
        this.startingBlockTypes.add(Blocks.f_50225_);
        this.explodeChance = 0.2f;
        this.abilities.add(new BeaconWealth(), Keybindings.keyQ);
        this.abilities.add(new BeaconHaste(), Keybindings.keyW);
        this.abilities.add(new BeaconRegeneration(), Keybindings.keyE);
        this.abilities.add(new BeaconResistance(), Keybindings.keyR);
        this.abilities.add(new BeaconStrength(), Keybindings.keyT);
        this.productions.add(ProductionItems.RESEARCH_BEACON_LEVEL_1, null);
        this.productions.add(ProductionItems.RESEARCH_BEACON_LEVEL_2, null);
        this.productions.add(ProductionItems.RESEARCH_BEACON_LEVEL_3, null);
        this.productions.add(ProductionItems.RESEARCH_BEACON_LEVEL_4, null);
        this.productions.add(ProductionItems.RESEARCH_BEACON_LEVEL_5, null);
    }

    @Override
    public ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocksFromNbt(structureName, level);
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        return new BeaconPlacement(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), false);
    }

    @Override
    public BuildingPlaceButton getBuildButton(Keybinding hotkey) {
        return new BuildingPlaceButton(buildingName, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/nether_star.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == this, () -> TutorialClientEvents.isEnabled() || !GameruleClient.allowBeacons, () -> BuildingClientEvents.getBuildings().stream().filter(b -> b instanceof BeaconPlacement).toList().isEmpty() && (BuildingClientEvents.hasFinishedBuilding(Buildings.CASTLE) || BuildingClientEvents.hasFinishedBuilding(Buildings.STRONGHOLD) || BuildingClientEvents.hasFinishedBuilding(Buildings.FORTRESS) || ResearchClient.hasCheat("modifythephasevariance")), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.beacon", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.beacon.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.beacon.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.beacon.tooltip4", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.neutral.reignofnether.beacon.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public int getUpgradeLevel(BuildingPlacement placement) {
        for (BuildingBlock block : placement.getBlocks()) {
            if (block.getBlockState().m_60734_() == Blocks.f_50721_) {
                return 5;
            }
            if (block.getBlockState().m_60734_() == Blocks.f_50090_) {
                return 4;
            }
            if (block.getBlockState().m_60734_() == Blocks.f_50268_) {
                return 3;
            }
            if (block.getBlockState().m_60734_() == Blocks.f_50074_) {
                return 2;
            }
            if (block.getBlockState().m_60734_() != Blocks.f_50075_) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Faction getFaction() {
        return Faction.NONE;
    }
}

