/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.NetherConvertingBuilding;
import com.solegendary.reignofnether.building.NetherZone;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class CentralPortalPlacement
extends ProductionPlacement
implements NetherConvertingBuilding {
    public NetherZone netherConversionZone = null;

    public CentralPortalPlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol) {
        super(building, level, originPos, rotation, ownerName, blocks, isCapitol);
    }

    @Override
    public double getMaxNetherRange() {
        return 30.0;
    }

    @Override
    public double getStartingNetherRange() {
        return 6.0;
    }

    @Override
    public NetherZone getNetherZone() {
        return this.netherConversionZone;
    }

    @Override
    public void tick(Level tickLevel) {
        super.tick(tickLevel);
        if (!this.getLevel().m_5776_() && this.getBlocksPlaced() >= this.getBlocksTotal()) {
            BlockPos bp = this.rotation == Rotation.CLOCKWISE_90 || this.rotation == Rotation.COUNTERCLOCKWISE_90 ? this.centrePos.m_7918_(0, -1, 0) : this.centrePos.m_7918_(-1, 0, 0);
            if (this.getLevel().m_8055_(bp).m_60795_()) {
                this.getLevel().m_46597_(bp, Blocks.f_50083_.m_49966_());
            }
        }
    }

    @Override
    public void setNetherZone(NetherZone nz, boolean save) {
        if (this.netherConversionZone == null) {
            this.netherConversionZone = nz;
            if (!this.level.m_5776_()) {
                BuildingServerEvents.netherZones.add(this.netherConversionZone);
                if (save) {
                    BuildingServerEvents.saveNetherZones((ServerLevel)this.level);
                }
            }
        }
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        if (this.getMaxNetherRange() > 0.0) {
            this.setNetherZone(new NetherZone(this.centrePos.m_7918_(0, -6, 0), this.getMaxNetherRange(), this.getStartingNetherRange()), true);
        }
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        BlockPos worldBp = relativeBp.m_121955_((Vec3i)this.originPos);
        Block block = this.getLevel().m_8055_(worldBp).m_60734_();
        return block != Blocks.f_50080_ && block != Blocks.f_50142_;
    }
}

