/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.NetherConvertingBuilding;
import com.solegendary.reignofnether.building.NetherZone;
import com.solegendary.reignofnether.building.NightSource;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import org.jetbrains.annotations.Nullable;

public class CustomBuildingPlacement
extends BuildingPlacement
implements RangeIndicator,
NightSource,
NetherConvertingBuilding,
GarrisonableBuilding {
    public NetherZone netherConversionZone = null;
    private final Set<BlockPos> nightBorderBps = new HashSet<BlockPos>();
    private final ArrayList<BlockPos> garrisonEntries = new ArrayList();
    private final ArrayList<BlockPos> garrisonExits = new ArrayList();
    private final Random random = new Random();
    public static final List<Block> INVULNERABLE_BLOCKS = List.of((Block)BlockRegistrar.GARRISON_EXIT_BLOCK.get(), (Block)BlockRegistrar.GARRISON_ENTRY_BLOCK.get(), (Block)BlockRegistrar.GARRISON_ZONE_BLOCK.get(), Blocks.f_50142_, Blocks.f_152480_, Blocks.f_50272_, Blocks.f_50448_, Blocks.f_50447_);
    public static final List<Block> INVULNERABLE_ABOVE_BLOCKS = List.of((Block)BlockRegistrar.GARRISON_ENTRY_BLOCK.get(), (Block)BlockRegistrar.GARRISON_ZONE_BLOCK.get());

    public CustomBuildingPlacement(CustomBuilding customBuilding, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol) {
        super(customBuilding, level, originPos, rotation, ownerName, blocks, isCapitol);
        for (BuildingBlock bb : blocks) {
            if (bb.getBlockState().m_60734_() == BlockRegistrar.GARRISON_ENTRY_BLOCK.get()) {
                this.garrisonEntries.add(bb.getBlockPos());
                continue;
            }
            if (bb.getBlockState().m_60734_() != BlockRegistrar.GARRISON_EXIT_BLOCK.get()) continue;
            this.garrisonExits.add(bb.getBlockPos());
        }
    }

    public CustomBuilding getCustomBuilding() {
        return (CustomBuilding)this.getBuilding();
    }

    @Override
    public double getMaxNetherRange() {
        return this.getCustomBuilding().netherRadius;
    }

    @Override
    public double getStartingNetherRange() {
        return 3.0;
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        this.updateBorderBps();
        if (this.getMaxNetherRange() > 0.0) {
            this.setNetherZone(new NetherZone(new BlockPos(this.centrePos.m_123341_(), this.originPos.m_123342_() + 1, this.centrePos.m_123343_()), this.getMaxNetherRange(), this.getStartingNetherRange()), true);
        }
    }

    @Override
    @Nullable
    public NetherZone getNetherZone() {
        if (this.getCustomBuilding().netherRadius > 0) {
            return this.netherConversionZone;
        }
        return null;
    }

    @Override
    public void setNetherZone(NetherZone nz, boolean save) {
        if (this.netherConversionZone == null) {
            this.netherConversionZone = nz;
            if (!this.level.m_5776_()) {
                BuildingServerEvents.netherZones.add(this.netherConversionZone);
                if (save) {
                    BuildingServerEvents.saveNetherZones((ServerLevel)this.level);
                }
            }
        }
    }

    @Override
    public int getNightRange() {
        return this.getCustomBuilding().nightRadius;
    }

    @Override
    public void updateBorderBps() {
        if (!this.level.m_5776_() || this.getNightRange() <= 0) {
            return;
        }
        this.nightBorderBps.clear();
        this.nightBorderBps.addAll(MiscUtil.getRangeIndicatorCircleBlocks(this.centrePos, this.getNightRange() - 2, this.level));
    }

    @Override
    public Set<BlockPos> getBorderBps() {
        return this.nightBorderBps;
    }

    @Override
    public boolean showOnlyWhenSelected() {
        return false;
    }

    @Override
    public int getAttackRange() {
        return this.getCustomBuilding().garrisonRange;
    }

    @Override
    public int getExternalAttackRangeBonus() {
        return Math.min(15, this.getCustomBuilding().garrisonRange / 2);
    }

    @Override
    public int getCapacity() {
        return this.getCustomBuilding().garrisonCapacity;
    }

    @Override
    public BlockPos getEntryPosition() {
        if (!this.garrisonEntries.isEmpty()) {
            return this.garrisonEntries.get(this.random.nextInt(this.garrisonEntries.size())).m_7494_();
        }
        return null;
    }

    @Override
    public BlockPos getExitPosition() {
        if (!this.garrisonExits.isEmpty()) {
            return this.garrisonExits.get(this.random.nextInt(this.garrisonExits.size())).m_7494_();
        }
        return null;
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        if (this.getCapacity() <= 0) {
            return true;
        }
        BlockPos worldBp = relativeBp.m_121955_((Vec3i)this.originPos);
        Block block = this.getLevel().m_8055_(worldBp).m_60734_();
        BlockPos worldBpAbove = relativeBp.m_121955_((Vec3i)this.originPos.m_7494_());
        Block blockAbove = this.getLevel().m_8055_(worldBpAbove).m_60734_();
        return !INVULNERABLE_BLOCKS.contains(block) && !INVULNERABLE_ABOVE_BLOCKS.contains(blockAbove);
    }
}

