/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.placements;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.buildings.placements.DarknessProductionBuilding;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;

public class StrongholdPlacement
extends DarknessProductionBuilding
implements GarrisonableBuilding {
    public static final int MAX_OCCUPANTS = 7;

    public StrongholdPlacement(Building building, Level level, BlockPos originPos, Rotation rotation, String ownerName, ArrayList<BuildingBlock> blocks, boolean isCapitol, int range, boolean checkUpgraded, boolean checkBuiltServerside) {
        super(building, level, originPos, rotation, ownerName, blocks, isCapitol, range, checkUpgraded, checkBuiltServerside);
    }

    @Override
    public void onBuilt() {
        super.onBuilt();
        this.updateBorderBps();
    }

    @Override
    public int getAttackRange() {
        return 30;
    }

    @Override
    public int getExternalAttackRangeBonus() {
        return 15;
    }

    @Override
    public boolean canDestroyBlock(BlockPos relativeBp) {
        return relativeBp.m_123342_() != 13 && relativeBp.m_123342_() != 14;
    }

    @Override
    public BlockPos getIndoorSpawnPoint(ServerLevel level) {
        return this.getExitPosition();
    }

    @Override
    public BlockPos getEntryPosition() {
        return this.originPos.m_121955_((Vec3i)GarrisonableBuilding.rotatePos(new BlockPos(5, 14, 5), this.rotation));
    }

    @Override
    public BlockPos getExitPosition() {
        return this.originPos.m_121955_((Vec3i)GarrisonableBuilding.rotatePos(new BlockPos(5, 2, 6), this.rotation));
    }

    @Override
    public int getCapacity() {
        return 7;
    }
}

