/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.villagers;

import com.solegendary.reignofnether.ability.abilities.PromoteIllager;
import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.CastlePlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.util.Faction;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class Castle
extends ProductionBuilding {
    public static final String buildingName = "Castle";
    public static final String structureName = "castle";
    public static final String upgradedStructureName = "castle_with_flag";
    public static final ResourceCost cost = ResourceCosts.CASTLE;

    public Castle() {
        super(structureName, cost, false);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50652_;
        this.icon = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/cobblestone.png");
        this.buildTimeModifier = 0.5f;
        this.startingBlockTypes.add(Blocks.f_50222_);
        this.startingBlockTypes.add(Blocks.f_50609_);
        this.startingBlockTypes.add(Blocks.f_50399_);
        this.startingBlockTypes.add(Blocks.f_50741_);
        this.startingBlockTypes.add(Blocks.f_50745_);
        PromoteIllager promoteIllager = new PromoteIllager();
        this.abilities.add(promoteIllager, Keybindings.keyE);
        this.productions.add(ProductionItems.RAVAGER, Keybindings.keyQ);
        this.productions.add(ProductionItems.RESEARCH_RAVAGER_CAVALRY, Keybindings.keyW);
        this.productions.add(ProductionItems.RESEARCH_CASTLE_FLAG, Keybindings.keyE);
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        return new CastlePlacement(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), false);
    }

    @Override
    public BuildingPlaceButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new BuildingPlaceButton(name, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/cobblestone.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.CASTLE, TutorialClientEvents::isEnabled, () -> BuildingClientEvents.hasFinishedBuilding(Buildings.BARRACKS) && BuildingClientEvents.hasFinishedBuilding(Buildings.BLACKSMITH) && BuildingClientEvents.hasFinishedBuilding(Buildings.ARCANE_TOWER) || ResearchClient.hasCheat("modifythephasevariance"), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.castle", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.castle.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.castle.tooltip2", (Object[])new Object[]{7}), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"buildings.villagers.reignofnether.castle.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public int getUpgradeLevel(BuildingPlacement placement) {
        for (BuildingBlock block : placement.getBlocks()) {
            if (block.getBlockState().m_60734_() != Blocks.f_50041_ && block.getBlockState().m_60734_() != Blocks.f_50108_ && block.getBlockState().m_60734_() != Blocks.f_50102_) continue;
            return 1;
        }
        return 0;
    }
}

