/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.buildings.villagers;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionBuilding;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;

public class ShrineOfProsperity
extends ProductionBuilding {
    public static final String buildingName = "Shrine of Prosperity";
    public static final String structureName = "shrine_of_prosperity";
    public static final ResourceCost cost = ResourceCosts.SHRINE_OF_PROSPERITY;

    public ShrineOfProsperity() {
        super(structureName, cost, false);
        this.name = buildingName;
        this.portraitBlock = Blocks.f_50003_;
        this.icon = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/acacia_log_top.png");
        this.startingBlockTypes.add(Blocks.f_50652_);
        this.productions.add(ProductionItems.ROYAL_GUARD, Keybindings.keyQ);
        this.productions.add(ProductionItems.ROYAL_GUARD_REVIVE, Keybindings.keyQ);
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        ProductionPlacement pp = (ProductionPlacement)super.createBuildingPlacement(level, pos, rotation, ownerName);
        pp.allowProdWhileBuilding = true;
        return pp;
    }

    @Override
    public Faction getFaction() {
        return Faction.VILLAGERS;
    }

    @Override
    public BuildingPlaceButton getBuildButton(Keybinding hotkey) {
        ResourceLocation key = ReignOfNetherRegistries.BUILDING.m_7981_((Object)this);
        String name = I18n.m_118938_((String)("buildings." + this.getFaction().name().toLowerCase() + "." + key.m_135827_() + "." + key.m_135815_()), (Object[])new Object[0]);
        return new BuildingPlaceButton(name, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/acacia_log_top.png"), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == Buildings.SHRINE_OF_PROSPERITY, () -> !SandboxClientEvents.isSandboxPlayer() && !GameruleClient.allowHeroes || TutorialClientEvents.isEnabled(), () -> BuildingClientEvents.hasFinishedBuilding(Buildings.TOWN_CENTRE) || ResearchClient.hasCheat("modifythephasevariance"), List.of(MiscUtil.fcs(I18n.m_118938_((String)"buildings.villagers.reignofnether.shrine_of_prosperity", (Object[])new Object[0]), true), ResourceCosts.getFormattedCost(cost), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"buildings.villagers.reignofnether.shrine_of_prosperity.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"buildings.villagers.reignofnether.shrine_of_prosperity.tooltip2", (Object[])new Object[0]))), this);
    }
}

