/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.CustomBuildingPlacement;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingAction;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingClientEvents;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingServerboundPacket;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import org.apache.commons.lang3.text.WordUtils;

public class CustomBuilding
extends Building {
    public Vec3i structureSize;
    public final CompoundTag structureNbt;
    public Set<Block> portraitBlockOptions;
    public CompoundTag attributesNbt = new CompoundTag();
    public int nightRadius = 0;
    public int netherRadius = 0;
    public boolean buildableByVillagers = false;
    public boolean buildableByMonsters = false;
    public boolean buildableByPiglins = false;
    public int garrisonCapacity = 0;
    public int garrisonRange = 20;
    public int numGarrisonZones = 0;
    public int numGarrisonEntries = 0;
    public int numGarrisonExits = 0;

    public CustomBuilding(String structureName, Vec3i structureSize, Block portraitBlock, CompoundTag structureNbt) {
        this(structureName, structureSize, portraitBlock, structureNbt, null);
    }

    public CustomBuilding(String structureName, Vec3i structureSize, Block portraitBlock, CompoundTag structureNbt, CompoundTag attributesNbt) {
        super(structureName, ResourceCost.Building(0, 0, 0, 0), false);
        this.name = WordUtils.capitalize((String)structureName.replace("minecraft:", "").replace("reignofnether:", "").replace("_", " "));
        this.structureSize = structureSize;
        this.structureNbt = structureNbt;
        this.portraitBlock = portraitBlock;
        this.icon = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/command_block_front.png");
        this.startingBlockTypes.addAll(BuildingBlockData.getBuildingBlocksFromNbt(this.structureNbt).stream().filter(bb -> bb.getBlockPos().m_123342_() == 0).map(bb -> bb.getBlockState().m_60734_()).toList());
        this.portraitBlockOptions = BuildingBlockData.getBuildingBlocksFromNbt(this.structureNbt).stream().filter(bb -> !List.of((Block)BlockRegistrar.GARRISON_EXIT_BLOCK.get(), (Block)BlockRegistrar.GARRISON_ENTRY_BLOCK.get(), (Block)BlockRegistrar.GARRISON_ZONE_BLOCK.get()).contains(bb.getBlockState().m_60734_())).map(bb -> bb.getBlockState().m_60734_()).collect(Collectors.toSet());
        this.packAttributesNbt();
        if (attributesNbt != null) {
            this.attributesNbt = attributesNbt;
            this.unpackAttributesNbt();
        }
        for (BuildingBlock bb2 : BuildingBlockData.getBuildingBlocksFromNbt(structureNbt)) {
            if (bb2.getBlockState().m_60734_() == BlockRegistrar.GARRISON_ZONE_BLOCK.get()) {
                ++this.numGarrisonZones;
                continue;
            }
            if (bb2.getBlockState().m_60734_() == BlockRegistrar.GARRISON_ENTRY_BLOCK.get()) {
                ++this.numGarrisonEntries;
                continue;
            }
            if (bb2.getBlockState().m_60734_() != BlockRegistrar.GARRISON_EXIT_BLOCK.get()) continue;
            ++this.numGarrisonExits;
        }
    }

    public void packAttributesNbt() {
        this.attributesNbt.m_128359_("portraitBlockRegistryKey", this.getPortraitBlockRegistryKey());
        this.attributesNbt.m_128379_("capturable", this.capturable);
        this.attributesNbt.m_128379_("invulnerable", this.invulnerable);
        this.attributesNbt.m_128405_("nightRadius", this.nightRadius);
        this.attributesNbt.m_128405_("netherRadius", this.netherRadius);
        this.attributesNbt.m_128379_("buildableByVillagers", this.buildableByVillagers);
        this.attributesNbt.m_128379_("buildableByMonsters", this.buildableByMonsters);
        this.attributesNbt.m_128379_("buildableByPiglins", this.buildableByPiglins);
        this.attributesNbt.m_128405_("foodCost", this.cost.food);
        this.attributesNbt.m_128405_("woodCost", this.cost.wood);
        this.attributesNbt.m_128405_("oreCost", this.cost.ore);
        this.attributesNbt.m_128405_("garrisonCapacity", this.garrisonCapacity);
        this.attributesNbt.m_128405_("garrisonRange", this.garrisonRange);
    }

    private void unpackAttributesNbt() {
        this.setIconAndPortrait(this.attributesNbt.m_128461_("portraitBlockRegistryKey"));
        this.capturable = this.attributesNbt.m_128471_("capturable");
        this.invulnerable = this.attributesNbt.m_128471_("invulnerable");
        this.nightRadius = this.attributesNbt.m_128451_("nightRadius");
        this.netherRadius = this.attributesNbt.m_128451_("netherRadius");
        this.buildableByVillagers = this.attributesNbt.m_128471_("buildableByVillagers");
        this.buildableByMonsters = this.attributesNbt.m_128471_("buildableByMonsters");
        this.buildableByPiglins = this.attributesNbt.m_128471_("buildableByPiglins");
        this.cost.food = this.attributesNbt.m_128451_("foodCost");
        this.cost.wood = this.attributesNbt.m_128451_("woodCost");
        this.cost.ore = this.attributesNbt.m_128451_("oreCost");
        this.garrisonCapacity = this.attributesNbt.m_128451_("garrisonCapacity");
        this.garrisonRange = this.attributesNbt.m_128451_("garrisonRange");
    }

    @Override
    public BuildingPlacement createBuildingPlacement(Level level, BlockPos pos, Rotation rotation, String ownerName) {
        return new CustomBuildingPlacement(this, level, pos, rotation, ownerName, BuildingUtils.getAbsoluteBlockData(this.getRelativeBlockData((LevelAccessor)level), (LevelAccessor)level, pos, rotation), true);
    }

    @Override
    public ArrayList<BuildingBlock> getRelativeBlockData(LevelAccessor level) {
        return BuildingBlockData.getBuildingBlocksFromNbt(this.structureNbt);
    }

    @Override
    public Faction getFaction() {
        return Faction.NONE;
    }

    public BuildingPlaceButton getWorkerBuildButton(Keybinding hotkey) {
        return new BuildingPlaceButton(this.name, MiscUtil.getTextureForBlock(this.portraitBlock), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == this, () -> false, () -> true, this.getWorkerBuildTooltips(), this);
    }

    private List<FormattedCharSequence> getWorkerBuildTooltips() {
        ArrayList<FormattedCharSequence> tooltips = new ArrayList<FormattedCharSequence>();
        tooltips.add(MiscUtil.fcs(this.name, true));
        if (this.cost.food > 0 || this.cost.ore > 0 || this.cost.wood > 0) {
            tooltips.add(ResourceCosts.getFormattedCost(this.cost));
        }
        if (this.capturable) {
            tooltips.add(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_capturable.label", (Object[])new Object[0])));
        }
        if (this.invulnerable) {
            tooltips.add(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_invulnerable.label", (Object[])new Object[0])));
        }
        if (this.nightRadius > 0) {
            tooltips.add(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_night_radius.label", (Object[])new Object[0]) + ": " + this.nightRadius));
        }
        if (this.netherRadius > 0) {
            tooltips.add(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_nether_radius.label", (Object[])new Object[0]) + ": " + this.netherRadius));
        }
        if (this.garrisonCapacity > 0) {
            tooltips.add(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_garrison_capacity.label", (Object[])new Object[0]) + ": " + this.garrisonCapacity));
        }
        if (this.garrisonRange > 0) {
            tooltips.add(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_garrison_range.label", (Object[])new Object[0]) + ": " + this.garrisonRange));
        }
        return tooltips;
    }

    @Override
    public BuildingPlaceButton getBuildButton(Keybinding hotkey) {
        BuildingPlaceButton button = new BuildingPlaceButton(this.name, MiscUtil.getTextureForBlock(this.portraitBlock), hotkey, () -> BuildingClientEvents.getBuildingToPlace() == this, () -> false, () -> true, List.of(MiscUtil.fcs(this.name, true), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings_info.building_menu", (Object[])new Object[0]))), this);
        button.onRightClick = () -> CustomBuildingClientEvents.setCustomBuildingToEdit(this);
        return button;
    }

    public String getPortraitBlockRegistryKey() {
        return BuiltInRegistries.f_256975_.m_7981_((Object)this.portraitBlock).toString();
    }

    public void setIconAndPortrait(String blockRegistryKey) {
        this.portraitBlock = (Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(blockRegistryKey));
    }

    public void cycleIconAndPortrait(boolean reverse) {
        ArrayList<Block> blockOptions = new ArrayList<Block>(this.portraitBlockOptions.stream().filter(b -> !b.m_49966_().m_60795_()).toList());
        if (reverse) {
            Collections.reverse(blockOptions);
        }
        boolean foundCurrentPortrait = false;
        boolean changedPortrait = false;
        for (Block block : blockOptions) {
            if (foundCurrentPortrait) {
                this.portraitBlock = block;
                changedPortrait = true;
                break;
            }
            if (block != this.portraitBlock) continue;
            foundCurrentPortrait = true;
        }
        if (!changedPortrait) {
            this.portraitBlock = blockOptions.get(0);
        }
        CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_PORTRAIT_BLOCK, this.name, this.getPortraitBlockRegistryKey());
    }
}

