/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.blocks.RTSStructureBlockEntity;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingMenu;
import com.solegendary.reignofnether.guiscreen.TopdownGui;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.RectZone;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CustomBuildingClientEvents {
    public static final ArrayList<CustomBuilding> customBuildings = new ArrayList();
    public static final ArrayList<BlockPos> rtsStructuresToRenderBB = new ArrayList();
    private static final Minecraft MC = Minecraft.m_91087_();
    private static CustomBuilding customBuildingToEdit = null;
    private static final ArrayList<Button> renderedButtons = new ArrayList();
    private static final ArrayList<RectZone> hudZones = new ArrayList();

    public static void setCustomBuildingToEdit(CustomBuilding customBuilding) {
        customBuildingToEdit = customBuildingToEdit != customBuilding ? customBuilding : null;
    }

    public static CustomBuilding getCustomBuildingToEdit() {
        return customBuildingToEdit;
    }

    public static Building getCustomBuilding(String name) {
        for (CustomBuilding customBuilding : customBuildings) {
            if (!customBuilding.name.equals(name)) continue;
            return customBuilding;
        }
        return null;
    }

    public static void registerCustomBuilding(String playerName, String name, Vec3i structureSize, CompoundTag structureNbt, CompoundTag attributesNbt) {
        if (CustomBuildingClientEvents.MC.f_91074_ == null || !playerName.isEmpty() && !CustomBuildingClientEvents.MC.f_91074_.m_7755_().getString().equals(playerName)) {
            return;
        }
        for (CustomBuilding customBuilding : customBuildings) {
            if (!customBuilding.name.equals(name)) continue;
            CustomBuildingClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)("ERROR (client): custom building '" + name + "' already exists")));
            return;
        }
        ArrayList<BuildingBlock> blocks = BuildingBlockData.getBuildingBlocksFromNbt(structureNbt);
        Block portraitBlock = Blocks.f_50272_;
        for (BuildingBlock bb : blocks) {
            BlockState bs = bb.getBlockState();
            if (bs.m_60795_() || !bs.m_60819_().m_76178_()) continue;
            portraitBlock = bs.m_60734_();
        }
        CustomBuilding building = new CustomBuilding(name, structureSize, portraitBlock, structureNbt, attributesNbt);
        customBuildings.add(building);
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) throws NoSuchFieldException {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || CustomBuildingClientEvents.MC.f_91073_ == null) {
            return;
        }
        for (BlockPos bp : rtsStructuresToRenderBB) {
            BlockEntity blockEntity = CustomBuildingClientEvents.MC.f_91073_.m_7702_(bp);
            if (!(blockEntity instanceof RTSStructureBlockEntity)) continue;
            RTSStructureBlockEntity be = (RTSStructureBlockEntity)blockEntity;
            BlockPos pos = be.m_59902_();
            Vec3i size = be.m_155805_();
            MyRenderer.drawLineBox(evt.getPoseStack(), new AABB((double)(bp.m_123341_() + pos.m_123341_()), (double)(bp.m_123342_() + pos.m_123342_()), (double)(bp.m_123343_() + pos.m_123343_()), (double)(bp.m_123341_() + pos.m_123341_() + size.m_123341_()), (double)(bp.m_123342_() + pos.m_123342_() + size.m_123342_()), (double)(bp.m_123343_() + pos.m_123343_() + size.m_123343_())), 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onDrawScreen(ScreenEvent.Render.Post evt) {
        hudZones.clear();
        renderedButtons.clear();
        if (customBuildingToEdit != null && CustomBuildingClientEvents.MC.f_91080_ instanceof TopdownGui) {
            int blitX = 100;
            int blitY = 40;
            int width = 300;
            int height = 200;
            MyRenderer.renderFrameWithBg(evt.getGuiGraphics(), blitX, blitY, width, height, -1610612736);
            renderedButtons.add(CustomBuildingMenu.renderIconButtonNameAndPortrait(evt, customBuildingToEdit, blitX + 18, blitY + 18));
            renderedButtons.add(CustomBuildingMenu.renderCloseButton(evt, blitX + width - Button.itemIconSize - 12, blitY + 4));
            renderedButtons.add(CustomBuildingMenu.renderDeregisterButton(evt, blitX + width - Button.itemIconSize - 12, blitY + height - 26));
            renderedButtons.addAll(CustomBuildingMenu.renderCustomisationButtons(evt, blitX + 6, blitY + 38));
            evt.getGuiGraphics().m_280488_(CustomBuildingClientEvents.MC.f_91062_, "More options coming soon!", blitX + 10, blitY + height - 18, 0xFFFFFF);
            hudZones.add(new RectZone(blitX, blitY, blitX + width, blitY + height));
        }
    }

    public static boolean isMouseOverHud(int mouseX, int mouseY) {
        for (RectZone hudZone : hudZones) {
            if (!hudZone.isMouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onMousePress(ScreenEvent.MouseButtonPressed.Post evt) {
        for (Button button : renderedButtons) {
            if (evt.getButton() == 0) {
                button.checkClicked((int)evt.getMouseX(), (int)evt.getMouseY(), true);
                continue;
            }
            if (evt.getButton() != 1) continue;
            button.checkClicked((int)evt.getMouseX(), (int)evt.getMouseY(), false);
        }
    }
}

