/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingAction;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingClientEvents;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingServerboundPacket;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.PortraitRendererBuilding;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.event.ScreenEvent;

public class CustomBuildingMenu {
    private static Minecraft MC = Minecraft.m_91087_();
    public static PortraitRendererBuilding portraitRendererBuilding = new PortraitRendererBuilding();

    public static Button renderIconButtonNameAndPortrait(ScreenEvent.Render.Post evt, CustomBuilding building, int x, int y) {
        Button iconButton = new Button("Change Building Icon", Button.itemIconSize, MiscUtil.getTextureForBlock(building.portraitBlock), (Keybinding)null, () -> false, () -> false, () -> true, () -> building.cycleIconAndPortrait(false), () -> building.cycleIconAndPortrait(true), List.of(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.change_icon.tooltip1", (Object[])new Object[0]))));
        portraitRendererBuilding.drawBlockOnScreen(x + 2, y - 22, building.portraitBlock, 4.0f);
        evt.getGuiGraphics().m_280648_(CustomBuildingMenu.MC.f_91062_, MiscUtil.fcs(building.name, true), x + 52, y, 0xFFFFFF);
        CustomBuildingMenu.renderButton(iconButton, x - 8, y - 8, evt);
        return iconButton;
    }

    public static Button renderCloseButton(ScreenEvent.Render.Post evt, int x, int y) {
        Button closeButton = new Button("Close Custom Building Menu", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/cross_square.png"), (Keybinding)null, () -> false, () -> false, () -> true, () -> CustomBuildingClientEvents.setCustomBuildingToEdit(null), null, List.of());
        closeButton.frameResource = null;
        CustomBuildingMenu.renderButton(closeButton, x, y, evt);
        return closeButton;
    }

    public static Button renderDeregisterButton(ScreenEvent.Render.Post evt, int x, int y) {
        CustomBuilding building = CustomBuildingClientEvents.getCustomBuildingToEdit();
        Button deregisterButton = new Button("Deregister Custom Building", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/barrier.png"), (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            CustomBuildingServerboundPacket.deregisterBuilding(building.name);
            CustomBuildingClientEvents.customBuildings.removeIf(b -> b.name.equals(building.name));
            BuildingClientEvents.clearSelectedBuildings();
            BuildingClientEvents.getBuildings().removeIf(b -> b.getBuilding().name.equals(building.name));
            CustomBuildingClientEvents.setCustomBuildingToEdit(null);
        }, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.deregister.tooltip1", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.deregister.tooltip2", (Object[])new Object[0]))));
        deregisterButton.frameResource = null;
        CustomBuildingMenu.renderButton(deregisterButton, x, y, evt);
        return deregisterButton;
    }

    private static void renderButton(Button button, int x, int y, ScreenEvent.Render.Post evt) {
        if (!button.isHidden.get().booleanValue()) {
            button.render(evt.getGuiGraphics(), x, y, evt.getMouseX(), evt.getMouseY());
            if (button.isMouseOver(evt.getMouseX(), evt.getMouseY()) && button.tooltipLines != null) {
                button.renderTooltip(evt.getGuiGraphics(), evt.getMouseX(), evt.getMouseY());
            }
        }
    }

    public static List<Button> renderCustomisationButtons(ScreenEvent.Render.Post evt, int x, int y) {
        int origX = x;
        int origY = y;
        ArrayList<Button> buttonsCol1 = new ArrayList<Button>();
        ArrayList<Button> buttonsCol2 = new ArrayList<Button>();
        CustomBuilding customBuilding = CustomBuildingClientEvents.getCustomBuildingToEdit();
        buttonsCol1.add(new CustomBuildingBooleanButton(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_buildable_by_villagers.label", (Object[])new Object[0]), customBuilding.buildableByVillagers, () -> {
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_BUILDABLE_BY_VILLAGERS, customBuilding.name, !customBuilding.buildableByVillagers);
            customBuilding.buildableByVillagers = !customBuilding.buildableByVillagers;
        }, I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_buildable_by_villagers.tooltip1", (Object[])new Object[0])));
        buttonsCol1.add(new CustomBuildingBooleanButton(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_buildable_by_monsters.label", (Object[])new Object[0]), customBuilding.buildableByMonsters, () -> {
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_BUILDABLE_BY_VILLAGERS, customBuilding.name, !customBuilding.buildableByMonsters);
            customBuilding.buildableByMonsters = !customBuilding.buildableByMonsters;
        }, I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_buildable_by_monsters.tooltip1", (Object[])new Object[0])));
        buttonsCol1.add(new CustomBuildingBooleanButton(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_buildable_by_piglins.label", (Object[])new Object[0]), customBuilding.buildableByPiglins, () -> {
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_BUILDABLE_BY_PIGLINS, customBuilding.name, !customBuilding.buildableByPiglins);
            customBuilding.buildableByPiglins = !customBuilding.buildableByPiglins;
        }, I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_buildable_by_piglins.tooltip1", (Object[])new Object[0])));
        CustomBuildingIntegerButton setFoodCostButton = new CustomBuildingIntegerButton(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_food_cost.label", (Object[])new Object[0]) + ": " + customBuilding.cost.food, () -> {
            int value = Math.min(10000, customBuilding.cost.food + (Keybindings.shiftMod.isDown() ? 100 : 5));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_FOOD_COST, customBuilding.name, value);
            customBuilding.cost.food = value;
        }, () -> {
            int value = Math.max(0, customBuilding.cost.food - (Keybindings.shiftMod.isDown() ? 100 : 5));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_FOOD_COST, customBuilding.name, value);
            customBuilding.cost.food = value;
        }, I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_food_cost.tooltip1", (Object[])new Object[0]));
        setFoodCostButton.iconResource = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/wheat.png");
        buttonsCol1.add(setFoodCostButton);
        CustomBuildingIntegerButton setWoodCostButton = new CustomBuildingIntegerButton(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_wood_cost.label", (Object[])new Object[0]) + ": " + customBuilding.cost.wood, () -> {
            int value = Math.min(10000, customBuilding.cost.wood + (Keybindings.shiftMod.isDown() ? 100 : 5));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_WOOD_COST, customBuilding.name, value);
            customBuilding.cost.wood = value;
        }, () -> {
            int value = Math.max(0, customBuilding.cost.wood - (Keybindings.shiftMod.isDown() ? 100 : 5));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_WOOD_COST, customBuilding.name, value);
            customBuilding.cost.wood = value;
        }, I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_wood_cost.tooltip1", (Object[])new Object[0]));
        setWoodCostButton.iconResource = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/wood.png");
        buttonsCol1.add(setWoodCostButton);
        CustomBuildingIntegerButton setOreCostButton = new CustomBuildingIntegerButton(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_ore_cost.label", (Object[])new Object[0]) + ": " + customBuilding.cost.ore, () -> {
            int value = Math.min(10000, customBuilding.cost.ore + (Keybindings.shiftMod.isDown() ? 100 : 5));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_ORE_COST, customBuilding.name, value);
            customBuilding.cost.ore = value;
        }, () -> {
            int value = Math.max(0, customBuilding.cost.ore - (Keybindings.shiftMod.isDown() ? 100 : 5));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_ORE_COST, customBuilding.name, value);
            customBuilding.cost.ore = value;
        }, I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_ore_cost.tooltip1", (Object[])new Object[0]));
        setOreCostButton.iconResource = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/iron_ore.png");
        buttonsCol1.add(setOreCostButton);
        buttonsCol2.add(new CustomBuildingBooleanButton(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_capturable.label", (Object[])new Object[0]), customBuilding.capturable, () -> {
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_CAPTURABLE, customBuilding.name, !customBuilding.capturable);
            customBuilding.capturable = !customBuilding.capturable;
        }, I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_capturable.tooltip1", (Object[])new Object[0])));
        buttonsCol2.add(new CustomBuildingBooleanButton(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_invulnerable.label", (Object[])new Object[0]), customBuilding.invulnerable, () -> {
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_INVULNERABLE, customBuilding.name, !customBuilding.invulnerable);
            customBuilding.invulnerable = !customBuilding.invulnerable;
        }, I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_invulnerable.tooltip1", (Object[])new Object[0])));
        CustomBuildingIntegerButton setNightRadiusButton = new CustomBuildingIntegerButton(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_night_radius.label", (Object[])new Object[0]) + ": " + customBuilding.nightRadius, () -> {
            int value = Math.min(200, customBuilding.nightRadius + (Keybindings.shiftMod.isDown() ? 10 : 1));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_NIGHT_RADIUS, customBuilding.name, value);
            customBuilding.nightRadius = value;
        }, () -> {
            int value = Math.max(0, customBuilding.nightRadius - (Keybindings.shiftMod.isDown() ? 10 : 1));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_NIGHT_RADIUS, customBuilding.name, value);
            customBuilding.nightRadius = value;
        }, I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_night_radius.tooltip1", (Object[])new Object[0]));
        setNightRadiusButton.iconResource = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/moon.png");
        buttonsCol2.add(setNightRadiusButton);
        CustomBuildingIntegerButton setNetherRadiusButton = new CustomBuildingIntegerButton(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_nether_radius.label", (Object[])new Object[0]) + ": " + customBuilding.netherRadius, () -> {
            int value = Math.min(200, customBuilding.netherRadius + (Keybindings.shiftMod.isDown() ? 10 : 1));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_NETHER_RADIUS, customBuilding.name, value);
            customBuilding.netherRadius = value;
        }, () -> {
            int value = Math.max(0, customBuilding.netherRadius - (Keybindings.shiftMod.isDown() ? 10 : 1));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_NETHER_RADIUS, customBuilding.name, value);
            customBuilding.netherRadius = value;
        }, I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_nether_radius.tooltip1", (Object[])new Object[0]));
        setNetherRadiusButton.iconResource = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/portal.png");
        buttonsCol2.add(setNetherRadiusButton);
        CustomBuildingIntegerButton setGarrisonCapacityButton = new CustomBuildingIntegerButton(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_garrison_capacity.label", (Object[])new Object[0]) + ": " + customBuilding.garrisonCapacity, () -> {
            int value = Math.min(100, customBuilding.garrisonCapacity + (Keybindings.shiftMod.isDown() ? 10 : 1));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_GARRISON_CAPACITY, customBuilding.name, value);
            customBuilding.garrisonCapacity = value;
        }, () -> {
            int value = Math.max(0, customBuilding.garrisonCapacity - (Keybindings.shiftMod.isDown() ? 10 : 1));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_GARRISON_CAPACITY, customBuilding.name, value);
            customBuilding.garrisonCapacity = value;
        }, CustomBuildingMenu.getGarrisonTooltips(customBuilding, I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_garrison_capacity.tooltip1", (Object[])new Object[0])));
        setGarrisonCapacityButton.iconResource = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/ladder.png");
        buttonsCol2.add(setGarrisonCapacityButton);
        CustomBuildingIntegerButton setGarrisonBonusRangeButton = new CustomBuildingIntegerButton(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_garrison_range.label", (Object[])new Object[0]) + ": " + customBuilding.garrisonRange, () -> {
            int value = Math.min(100, customBuilding.garrisonRange + (Keybindings.shiftMod.isDown() ? 10 : 1));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_GARRISON_RANGE, customBuilding.name, value);
            customBuilding.garrisonRange = value;
        }, () -> {
            int value = Math.max(0, customBuilding.garrisonRange - (Keybindings.shiftMod.isDown() ? 10 : 1));
            CustomBuildingServerboundPacket.customiseBuilding(CustomBuildingAction.SET_GARRISON_RANGE, customBuilding.name, value);
            customBuilding.garrisonRange = value;
        }, CustomBuildingMenu.getGarrisonTooltips(customBuilding, I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.set_garrison_range.tooltip1", (Object[])new Object[0])));
        setGarrisonBonusRangeButton.iconResource = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/bow.png");
        buttonsCol2.add(setGarrisonBonusRangeButton);
        for (Button button : buttonsCol1) {
            CustomBuildingMenu.renderButton(button, x, y, evt);
            y += 18;
        }
        x += 150;
        y = origY;
        for (Button button : buttonsCol2) {
            CustomBuildingMenu.renderButton(button, x, y, evt);
            y += 18;
        }
        return Stream.of(buttonsCol1, buttonsCol2).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static List<FormattedCharSequence> getGarrisonTooltips(CustomBuilding customBuilding, String originalTooltip) {
        ArrayList<FormattedCharSequence> tooltips = new ArrayList<FormattedCharSequence>();
        tooltips.add(MiscUtil.fcs(originalTooltip));
        if (customBuilding.numGarrisonZones <= 0) {
            tooltips.add(MiscUtil.fcsIcons(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.garrison_warning.no_zones", (Object[])new Object[0])));
        } else if (customBuilding.numGarrisonEntries <= 0) {
            tooltips.add(MiscUtil.fcsIcons(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.garrison_warning.no_entry", (Object[])new Object[0])));
        } else if (customBuilding.numGarrisonEntries > 1) {
            tooltips.add(MiscUtil.fcsIcons(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.garrison_warning.multiple_entries", (Object[])new Object[0])));
        }
        if (customBuilding.numGarrisonExits <= 0) {
            tooltips.add(MiscUtil.fcsIcons(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.garrison_warning.no_exit", (Object[])new Object[0])));
        } else if (customBuilding.numGarrisonExits > 1) {
            tooltips.add(MiscUtil.fcsIcons(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings.garrison_warning.multiple_exits", (Object[])new Object[0])));
        }
        return tooltips;
    }

    private static class CustomBuildingBooleanButton
    extends Button {
        private final String label;

        public CustomBuildingBooleanButton(String label, boolean enabled, Runnable onLeftClick, String tooltip) {
            super("Boolean Customise Building", 10, enabled ? ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/tick.png") : ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/cross.png"), (Keybinding)null, () -> false, () -> false, () -> true, onLeftClick, null, tooltip != null ? List.of(MiscUtil.fcs(tooltip)) : null);
            this.label = label;
            this.frameResource = null;
        }

        @Override
        public void render(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
            super.render(guiGraphics, x, y, mouseX, mouseY);
            if (!this.label.isBlank()) {
                guiGraphics.m_280488_(CustomBuildingMenu.MC.f_91062_, this.label, x + 23, y + 7, 0xFFFFFF);
            }
        }

        @Override
        public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.tooltipLines != null) {
                MyRenderer.renderTooltip(guiGraphics, this.tooltipLines, mouseX, mouseY + this.tooltipOffsetY - 10);
            }
        }
    }

    private static class CustomBuildingIntegerButton
    extends Button {
        private final String label;

        public CustomBuildingIntegerButton(String label, Runnable onLeftClick, Runnable onRightClick, List<FormattedCharSequence> tooltips) {
            super("Integer Customise Building", 10, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/command_block_back.png"), (Keybinding)null, () -> false, () -> false, () -> true, onLeftClick, onRightClick, tooltips);
            this.label = label;
        }

        public CustomBuildingIntegerButton(String label, Runnable onLeftClick, Runnable onRightClick, String tooltip) {
            this(label, onLeftClick, onRightClick, tooltip != null ? List.of(MiscUtil.fcs(tooltip)) : null);
        }

        @Override
        public void render(GuiGraphics guiGraphics, int x, int y, int mouseX, int mouseY) {
            super.render(guiGraphics, x, y, mouseX, mouseY);
            if (!this.label.isBlank()) {
                guiGraphics.m_280488_(CustomBuildingMenu.MC.f_91062_, this.label, x + 23, y + 7, 0xFFFFFF);
            }
        }

        @Override
        public void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (this.tooltipLines != null) {
                MyRenderer.renderTooltip(guiGraphics, this.tooltipLines, mouseX, mouseY + this.tooltipOffsetY - 10);
            }
        }
    }
}

