/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.custombuilding;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.blocks.RTSStructureBlockEntity;
import com.solegendary.reignofnether.building.BuildingBlock;
import com.solegendary.reignofnether.building.BuildingBlockData;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.placements.CustomBuildingPlacement;
import com.solegendary.reignofnether.building.custombuilding.CustomBuilding;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingClientboundPacket;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingSave;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingSaveData;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CustomBuildingServerEvents {
    private static final Set<CustomBuilding> customBuildings = new HashSet<CustomBuilding>();

    public static CustomBuilding getCustomBuilding(String name) {
        for (CustomBuilding building : customBuildings) {
            if (!building.name.equals(name)) continue;
            return building;
        }
        return null;
    }

    public static void deregisterCustomBuilding(String buildingName) {
        customBuildings.removeIf(b -> b.name.equals(buildingName));
        BuildingServerEvents.getBuildings().removeIf(b -> b.getBuilding().name.equals(buildingName));
        CustomBuildingServerEvents.saveCustomBuildings(BuildingServerEvents.getServerLevel());
    }

    public static boolean createAndRegisterNewCustomBuilding(ResourceLocation structureRL, String structureName, ServerLevel level, BlockPos pos) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof RTSStructureBlockEntity) {
            RTSStructureBlockEntity rtsBe = (RTSStructureBlockEntity)be;
            return CustomBuildingServerEvents.createAndRegisterNewCustomBuilding(structureRL, structureName, level, pos.m_7918_(1, 0, 1), rtsBe.m_155805_());
        }
        return true;
    }

    public static boolean createAndRegisterNewCustomBuilding(ResourceLocation structureRL, String structureName, ServerLevel level, BlockPos pos, Vec3i structureSize) {
        StructureTemplateManager manager = level.m_215082_();
        Optional template = manager.m_230407_(structureRL);
        CompoundTag structureNbt = null;
        if (template.isPresent()) {
            structureNbt = ((StructureTemplate)template.get()).m_74618_(new CompoundTag());
        }
        if (structureNbt != null) {
            BuildingServerEvents.getBuildings().removeIf(b -> b.originPos.equals((Object)pos));
            ArrayList<BuildingBlock> blocks = BuildingUtils.getAbsoluteBlockData(BuildingBlockData.getBuildingBlocksFromNbt(structureNbt), (LevelAccessor)level, pos, Rotation.NONE);
            int numSolidBlocks = 0;
            Block portraitBlock = Blocks.f_50272_;
            for (BuildingBlock buildingBlock : blocks) {
                BlockState bs = buildingBlock.getBlockState();
                if (bs.m_60795_() || !bs.m_60819_().m_76178_() || CustomBuildingPlacement.INVULNERABLE_BLOCKS.contains(buildingBlock.getBlockState().m_60734_())) continue;
                ++numSolidBlocks;
                portraitBlock = bs.m_60734_();
            }
            if (numSolidBlocks == 0) {
                PlayerServerEvents.sendMessageToAllPlayers("ERROR (server): cannot register custom building with no solid blocks");
            } else {
                CustomBuilding building = new CustomBuilding(structureName, structureSize, portraitBlock, structureNbt);
                for (CustomBuilding customBuilding : customBuildings) {
                    if (!customBuilding.name.equals(building.name)) continue;
                    PlayerServerEvents.sendMessageToAllPlayers("ERROR (server): custom building " + building.name + " already exists");
                    return false;
                }
                customBuildings.add(building);
                CustomBuildingPlacement customBuildingPlacement = new CustomBuildingPlacement(building, (Level)level, pos, Rotation.NONE, "", blocks, false);
                BuildingServerEvents.getBuildings().add(customBuildingPlacement);
                CustomBuildingClientboundPacket.registerCustomBuilding(building);
                CustomBuildingServerEvents.saveCustomBuildings(level);
                BuildingServerEvents.saveBuildings(level);
                BuildingServerEvents.placeBuildingClientside(pos);
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent evt) {
        ServerLevel level = evt.getServer().m_129880_(Level.f_46428_);
        if (level != null) {
            CustomBuildingServerEvents.saveCustomBuildings(level);
        }
    }

    public static void saveCustomBuildings(ServerLevel level) {
        CustomBuildingSaveData customBuildingData = CustomBuildingSaveData.getInstance((LevelAccessor)level);
        customBuildingData.customBuildings.clear();
        customBuildings.forEach(b -> {
            b.packAttributesNbt();
            customBuildingData.customBuildings.add(new CustomBuildingSave(b.structureNbt, b.name, b.structureSize, b.attributesNbt));
        });
        customBuildingData.save();
        level.m_8895_().m_78151_();
    }

    public static void loadCustomBuildings(ServerLevel level) {
        CustomBuildingSaveData customBuildingData = CustomBuildingSaveData.getInstance((LevelAccessor)level);
        customBuildingData.customBuildings.forEach(bSave -> {
            CustomBuilding building = new CustomBuilding(bSave.buildingName, bSave.structureSize, Blocks.f_50272_, bSave.structureNbt, bSave.attributesNbt);
            boolean buildingExists = false;
            for (CustomBuilding customBuilding : customBuildings) {
                if (!customBuilding.name.equals(building.name)) continue;
                buildingExists = true;
                break;
            }
            if (!buildingExists) {
                customBuildings.add(building);
            }
            ReignOfNether.LOGGER.info("loaded custom building in serverevents: " + bSave.buildingName);
        });
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (!PlayerServerEvents.rtsSyncingEnabled) {
            return;
        }
        MinecraftServer server = evt.getEntity().m_9236_().m_7654_();
        if (server == null || !server.m_6982_()) {
            CompletableFuture.delayedExecutor(1000L, TimeUnit.MILLISECONDS).execute(() -> CustomBuildingServerEvents.syncCustomBuildings(evt.getEntity().m_7755_().getString()));
        } else {
            CustomBuildingServerEvents.syncCustomBuildings(evt.getEntity().m_7755_().getString());
        }
    }

    private static void syncCustomBuildings(String playerName) {
        for (CustomBuilding customBuilding : customBuildings) {
            CustomBuildingClientboundPacket.registerCustomBuilding(playerName, customBuilding);
        }
    }
}

