/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.production;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ActiveProduction;
import com.solegendary.reignofnether.building.production.ProdDupeRule;
import com.solegendary.reignofnether.building.production.StartProductionButton;
import com.solegendary.reignofnether.building.production.StopProductionButton;
import com.solegendary.reignofnether.gamerules.GameruleClient;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.tps.TPSClientEvents;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public abstract class ProductionItem {
    public static String itemName;
    public ResourceCost defaultCost;
    public BiConsumer<Level, ProductionPlacement> onComplete;
    public ProdDupeRule dupeRule;

    public ProductionItem(ResourceCost cost, ProdDupeRule dupeRule) {
        this.defaultCost = cost;
        this.dupeRule = dupeRule;
    }

    public ProductionItem(ResourceCost cost) {
        this.defaultCost = cost;
        this.dupeRule = ProdDupeRule.ALLOW;
    }

    public ResourceCost getCost(boolean isClientSide, String ownerName) {
        return this.defaultCost;
    }

    public String getItemName() {
        return itemName;
    }

    public boolean canAfford(Level level, String ownerName) {
        for (Resources resources : ResourcesServerEvents.resourcesList) {
            if (!resources.ownerName.equals(ownerName)) continue;
            return resources.food >= this.getCost((boolean)level.m_5776_(), (String)ownerName).food && resources.wood >= this.getCost((boolean)level.m_5776_(), (String)ownerName).wood && resources.ore >= this.getCost((boolean)level.m_5776_(), (String)ownerName).ore && this.canAffordPopulation(level, ownerName);
        }
        return false;
    }

    public boolean canAffordPopulation(Level level, String ownerName) {
        if (this.getCost((boolean)level.m_5776_(), (String)ownerName).population == 0) {
            return true;
        }
        int currentPop = UnitServerEvents.getCurrentPopulation((ServerLevel)level, ownerName);
        int popSupply = BuildingServerEvents.getTotalPopulationSupply(ownerName);
        for (Resources resources : ResourcesServerEvents.resourcesList) {
            if (!resources.ownerName.equals(ownerName)) continue;
            return currentPop + this.getCost((boolean)level.m_5776_(), (String)ownerName).population <= popSupply;
        }
        return false;
    }

    public boolean isBelowPopulationSupply(Level level, String ownerName) {
        int popSupply;
        int currentPop;
        if (this.getCost((boolean)level.m_5776_(), (String)ownerName).population == 0) {
            return true;
        }
        if (level.m_5776_()) {
            currentPop = UnitClientEvents.getCurrentPopulation(ownerName);
            popSupply = BuildingClientEvents.getTotalPopulationSupply(ownerName);
        } else {
            currentPop = UnitServerEvents.getCurrentPopulation((ServerLevel)level, ownerName);
            popSupply = BuildingServerEvents.getTotalPopulationSupply(ownerName);
        }
        return currentPop <= popSupply;
    }

    public boolean isBelowMaxPopulation(Level level, String ownerName) {
        if (this.getCost((boolean)level.m_5776_(), (String)ownerName).population == 0) {
            return true;
        }
        int currentPop = UnitServerEvents.getCurrentPopulation((ServerLevel)level, ownerName);
        int popSupply = BuildingServerEvents.getTotalPopulationSupply(ownerName);
        for (Resources resources : ResourcesServerEvents.resourcesList) {
            if (!resources.ownerName.equals(ownerName)) continue;
            if (level.m_5776_()) {
                return currentPop + this.getCost((boolean)level.m_5776_(), (String)ownerName).population <= GameruleClient.maxPopulation;
            }
            return currentPop + this.getCost((boolean)level.m_5776_(), (String)ownerName).population <= UnitServerEvents.maxPopulation;
        }
        return false;
    }

    public boolean itemIsBeingProduced(String ownerName) {
        return this.itemIsBeingProduced(true, ownerName);
    }

    public boolean itemIsBeingProduced(boolean isClientSide, String ownerName) {
        List<BuildingPlacement> buildings = isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        for (BuildingPlacement building : buildings) {
            if (!building.ownerName.equals(ownerName) || !(building instanceof ProductionPlacement)) continue;
            ProductionPlacement prodBuilding = (ProductionPlacement)building;
            for (ActiveProduction prodItem : prodBuilding.productionQueue) {
                if (prodItem.item != this) continue;
                return true;
            }
        }
        return false;
    }

    public boolean itemIsBeingProducedAt(ProductionPlacement placement) {
        return this.itemIsBeingProducedAt(true, placement);
    }

    public boolean itemIsBeingProducedAt(boolean isClientSide, ProductionPlacement placement) {
        List<BuildingPlacement> buildings = isClientSide ? BuildingClientEvents.getBuildings() : BuildingServerEvents.getBuildings();
        for (BuildingPlacement building : buildings) {
            if (building != placement) continue;
            for (ActiveProduction prodItem : placement.productionQueue) {
                if (prodItem.item != this) continue;
                return true;
            }
        }
        return false;
    }

    public StartProductionButton getStartButton(ProductionPlacement prodBuilding, Keybinding keybinding) {
        return null;
    }

    public StopProductionButton getCancelButton(ProductionPlacement prodBuilding, boolean first) {
        return null;
    }

    public boolean tick(ProductionPlacement placement, ActiveProduction active) {
        if (active.ticksLeft > 0.0f && this.isBelowPopulationSupply(placement.getLevel(), placement.ownerName) && placement.isBuilt) {
            active.ticksLeft = placement.getLevel().m_5776_() && ResearchClient.hasCheat("warpten") || !placement.getLevel().m_5776_() && ResearchServerEvents.playerHasCheat(placement.ownerName, "warpten") ? (placement.getLevel().m_5776_() ? (float)((double)active.ticksLeft - TPSClientEvents.getCappedTPS() / 20.0 * 10.0) : (active.ticksLeft -= 10.0f)) : (placement.getLevel().m_5776_() ? (float)((double)active.ticksLeft - TPSClientEvents.getCappedTPS() / 20.0) : (active.ticksLeft -= 1.0f));
            if (active.ticksLeft < 0.0f) {
                active.ticksLeft = 0.0f;
            }
        }
        if (active.ticksLeft <= 0.0f && this.isBelowPopulationSupply(placement.getLevel(), placement.ownerName) && !active.completed) {
            this.onComplete.accept(placement.getLevel(), placement);
            active.completed = true;
            return true;
        }
        return false;
    }
}

