/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building.production;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProdDupeRule;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.building.production.StartProductionButton;
import com.solegendary.reignofnether.building.production.StopProductionButton;
import com.solegendary.reignofnether.hero.HeroClientEvents;
import com.solegendary.reignofnether.hero.HeroClientboundPacket;
import com.solegendary.reignofnether.hero.HeroServerEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.HeroUnitSave;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public abstract class ReviveHeroProductionItem
extends ProductionItem {
    public final String itemName;
    private final ResourceLocation iconRl;
    private final String tooltipI18n;

    public ReviveHeroProductionItem(String itemName, ResourceLocation iconRl, String tooltipI18n) {
        super(ResourceCost.Unit(0, 0, 0, 0, 0));
        this.dupeRule = ProdDupeRule.DISALLOW;
        this.itemName = itemName;
        this.iconRl = iconRl;
        this.tooltipI18n = tooltipI18n;
        this.onComplete = (level, placement) -> {
            if (!level.m_5776_()) {
                HeroUnitSave oldHero = HeroUnit.getFallenHero(false, placement.ownerName, this.getHeroEntityType().m_20675_());
                EntityType<? extends HeroUnit> entityType = this.getHeroEntityType();
                Entity entity = null;
                if (entityType != null) {
                    entity = placement.produceUnit((ServerLevel)level, entityType, placement.ownerName, true);
                }
                if (entity instanceof HeroUnit) {
                    HeroUnit newHero = (HeroUnit)entity;
                    if (oldHero != null) {
                        newHero.setExperience(oldHero.experience);
                        HeroClientboundPacket.setExperience(entity.m_19879_(), oldHero.experience);
                        newHero.setSkillPoints(oldHero.skillPoints);
                        HeroClientboundPacket.setSkillPoints(entity.m_19879_(), oldHero.skillPoints);
                        newHero.setStatsForLevel(true);
                        if (newHero.getHeroAbilities().size() > 0) {
                            newHero.getHeroAbilities().get(0).setRank(newHero, oldHero.ability1Rank);
                            HeroClientboundPacket.setAbilityRank(entity.m_19879_(), oldHero.ability1Rank, 0);
                        }
                        if (newHero.getHeroAbilities().size() > 1) {
                            newHero.getHeroAbilities().get(1).setRank(newHero, oldHero.ability2Rank);
                            HeroClientboundPacket.setAbilityRank(entity.m_19879_(), oldHero.ability2Rank, 1);
                        }
                        if (newHero.getHeroAbilities().size() > 2) {
                            newHero.getHeroAbilities().get(2).setRank(newHero, oldHero.ability3Rank);
                            HeroClientboundPacket.setAbilityRank(entity.m_19879_(), oldHero.ability3Rank, 2);
                        }
                        if (newHero.getHeroAbilities().size() > 3) {
                            HeroAbility ulti = newHero.getHeroAbilities().get(3);
                            ulti.setRank(newHero, oldHero.ability4Rank);
                            HeroClientboundPacket.setAbilityRank(entity.m_19879_(), oldHero.ability4Rank, 3);
                            ulti.setCooldown(ulti.cooldownMax / 2.0f, newHero);
                        }
                        for (HeroAbility abl : newHero.getHeroAbilities()) {
                            abl.updateStatsForRank(newHero);
                        }
                    }
                }
                HeroServerEvents.fallenHeroes.remove(oldHero);
            } else {
                HeroUnitSave oldHero = HeroUnit.getFallenHero(true, placement.ownerName, this.getHeroEntityType().m_20675_());
                HeroClientEvents.fallenHeroes.remove(oldHero);
            }
        };
    }

    protected EntityType<? extends HeroUnit> getHeroEntityType() {
        return null;
    }

    private String getTooltip(String ownerName) {
        HeroUnitSave heroSave = HeroUnit.getFallenHero(true, ownerName, this.getHeroEntityType().m_20675_());
        if (heroSave != null) {
            return I18n.m_118938_((String)this.tooltipI18n, (Object[])new Object[]{HeroUnit.getHeroLevel(heroSave.experience)});
        }
        return I18n.m_118938_((String)this.tooltipI18n, (Object[])new Object[0]);
    }

    @Override
    public ResourceCost getCost(boolean isClientSide, String ownerName) {
        ArrayList<HeroUnitSave> heroSaves = isClientSide ? HeroClientEvents.fallenHeroes : HeroServerEvents.fallenHeroes;
        HeroUnitSave heroSave = HeroUnit.getFallenHero(isClientSide, ownerName, this.getHeroEntityType().m_20675_());
        if (heroSave != null) {
            return HeroUnit.getReviveCost(HeroUnit.getHeroLevel(heroSave.experience));
        }
        return HeroUnit.getReviveCost(1);
    }

    @Override
    public StartProductionButton getStartButton(ProductionPlacement prodBuilding, Keybinding hotkey) {
        return new StartProductionButton(this.itemName, this.iconRl, hotkey, () -> this.itemIsBeingProduced(prodBuilding.ownerName) || HeroUnit.getFallenHero(true, prodBuilding.ownerName, this.getHeroEntityType().m_20675_()) == null, () -> true, List.of(MiscUtil.fcs(this.getTooltip(prodBuilding.ownerName), true), ResourceCosts.getFormattedCost(this.getCost(prodBuilding.level.m_5776_(), prodBuilding.ownerName)), ResourceCosts.getFormattedPopAndTime(this.getCost(prodBuilding.level.m_5776_(), prodBuilding.ownerName))), this);
    }

    @Override
    public StopProductionButton getCancelButton(ProductionPlacement prodBuilding, boolean first) {
        return new StopProductionButton(this.itemName, this.iconRl, prodBuilding, this, first);
    }
}

