/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingServerEvents;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.sandbox.SandboxServer;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Rotation;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommandsServerEvents {
    private static final SimpleCommandExceptionType UNKNOWN_BUILDING = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.reignofnether.error.unknown_building"));
    private static final SimpleCommandExceptionType UNKNOWN_RESOURCE = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.reignofnether.error.unknown_resource"));
    private static final SimpleCommandExceptionType NO_SERVER_LEVEL = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.reignofnether.error.no_server_level"));

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rtsapi-place-building").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"buildingName", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"ownerName", (ArgumentType)StringArgumentType.string()).then(CommandsServerEvents.placeBuildingTail(ctx -> StringArgumentType.getString((CommandContext)ctx, (String)"ownerName"))))).then(Commands.m_82129_((String)"ownerSelector", (ArgumentType)EntityArgument.m_91466_()).then(CommandsServerEvents.placeBuildingTail(ctx -> CommandsServerEvents.getPlayerName(EntityArgument.m_91474_((CommandContext)ctx, (String)"ownerSelector")))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rtsapi-destroy-building").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> CommandsServerEvents.destroyBuildingsAt(BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos"), (CommandSourceStack)ctx.getSource()))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rtsapi-set-unit-owner").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"ownerName", (ArgumentType)StringArgumentType.string()).then(CommandsServerEvents.unitSelectionTail(ctx -> StringArgumentType.getString((CommandContext)ctx, (String)"ownerName"))))).then(Commands.m_82129_((String)"ownerSelector", (ArgumentType)EntityArgument.m_91466_()).then(CommandsServerEvents.unitSelectionTail(ctx -> CommandsServerEvents.getPlayerName(EntityArgument.m_91474_((CommandContext)ctx, (String)"ownerSelector"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rtsapi-set-building-owner").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"ownerName", (ArgumentType)StringArgumentType.string()).then(CommandsServerEvents.buildingSelectionTail(ctx -> StringArgumentType.getString((CommandContext)ctx, (String)"ownerName"))))).then(Commands.m_82129_((String)"ownerSelector", (ArgumentType)EntityArgument.m_91466_()).then(CommandsServerEvents.buildingSelectionTail(ctx -> CommandsServerEvents.getPlayerName(EntityArgument.m_91474_((CommandContext)ctx, (String)"ownerSelector"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rtsapi-set-anchor").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"anchor", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> CommandsServerEvents.setAnchor((CommandContext<CommandSourceStack>)ctx, BlockPosArgument.m_118242_((CommandContext)ctx, (String)"from"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"to"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"anchor")))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rtsapi-remove-anchor").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> CommandsServerEvents.removeAnchor((CommandContext<CommandSourceStack>)ctx, BlockPosArgument.m_118242_((CommandContext)ctx, (String)"from"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"to"))))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rtsapi-change-resources").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"resource", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"playerName", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandsServerEvents.changeResources((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"resource"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), StringArgumentType.getString((CommandContext)ctx, (String)"playerName"))))).then(Commands.m_82129_((String)"playerSelector", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> CommandsServerEvents.changeResources((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"resource"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), CommandsServerEvents.getPlayerName(EntityArgument.m_91474_((CommandContext)ctx, (String)"playerSelector"))))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> placeBuildingTail(NameResolver ownerResolver) {
        return Commands.m_82129_((String)"autoBuild", (ArgumentType)BoolArgumentType.bool()).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> CommandsServerEvents.placeBuilding((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"buildingName"), ownerResolver.resolve((CommandContext<CommandSourceStack>)ctx), BoolArgumentType.getBool((CommandContext)ctx, (String)"autoBuild"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"pos"))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> unitSelectionTail(NameResolver ownerResolver) {
        return Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> CommandsServerEvents.setUnitOwner((CommandContext<CommandSourceStack>)ctx, ownerResolver.resolve((CommandContext<CommandSourceStack>)ctx), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"from"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"to"))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> buildingSelectionTail(NameResolver ownerResolver) {
        return Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> CommandsServerEvents.setBuildingOwner((CommandContext<CommandSourceStack>)ctx, ownerResolver.resolve((CommandContext<CommandSourceStack>)ctx), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"from"), BlockPosArgument.m_118242_((CommandContext)ctx, (String)"to"))));
    }

    private static String getPlayerName(ServerPlayer player) {
        return player.m_7755_().getString();
    }

    private static int placeBuilding(CommandContext<CommandSourceStack> ctx, String buildingName, String ownerName, boolean autoBuild, BlockPos pos) throws CommandSyntaxException {
        Building building = CommandsServerEvents.resolveBuilding(buildingName);
        if (building == null) {
            throw UNKNOWN_BUILDING.create();
        }
        if (BuildingServerEvents.getServerLevel() == null) {
            throw NO_SERVER_LEVEL.create();
        }
        BuildingPlacement placement = BuildingServerEvents.placeBuilding(building, pos, Rotation.NONE, ownerName, new int[0], false, false);
        if (placement == null) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("Unable to place building at " + CommandsServerEvents.formatPos(pos))));
            return 0;
        }
        if (autoBuild) {
            placement.selfBuilding = true;
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Placed " + building.name + " for " + ownerName + " at " + CommandsServerEvents.formatPos(pos))), true);
        return 1;
    }

    private static int destroyBuildingsAt(BlockPos pos, CommandSourceStack source) {
        List<BuildingPlacement> targets = BuildingServerEvents.getBuildings().stream().filter(building -> building.isPosInsideBuilding(pos)).toList();
        int removed = 0;
        for (BuildingPlacement placement : targets) {
            placement.destroy(source.m_81372_());
            ++removed;
        }
        if (removed == 0) {
            source.m_81352_((Component)Component.m_237113_((String)("No buildings found at " + CommandsServerEvents.formatPos(pos))));
        } else {
            int finalRemoved = removed;
            source.m_288197_(() -> Component.m_237113_((String)("Destroyed " + finalRemoved + " building(s) at " + CommandsServerEvents.formatPos(pos))), true);
        }
        return removed;
    }

    private static int setUnitOwner(CommandContext<CommandSourceStack> ctx, String ownerName, BlockPos from, BlockPos to) {
        BlockPos min = CommandsServerEvents.min(from, to);
        BlockPos max = CommandsServerEvents.max(from, to);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
            if (!(entity instanceof Unit)) continue;
            Unit unit = (Unit)entity;
            if (!CommandsServerEvents.isWithin(entity.m_20097_(), min, max)) continue;
            ids.add(entity.m_19879_());
        }
        SandboxServer.setUnitOwner(ids.stream().mapToInt(Integer::intValue).toArray(), ownerName);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Assigned " + ids.size() + " unit(s) to " + ownerName)), true);
        return ids.size();
    }

    private static int setBuildingOwner(CommandContext<CommandSourceStack> ctx, String ownerName, BlockPos from, BlockPos to) {
        BlockPos min = CommandsServerEvents.min(from, to);
        BlockPos max = CommandsServerEvents.max(from, to);
        int changed = 0;
        for (BuildingPlacement placement : BuildingServerEvents.getBuildings()) {
            if (!CommandsServerEvents.intersects(placement, min, max)) continue;
            placement.ownerName = ownerName;
            ++changed;
        }
        if (changed == 0) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"No buildings found in selection"));
        } else {
            int finalChanged = changed;
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Updated owner for " + finalChanged + " building(s)")), true);
        }
        return changed;
    }

    private static int setAnchor(CommandContext<CommandSourceStack> ctx, BlockPos from, BlockPos to, BlockPos anchor) {
        int[] ids = CommandsServerEvents.collectUnitIds(from, to);
        SandboxServer.setAnchor(ids, anchor);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Set anchor for " + ids.length + " unit(s)")), true);
        return ids.length;
    }

    private static int removeAnchor(CommandContext<CommandSourceStack> ctx, BlockPos from, BlockPos to) {
        int[] ids = CommandsServerEvents.collectUnitIds(from, to);
        SandboxServer.removeAnchor(ids);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Removed anchor for " + ids.length + " unit(s)")), true);
        return ids.length;
    }

    private static int changeResources(CommandContext<CommandSourceStack> ctx, String resourceName, int amount, String playerName) throws CommandSyntaxException {
        ResourceName resource = CommandsServerEvents.resolveResource(resourceName);
        int food = resource == ResourceName.FOOD ? amount : 0;
        int wood = resource == ResourceName.WOOD ? amount : 0;
        int ore = resource == ResourceName.ORE ? amount : 0;
        ResourcesServerEvents.addSubtractResources(new Resources(playerName, food, wood, ore));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Changed " + resource.name().toLowerCase() + " by " + amount + " for " + playerName)), true);
        return 1;
    }

    private static int[] collectUnitIds(BlockPos from, BlockPos to) {
        BlockPos min = CommandsServerEvents.min(from, to);
        BlockPos max = CommandsServerEvents.max(from, to);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (LivingEntity entity : UnitServerEvents.getAllUnits()) {
            if (!(entity instanceof Unit) || !CommandsServerEvents.isWithin(entity.m_20097_(), min, max)) continue;
            ids.add(entity.m_19879_());
        }
        return ids.stream().mapToInt(Integer::intValue).toArray();
    }

    private static Building resolveBuilding(String input) {
        Building building;
        ResourceLocation location = null;
        location = input.contains(":") ? ResourceLocation.m_135820_((String)input) : ResourceLocation.m_135820_((String)("reignofnether:" + input));
        Building building2 = building = location == null ? null : (Building)ReignOfNetherRegistries.BUILDING.m_7745_(location);
        if (building == null) {
            building = CustomBuildingServerEvents.getCustomBuilding(input);
        }
        return building;
    }

    private static ResourceName resolveResource(String name) throws CommandSyntaxException {
        try {
            return ResourceName.valueOf(name.trim().toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw UNKNOWN_RESOURCE.create();
        }
    }

    private static BlockPos min(BlockPos a, BlockPos b) {
        return new BlockPos(Math.min(a.m_123341_(), b.m_123341_()), Math.min(a.m_123342_(), b.m_123342_()), Math.min(a.m_123343_(), b.m_123343_()));
    }

    private static BlockPos max(BlockPos a, BlockPos b) {
        return new BlockPos(Math.max(a.m_123341_(), b.m_123341_()), Math.max(a.m_123342_(), b.m_123342_()), Math.max(a.m_123343_(), b.m_123343_()));
    }

    private static boolean isWithin(BlockPos target, BlockPos min, BlockPos max) {
        return target.m_123341_() >= min.m_123341_() && target.m_123341_() <= max.m_123341_() && target.m_123342_() >= min.m_123342_() && target.m_123342_() <= max.m_123342_() && target.m_123343_() >= min.m_123343_() && target.m_123343_() <= max.m_123343_();
    }

    private static boolean intersects(BuildingPlacement placement, BlockPos min, BlockPos max) {
        BlockPos bMin = placement.minCorner;
        BlockPos bMax = placement.maxCorner;
        return bMax.m_123341_() >= min.m_123341_() && bMin.m_123341_() <= max.m_123341_() && bMax.m_123342_() >= min.m_123342_() && bMin.m_123342_() <= max.m_123342_() && bMax.m_123343_() >= min.m_123343_() && bMin.m_123343_() <= max.m_123343_();
    }

    private static String formatPos(BlockPos pos) {
        return "(" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + ")";
    }

    @FunctionalInterface
    private static interface NameResolver {
        public String resolve(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }
}

