/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.cursor;

import com.mojang.blaze3d.systems.RenderSystem;
import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.guiscreen.TopdownGui;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.minimap.MinimapClientEvents;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.resources.ResourceSources;
import com.solegendary.reignofnether.sandbox.SandboxAction;
import com.solegendary.reignofnether.unit.NonUnitClientEvents;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyMath;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Vector3d;
import org.lwjgl.glfw.GLFW;

public class CursorClientEvents {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static boolean leftClickDown = false;
    private static boolean rightClickDown = false;
    private static BlockPos preselectedBlockPos = new BlockPos(0, 0, 0);
    private static Vector3d cursorWorldPos = new Vector3d(0.0, 0.0, 0.0);
    private static Vector3d cursorWorldPosLast = new Vector3d(0.0, 0.0, 0.0);
    private static Vec2 cursorLeftClickDownPos = new Vec2(-1.0f, -1.0f);
    private static Vec2 cursorLeftClickDragPos = new Vec2(-1.0f, -1.0f);
    private static UnitAction leftClickAction = null;
    private static SandboxAction leftClickSandboxAction = null;
    private static final ResourceLocation TEXTURE_CURSOR = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/cursors/customcursor.png");
    private static final ResourceLocation TEXTURE_HAND = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/cursors/customcursor_hand.png");
    private static final ResourceLocation TEXTURE_HAND_GRAB = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/cursors/customcursor_hand_grab.png");
    private static final ResourceLocation TEXTURE_SWORD = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/cursors/customcursor_sword.png");
    private static final ResourceLocation TEXTURE_CROSS = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/cursors/customcursor_cross.png");
    private static final ResourceLocation TEXTURE_SHOVEL = ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/cursors/customcursor_shovel.png");

    public static Vector3d getCursorWorldPos() {
        return cursorWorldPos;
    }

    public static BlockPos getPreselectedBlockPos() {
        return preselectedBlockPos;
    }

    public static UnitAction getLeftClickAction() {
        return leftClickAction;
    }

    public static SandboxAction getLeftClickSandboxAction() {
        return leftClickSandboxAction;
    }

    public static void setLeftClickAction(UnitAction actionName) {
        if (actionName != null) {
            leftClickSandboxAction = null;
        }
        if (actionName != null && List.of(UnitAction.STARTRTS_VILLAGERS, UnitAction.STARTRTS_MONSTERS, UnitAction.STARTRTS_PIGLINS).contains((Object)actionName)) {
            leftClickAction = actionName;
        } else if (UnitClientEvents.getSelectedUnits().size() > 0 || BuildingClientEvents.getSelectedBuildings().size() > 0) {
            leftClickAction = actionName;
        } else if (actionName == null) {
            leftClickAction = null;
        }
    }

    public static void setLeftClickSandboxAction(SandboxAction actionName) {
        if (actionName != null) {
            leftClickAction = null;
        }
        leftClickSandboxAction = actionName;
    }

    @SubscribeEvent
    public static void onDrawScreen(ScreenEvent.Render evt) {
        ResourceLocation texture;
        long window = MC.m_91268_().m_85439_();
        if (!OrthoviewClientEvents.isEnabled() || !(evt.getScreen() instanceof TopdownGui)) {
            if (GLFW.glfwRawMouseMotionSupported()) {
                GLFW.glfwSetInputMode((long)window, (int)208901, (int)1);
            }
            GLFW.glfwSetInputMode((long)window, (int)208897, (int)212993);
            return;
        }
        if (CursorClientEvents.MC.f_91074_ == null || CursorClientEvents.MC.f_91073_ == null) {
            return;
        }
        GLFW.glfwSetInputMode((long)window, (int)208897, (int)212995);
        GLFW.glfwSetInputMode((long)window, (int)208901, (int)0);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int cursorDrawX = Math.min(evt.getMouseX(), MC.m_91268_().m_85445_() - 5);
        int cursorDrawY = Math.min(evt.getMouseY(), MC.m_91268_().m_85446_() - 5);
        cursorDrawX = Math.max(0, cursorDrawX);
        cursorDrawY = Math.max(0, cursorDrawY);
        if (Keybindings.altMod.isDown() && (leftClickDown || rightClickDown)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_HAND_GRAB);
            texture = TEXTURE_HAND_GRAB;
        } else if (Keybindings.altMod.isDown()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_HAND);
            texture = TEXTURE_HAND;
        } else if (leftClickAction != null && leftClickAction.equals((Object)UnitAction.ATTACK)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_SWORD);
            texture = TEXTURE_SWORD;
        } else if (leftClickAction != null && leftClickAction.equals((Object)UnitAction.BUILD_REPAIR)) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_SHOVEL);
            texture = TEXTURE_SHOVEL;
        } else if (leftClickAction != null || leftClickSandboxAction != null) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_CROSS);
            texture = TEXTURE_CROSS;
        } else {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE_CURSOR);
            texture = TEXTURE_CURSOR;
        }
        evt.getGuiGraphics().m_280168_().m_252880_(0.0f, 0.0f, 2500.0f);
        evt.getGuiGraphics().m_280398_(texture, cursorDrawX, cursorDrawY, 16, 16.0f, 16.0f, 16, 16, 16, 16);
        evt.getGuiGraphics().m_280168_().m_252880_(0.0f, 0.0f, -2500.0f);
        cursorWorldPosLast = new Vector3d(CursorClientEvents.cursorWorldPos.x, CursorClientEvents.cursorWorldPos.y, CursorClientEvents.cursorWorldPos.z);
        cursorWorldPos = MiscUtil.screenPosToWorldPos(MC, evt.getMouseX(), evt.getMouseY());
        Vector3d lookVector = MiscUtil.getPlayerLookVector(MC);
        Vector3d cursorWorldPosNear = MyMath.addVector3d(cursorWorldPos, lookVector, -200.0f);
        Vector3d cursorWorldPosFar = MyMath.addVector3d(cursorWorldPos, lookVector, 200.0f);
        if (CursorClientEvents.cursorWorldPos.x != CursorClientEvents.cursorWorldPosLast.x || CursorClientEvents.cursorWorldPos.y != CursorClientEvents.cursorWorldPosLast.y || CursorClientEvents.cursorWorldPos.z != CursorClientEvents.cursorWorldPosLast.z) {
            Vec3 hitPos = CursorClientEvents.getRefinedCursorWorldPos(cursorWorldPosNear, cursorWorldPosFar);
            cursorWorldPos = new Vector3d(hitPos.f_82479_, hitPos.f_82480_, hitPos.f_82481_);
            preselectedBlockPos = new BlockPos((int)Math.floor(hitPos.f_82479_), (int)Math.floor(hitPos.f_82480_), (int)Math.floor(hitPos.f_82481_));
            boolean usingPosAbove = false;
            if (!MiscUtil.isSolidBlocking((Level)CursorClientEvents.MC.f_91073_, preselectedBlockPos) && !CursorClientEvents.MC.f_91073_.m_8055_((preselectedBlockPos = CursorClientEvents.getRefinedBlockPos(preselectedBlockPos, cursorWorldPosNear)).m_7494_()).m_60819_().m_76178_()) {
                preselectedBlockPos = preselectedBlockPos.m_7494_();
                usingPosAbove = true;
            }
            if (!usingPosAbove && !BuildingUtils.isPosInsideAnyBuilding(true, preselectedBlockPos) && BuildingUtils.isPosInsideAnyBuilding(true, preselectedBlockPos.m_7494_()) && ResourceSources.getFromBlockPos(preselectedBlockPos, (Level)CursorClientEvents.MC.f_91073_) == null) {
                preselectedBlockPos = preselectedBlockPos.m_7494_();
            } else if (ResourceSources.GATHERABLE_PLANTS.contains(CursorClientEvents.MC.f_91073_.m_8055_(preselectedBlockPos.m_7494_()).m_60734_())) {
                preselectedBlockPos = preselectedBlockPos.m_7494_();
            }
        }
        List<LivingEntity> nearbyEntities = MiscUtil.getEntitiesWithinRange(cursorWorldPos, 30.0f, LivingEntity.class, (Level)CursorClientEvents.MC.f_91073_);
        UnitClientEvents.clearPreselectedUnits();
        for (LivingEntity entity : nearbyEntities) {
            if (entity.m_19879_() == CursorClientEvents.MC.f_91074_.m_19879_()) continue;
            AABB entityaabb = entity.m_20191_().m_82400_(0.1);
            if (!MyMath.rayIntersectsAABBCustom(cursorWorldPosNear, MiscUtil.getPlayerLookVector(MC), entityaabb)) continue;
            UnitClientEvents.addPreselectedUnit(entity);
            if (UnitClientEvents.getPreselectedUnits().size() <= 0) continue;
            break;
        }
        float dist = cursorLeftClickDownPos.m_165914_(cursorLeftClickDragPos);
        if (leftClickDown && dist > 0.0f && !Keybindings.altMod.isDown()) {
            List<LivingEntity> entitiesInRange = MiscUtil.getEntitiesWithinRange(cursorWorldPos, 100.0f, LivingEntity.class, (Level)CursorClientEvents.MC.f_91073_);
            ArrayList<Vec3> uvwp = MyMath.prepIsPointInsideRect3d(MC, (int)CursorClientEvents.cursorLeftClickDownPos.f_82470_, (int)CursorClientEvents.cursorLeftClickDownPos.f_82471_, (int)CursorClientEvents.cursorLeftClickDownPos.f_82470_, (int)CursorClientEvents.cursorLeftClickDragPos.f_82471_, (int)CursorClientEvents.cursorLeftClickDragPos.f_82470_, (int)CursorClientEvents.cursorLeftClickDragPos.f_82471_);
            for (LivingEntity entity : entitiesInRange) {
                if (!MyMath.isPointInsideRect3d(uvwp, entity.m_20191_().m_82399_()) || entity.m_19879_() == CursorClientEvents.MC.f_91074_.m_19879_() || UnitClientEvents.getPreselectedUnits().contains(entity)) continue;
                UnitClientEvents.addPreselectedUnit(entity);
            }
        }
    }

    public static boolean isBoxSelecting() {
        return CursorClientEvents.cursorLeftClickDownPos.f_82470_ >= 0.0f && CursorClientEvents.cursorLeftClickDownPos.f_82471_ >= 0.0f && CursorClientEvents.cursorLeftClickDragPos.f_82470_ >= 0.0f && CursorClientEvents.cursorLeftClickDragPos.f_82471_ >= 0.0f;
    }

    @SubscribeEvent
    public static void renderOverlay(RenderGuiOverlayEvent.Post evt) {
        if (leftClickDown && !Keybindings.altMod.isDown()) {
            evt.getGuiGraphics().m_280509_(Math.round(CursorClientEvents.cursorLeftClickDownPos.f_82470_), Math.round(CursorClientEvents.cursorLeftClickDownPos.f_82471_), Math.round(CursorClientEvents.cursorLeftClickDragPos.f_82470_), Math.round(CursorClientEvents.cursorLeftClickDragPos.f_82471_), 54650984);
        }
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Post evt) {
        if (!OrthoviewClientEvents.isEnabled() || MinimapClientEvents.isPointInsideMinimap(evt.getMouseX(), evt.getMouseY()) || HudClientEvents.isMouseOverAnyButtonOrHud()) {
            return;
        }
        if (evt.getButton() == 0) {
            cursorLeftClickDownPos = new Vec2((float)Mth.m_14107_((double)evt.getMouseX()), (float)Mth.m_14107_((double)evt.getMouseY()));
            cursorLeftClickDragPos = new Vec2((float)Mth.m_14107_((double)evt.getMouseX()), (float)Mth.m_14107_((double)evt.getMouseY()));
            leftClickDown = true;
        }
        if (evt.getButton() == 1) {
            rightClickDown = true;
        }
    }

    @SubscribeEvent
    public static void onMouseDrag(ScreenEvent.MouseDragged.Pre evt) {
        if (!OrthoviewClientEvents.isEnabled() || CursorClientEvents.cursorLeftClickDownPos.f_82470_ < 0.0f && CursorClientEvents.cursorLeftClickDownPos.f_82471_ < 0.0f) {
            return;
        }
        cursorLeftClickDragPos = new Vec2((float)Mth.m_14107_((double)evt.getMouseX()), (float)Mth.m_14107_((double)evt.getMouseY()));
    }

    @SubscribeEvent
    public static void onMouseRelease(ScreenEvent.MouseButtonReleased.Post evt) {
        if (!OrthoviewClientEvents.isEnabled()) {
            return;
        }
        if (evt.getButton() == 0) {
            leftClickDown = false;
            ArrayList<LivingEntity> preselectedUnit = UnitClientEvents.getPreselectedUnits();
            if (preselectedUnit.size() > 0 && !cursorLeftClickDownPos.m_82476_(cursorLeftClickDragPos)) {
                int ownedEntities = 0;
                for (LivingEntity livingEntity : preselectedUnit) {
                    if (UnitClientEvents.getPlayerToEntityRelationship(livingEntity) != Relationship.OWNED && !NonUnitClientEvents.canControlAllMobs() && !AlliancesClient.canControlAlly(livingEntity)) continue;
                    ++ownedEntities;
                }
                if (ownedEntities > 0) {
                    ArrayList<LivingEntity> unitsToAdd = new ArrayList<LivingEntity>();
                    for (LivingEntity unit : preselectedUnit) {
                        if (UnitClientEvents.getPlayerToEntityRelationship(unit) != Relationship.OWNED && !NonUnitClientEvents.canControlAllMobs() && !AlliancesClient.canControlAlly(unit)) continue;
                        unitsToAdd.add(unit);
                    }
                    if (Keybindings.shiftMod.isDown()) {
                        List<Integer> list = UnitClientEvents.getSelectedUnits().stream().map(Entity::m_19879_).toList();
                        unitsToAdd.removeIf(e -> selectedIds.contains(e.m_19879_()));
                    } else {
                        UnitClientEvents.clearSelectedUnits();
                    }
                    for (LivingEntity unit : unitsToAdd) {
                        UnitClientEvents.addSelectedUnit(unit);
                    }
                    HudClientEvents.setLowestCdHudEntity();
                }
            }
            cursorLeftClickDownPos = new Vec2(-1.0f, -1.0f);
            cursorLeftClickDragPos = new Vec2(-1.0f, -1.0f);
        }
        if (evt.getButton() == 1) {
            rightClickDown = false;
        }
    }

    @SubscribeEvent
    public static void onHighlightBlockEvent(RenderHighlightEvent.Block evt) {
        if (CursorClientEvents.MC.f_91073_ != null && OrthoviewClientEvents.isEnabled()) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS || HudClientEvents.isMouseOverAnyButtonOrHud()) {
            return;
        }
        if (CursorClientEvents.MC.f_91073_ != null && OrthoviewClientEvents.isEnabled()) {
            boolean isLeftClickActionStartRTS;
            BuildingPlacement preSelBuilding = BuildingClientEvents.getPreselectedBuilding();
            boolean buildingTargetedByWorker = HudClientEvents.hudSelectedEntity instanceof WorkerUnit && preSelBuilding != null && CursorClientEvents.getLeftClickAction() != UnitAction.MOVE && (BuildingClientEvents.getPlayerToBuildingRelationship(preSelBuilding) == Relationship.OWNED || CursorClientEvents.getLeftClickAction() == UnitAction.BUILD_REPAIR);
            boolean buildingTargetedByAttacker = HudClientEvents.hudSelectedEntity instanceof AttackerUnit && preSelBuilding != null && CursorClientEvents.getLeftClickAction() != UnitAction.MOVE && (BuildingClientEvents.getPlayerToBuildingRelationship(preSelBuilding) != Relationship.OWNED || CursorClientEvents.getLeftClickAction() == UnitAction.ATTACK);
            boolean ownAnySelected = false;
            ArrayList<BuildingPlacement> selBuildings = BuildingClientEvents.getSelectedBuildings();
            for (BuildingPlacement building : selBuildings) {
                if (building == null || BuildingClientEvents.getPlayerToBuildingRelationship(building) != Relationship.OWNED) continue;
                ownAnySelected = true;
            }
            for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
                if (UnitClientEvents.getPlayerToEntityRelationship(entity) != Relationship.OWNED) continue;
                ownAnySelected = true;
                break;
            }
            boolean bl = isLeftClickActionStartRTS = leftClickAction != null && List.of(UnitAction.STARTRTS_VILLAGERS, UnitAction.STARTRTS_MONSTERS, UnitAction.STARTRTS_PIGLINS).contains((Object)leftClickAction);
            if (!OrthoviewClientEvents.isCameraMovingByMouse() && !leftClickDown && ownAnySelected && UnitClientEvents.getPreselectedUnits().size() == 0 && BuildingClientEvents.getPreselectedBuilding() == null && !buildingTargetedByWorker && !buildingTargetedByAttacker || isLeftClickActionStartRTS || CursorClientEvents.getLeftClickSandboxAction() != null) {
                if (CursorClientEvents.MC.f_91073_.m_8055_(CursorClientEvents.getPreselectedBlockPos().m_7918_(0, 1, 0)).m_60734_() instanceof SnowLayerBlock) {
                    AABB aabb = new AABB(preselectedBlockPos);
                    aabb = aabb.m_165893_(aabb.f_82292_ + (double)0.13f);
                    MyRenderer.drawSolidBox(evt.getPoseStack(), aabb, null, 1.0f, 1.0f, 1.0f, rightClickDown ? 0.3f : 0.15f, ResourceLocation.parse((String)"forge:textures/white.png"));
                    aabb = new AABB(preselectedBlockPos).m_82386_(0.0, 0.13, 0.0);
                    MyRenderer.drawLineBox(evt.getPoseStack(), aabb, 1.0f, 1.0f, 1.0f, rightClickDown ? 1.0f : 0.5f);
                } else {
                    MyRenderer.drawBox(evt.getPoseStack(), preselectedBlockPos, 1.0f, 1.0f, 1.0f, rightClickDown ? 0.3f : 0.15f);
                    MyRenderer.drawBlockOutline(evt.getPoseStack(), preselectedBlockPos, rightClickDown ? 1.0f : 0.5f);
                }
            }
        }
    }

    public static Vec3 getRefinedCursorWorldPos(Vector3d cursorWorldPosNear, Vector3d cursorWorldPosFar) {
        Vec3 vectorNear = new Vec3(cursorWorldPosNear.x, cursorWorldPosNear.y, cursorWorldPosNear.z);
        Vec3 vectorFar = new Vec3(cursorWorldPosFar.x, cursorWorldPosFar.y, cursorWorldPosFar.z);
        BlockHitResult hitResult = null;
        if (CursorClientEvents.MC.f_91073_ != null) {
            hitResult = CursorClientEvents.clip(CursorClientEvents.MC.f_91073_, new ClipContext(vectorNear, vectorFar, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, null));
        }
        if (hitResult != null) {
            return hitResult.m_82450_().m_82549_(new Vec3(-0.001, -0.001, -0.001));
        }
        return new Vec3(0.0, 0.0, 0.0);
    }

    private static BlockHitResult clip(ClientLevel level, ClipContext pContext) {
        return (BlockHitResult)BlockGetter.m_151361_((Vec3)pContext.m_45702_(), (Vec3)pContext.m_45693_(), (Object)pContext, (clipContext, blockPos) -> {
            BlockHitResult result;
            BlockState blockstate = level.m_8055_(blockPos);
            FluidState fluidstate = level.m_6425_(blockPos);
            Vec3 vec3 = clipContext.m_45702_();
            Vec3 vec31 = clipContext.m_45693_();
            VoxelShape voxelshape = clipContext.m_45694_(blockstate, (BlockGetter)level, blockPos);
            BlockHitResult blockhitresult = level.m_45558_(vec3, vec31, blockPos, voxelshape, blockstate);
            VoxelShape voxelshape1 = clipContext.m_45698_(fluidstate, (BlockGetter)level, blockPos);
            BlockHitResult blockhitresult1 = voxelshape1.m_83220_(vec3, vec31, blockPos);
            double d0 = blockhitresult == null ? Double.MAX_VALUE : clipContext.m_45702_().m_82557_(blockhitresult.m_82450_());
            double d1 = blockhitresult1 == null ? Double.MAX_VALUE : clipContext.m_45702_().m_82557_(blockhitresult1.m_82450_());
            BlockHitResult blockHitResult = result = d0 <= d1 ? blockhitresult : blockhitresult1;
            if (result != null) {
                BlockState bs = level.m_8055_(result.m_82425_());
                if (OrthoviewClientEvents.shouldHideLeaves() && level.m_8055_(result.m_82425_()).m_60734_() instanceof LeavesBlock) {
                    result = null;
                } else if (!MiscUtil.isSolidBlocking((Level)level, result.m_82425_()) && bs.m_60819_().m_76178_()) {
                    result = null;
                } else if (bs.m_60734_() instanceof SnowLayerBlock) {
                    result = null;
                }
            }
            return result;
        }, p_151372_ -> {
            Vec3 vec3 = p_151372_.m_45702_().m_82546_(p_151372_.m_45693_());
            return BlockHitResult.m_82426_((Vec3)p_151372_.m_45693_(), (Direction)Direction.m_122366_((double)vec3.f_82479_, (double)vec3.f_82480_, (double)vec3.f_82481_), (BlockPos)new BlockPos((int)p_151372_.m_45693_().f_82479_, (int)p_151372_.m_45693_().f_82480_, (int)p_151372_.m_45693_().f_82481_));
        });
    }

    private static BlockPos getRefinedBlockPos(BlockPos bp, Vector3d cursorWorldPosNear) {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        blocks.add(bp);
        blocks.add(bp.m_122012_());
        blocks.add(bp.m_122019_());
        blocks.add(bp.m_122029_());
        blocks.add(bp.m_122024_());
        blocks.add(bp.m_122012_().m_122029_());
        blocks.add(bp.m_122019_().m_122029_());
        blocks.add(bp.m_122012_().m_122024_());
        blocks.add(bp.m_122019_().m_122024_());
        blocks.add(bp.m_7494_());
        blocks.add(bp.m_7494_().m_122012_());
        blocks.add(bp.m_7494_().m_122019_());
        blocks.add(bp.m_7494_().m_122029_());
        blocks.add(bp.m_7494_().m_122024_());
        blocks.add(bp.m_7494_().m_122012_().m_122029_());
        blocks.add(bp.m_7494_().m_122019_().m_122029_());
        blocks.add(bp.m_7494_().m_122012_().m_122024_());
        blocks.add(bp.m_7494_().m_122019_().m_122024_());
        blocks.add(bp.m_7495_());
        blocks.add(bp.m_7495_().m_122012_());
        blocks.add(bp.m_7495_().m_122019_());
        blocks.add(bp.m_7495_().m_122029_());
        blocks.add(bp.m_7495_().m_122024_());
        blocks.add(bp.m_7495_().m_122012_().m_122029_());
        blocks.add(bp.m_7495_().m_122019_().m_122029_());
        blocks.add(bp.m_7495_().m_122012_().m_122024_());
        blocks.add(bp.m_7495_().m_122019_().m_122024_());
        BlockPos bestBp = bp;
        double smallestDist = 10000.0;
        Vector3d lookVector = MiscUtil.getPlayerLookVector(MC);
        for (BlockPos block : blocks) {
            double dist = new Vec3((double)block.m_123341_(), (double)block.m_123342_(), (double)block.m_123343_()).m_82554_(new Vec3(cursorWorldPosNear.x, cursorWorldPosNear.y, cursorWorldPosNear.z));
            if (CursorClientEvents.MC.f_91073_ == null) continue;
            boolean isBlockSelectableResource = false;
            LivingEntity livingEntity = HudClientEvents.hudSelectedEntity;
            if (livingEntity instanceof Unit) {
                Unit workerUnit = (Unit)livingEntity;
                isBlockSelectableResource = ResourceSources.getFromBlockPos(block, (Level)CursorClientEvents.MC.f_91073_) != null;
            }
            BlockState bs = CursorClientEvents.MC.f_91073_.m_8055_(block);
            if (!MiscUtil.isSolidBlocking((Level)CursorClientEvents.MC.f_91073_, block) && !isBlockSelectableResource || bs.m_60734_() instanceof LeavesBlock && OrthoviewClientEvents.shouldHideLeaves() || bs.m_60734_() instanceof SnowLayerBlock || !MyMath.rayIntersectsAABBCustom(cursorWorldPosNear, lookVector, new AABB(block)) || !(dist < smallestDist)) continue;
            smallestDist = dist;
            bestBp = block;
        }
        return bestBp;
    }
}

