/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.essentialpartnermod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.solegendary.reignofnether.essentialpartnermod.AdButton;
import com.solegendary.reignofnether.essentialpartnermod.EssentialAPI;
import com.solegendary.reignofnether.essentialpartnermod.EssentialUtil;
import com.solegendary.reignofnether.essentialpartnermod.ModLoaderUtil;
import com.solegendary.reignofnether.essentialpartnermod.PartnerModConfig;
import com.solegendary.reignofnether.essentialpartnermod.UButton;
import com.solegendary.reignofnether.essentialpartnermod.data.PartnerModData;
import com.solegendary.reignofnether.essentialpartnermod.modal.AdModal;
import com.solegendary.reignofnether.essentialpartnermod.modal.ModalManager;
import com.solegendary.reignofnether.essentialpartnermod.modal.TwoButtonModal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EssentialPartner {
    public static final Logger LOGGER = LogManager.getLogger((String)"EssentialPartnerMod");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final PartnerModConfig CONFIG = PartnerModConfig.load();
    private static final Set<String> FABRIC_SUPPORTED_VERSIONS = new HashSet<String>(Arrays.asList("1.16.5", "1.17.1", "1.18", "1.18.1", "1.18.2", "1.19", "1.19.1", "1.19.2", "1.19.3", "1.19.4", "1.20", "1.20.1", "1.20.2", "1.20.4", "1.20.6", "1.21", "1.21.1", "1.21.2", "1.21.3", "1.21.4", "1.21.5", "1.21.6"));
    private static final Set<String> NEOFORGE_SUPPORTED_VERSIONS = new HashSet<String>(Arrays.asList("1.20.4", "1.20.6", "1.21.1", "1.21.3", "1.21.4", "1.21.5"));
    private static final Set<String> FORGE_SUPPORTED_VERSIONS = new HashSet<String>(Arrays.asList("1.8.9", "1.12.2", "1.16.5", "1.17.1", "1.18.2", "1.19.2", "1.19.3", "1.19.4", "1.20.1", "1.20.2", "1.20.4", "1.20.6", "1.21.1", "1.21.3", "1.21.4", "1.21.5"));
    private static final Set<String> MAIN_MENU_BUTTONS = new HashSet<String>(Collections.singletonList("menu.multiplayer"));
    private static final Set<String> PAUSE_MENU_BUTTONS = new HashSet<String>(Arrays.asList("menu.reportBugs"));
    private CompletableFuture<PartnerModData> partnerModDataFuture = null;
    private List<PartnerModData.PartnerMod> partnerMods = null;

    public EssentialPartner() {
        if (EssentialUtil.isEssentialOrContainerLoaded()) {
            return;
        }
        if (CONFIG.shouldHideButtons()) {
            return;
        }
        String version = SharedConstants.m_183709_().m_132492_();
        if (!FORGE_SUPPORTED_VERSIONS.contains(version)) {
            LOGGER.info("Minecraft version {} is not supported by Essential, disabling Partner Mod", (Object)version);
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)ModalManager.INSTANCE);
        this.partnerModDataFuture = EssentialAPI.fetchPartnerModData();
    }

    private void createButton(Screen screen, List<AbstractWidget> buttonList, BiConsumer<Button, Integer> adder) {
        boolean foundFreeSpace;
        int y;
        int x;
        String tooltip;
        ResourceLocation texture;
        if (EssentialUtil.isEssentialOrContainerLoaded()) {
            return;
        }
        if (CONFIG.shouldHideButtons()) {
            return;
        }
        int width = screen.f_96543_;
        int height = screen.f_96544_;
        int buttonSpacing = 4;
        int index = buttonList.size();
        if (screen instanceof TitleScreen) {
            texture = AdButton.TEXTURE_MAIN_MENU;
            tooltip = "Enhance your Minecraft\nwith Essential Mod";
            Button multiplayerButton = UButton.findButton(buttonList, MAIN_MENU_BUTTONS);
            if (multiplayerButton != null) {
                x = UButton.getX(multiplayerButton) + UButton.getWidth(multiplayerButton) + buttonSpacing;
                y = UButton.getY(multiplayerButton);
                index = buttonList.indexOf(multiplayerButton) + 1;
            } else {
                x = width / 2 + 100 + buttonSpacing;
                y = height / 4 + 48 + 24;
            }
        } else if (screen instanceof PauseScreen) {
            if (Minecraft.m_91087_().m_91089_() != null) {
                texture = AdButton.TEXTURE_MULTIPLAYER;
                tooltip = "Stay connected with your friends,\nall inside of Minecraft";
            } else {
                texture = AdButton.TEXTURE_SINGLEPLAYER;
                tooltip = "Host worlds for free,\nand play with your friends";
            }
            Button reportBugs = UButton.findButton(buttonList, PAUSE_MENU_BUTTONS);
            if (reportBugs != null) {
                x = UButton.getX(reportBugs) + UButton.getWidth(reportBugs) + buttonSpacing;
                y = UButton.getY(reportBugs);
                index = buttonList.indexOf(reportBugs) + 1;
            } else {
                x = width / 2 + 100 + buttonSpacing;
                y = height / 4 + 72 - 16;
            }
        } else {
            return;
        }
        boolean movingRight = true;
        block0: do {
            foundFreeSpace = true;
            for (AbstractWidget widget : buttonList) {
                int newX;
                Button other;
                if (!(widget instanceof Button) || !this.overlaps(x, y, 20, 20, other = (Button)widget)) continue;
                foundFreeSpace = false;
                if (movingRight) {
                    newX = UButton.getX(other) + UButton.getWidth(other) + buttonSpacing;
                    if (newX + 20 <= width) {
                        x = newX;
                        continue block0;
                    }
                    movingRight = false;
                    continue block0;
                }
                newX = UButton.getX(other) - buttonSpacing - 20;
                if (newX >= 0) {
                    x = newX;
                    continue block0;
                }
                foundFreeSpace = true;
                continue block0;
            }
        } while (!foundFreeSpace);
        adder.accept(new AdButton(x, y, texture, button -> {
            Minecraft.m_91087_().m_6937_(() -> screen.m_7522_(null));
            if (EssentialUtil.installationCompleted()) {
                ModalManager.INSTANCE.setModal(TwoButtonModal.postInstall());
            } else {
                PartnerModData data;
                try {
                    data = this.partnerModDataFuture.join();
                }
                catch (CompletionException e) {
                    ModalManager.INSTANCE.setModal(TwoButtonModal.installFailed());
                    return;
                }
                ModalManager.INSTANCE.setModal(new AdModal(data.getModal(), this.getPartnerMods(data)));
            }
        }, tooltip), index);
    }

    private boolean overlaps(int x1, int y1, int w1, int h1, Button button) {
        int x2 = UButton.getX(button);
        int y2 = UButton.getY(button);
        int w2 = UButton.getWidth(button);
        int h2 = UButton.getHeight(button);
        return x1 < x2 + w2 && x2 < x1 + w1 && y1 < y2 + h2 && y2 < y1 + h1;
    }

    @SubscribeEvent
    public void screenInitEvent(ScreenEvent.Init.Post event) {
        this.createButton(event.getScreen(), event.getListenersList().stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).toList(), (button, __) -> event.addListener((GuiEventListener)button));
    }

    private List<PartnerModData.PartnerMod> getPartnerMods(PartnerModData data) {
        if (this.partnerMods != null) {
            return this.partnerMods;
        }
        this.partnerMods = data.getPartneredMods().stream().filter(mod -> ModLoaderUtil.isModLoaded(mod.getId())).collect(Collectors.toList());
        return this.partnerMods;
    }
}

