/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.fogofwar;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.fogofwar.FogOfWarServerboundPacket;
import com.solegendary.reignofnether.fogofwar.FrozenChunk;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.sounds.SoundClientEvents;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.RangedAttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class FogOfWarClientEvents {
    public static final float BRIGHT = 1.0f;
    public static final float DARK = 0.35f;
    public static final float EXTRA_DARK = 0.1f;
    public static final int CHUNK_VIEW_DIST = 1;
    public static final int CHUNK_FAR_VIEW_DIST = 2;
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final int UPDATE_TICKS_MAX = 10;
    private static int updateTicksLeft = 10;
    public static final Set<ChunkPos> brightChunks = ConcurrentHashMap.newKeySet();
    public static final Set<ChunkPos> lastBrightChunks = ConcurrentHashMap.newKeySet();
    public static final Set<ChunkPos> rerenderChunks = ConcurrentHashMap.newKeySet();
    public static final Set<BlockPos> semiFrozenChunks = ConcurrentHashMap.newKeySet();
    public static final Set<FrozenChunk> frozenChunks = ConcurrentHashMap.newKeySet();
    public static boolean fogEnableWarningSent = false;
    private static boolean enabled = false;
    private static final Set<String> revealedPlayerNames = ConcurrentHashMap.newKeySet();
    public static boolean movedToCapitol = false;
    public static Set<ChunkPos> chunksToRefresh = new HashSet<ChunkPos>();
    public static ObjectArrayList<LevelRenderer.RenderChunkInfo> renderChunksInFrustum = new ObjectArrayList();

    public static void revealOrHidePlayer(boolean reveal, String playerName) {
        if (reveal) {
            revealedPlayerNames.add(playerName);
        } else {
            revealedPlayerNames.removeIf(p -> p.equals(playerName));
        }
    }

    public static boolean isPlayerRevealed(String name) {
        if (!PlayerClientEvents.isRTSPlayer()) {
            return true;
        }
        return revealedPlayerNames.contains(name);
    }

    @SubscribeEvent
    public static void onInput(InputEvent.Key evt) {
        if (evt.getAction() == 1) {
            if (FogOfWarClientEvents.MC.f_91074_ == null) {
                return;
            }
            if (!FogOfWarClientEvents.MC.f_91074_.m_20310_(4)) {
                return;
            }
            if (evt.getKey() == Keybindings.getFnum((int)8).key && FogOfWarClientEvents.isEnabled()) {
                FogOfWarClientEvents.resetFogChunks();
            }
        }
    }

    public static void resetFogChunks() {
        FogOfWarClientEvents.MC.f_91060_.m_109818_();
        semiFrozenChunks.clear();
    }

    public static void setEnabled(boolean value) {
        if (FogOfWarClientEvents.MC.f_91074_ == null) {
            return;
        }
        if (enabled != value) {
            enabled = value;
            FogOfWarClientEvents.resetFogChunks();
            if (enabled) {
                FogOfWarClientEvents.updateFogChunks();
                for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
                    building.freezeChunks(FogOfWarClientEvents.MC.f_91074_.m_7755_().getString(), false);
                }
            } else {
                for (FrozenChunk frozenChunk : frozenChunks) {
                    frozenChunk.unloadBlocks();
                }
                frozenChunks.clear();
            }
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterClientCommandsEvent evt) {
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-fog").then(Commands.m_82127_((String)"enable").executes(command -> {
            if (FogOfWarClientEvents.MC.f_91074_ == null) {
                return -1;
            }
            if (!FogOfWarClientEvents.MC.f_91074_.m_20310_(4)) {
                return -1;
            }
            if (!fogEnableWarningSent) {
                fogEnableWarningSent = true;
                FogOfWarClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
                FogOfWarClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"fogofwar.reignofnether.warning").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                FogOfWarClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"fogofwar.reignofnether.experimental"));
                FogOfWarClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
                FogOfWarClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"fogofwar.reignofnether.optifine_crash"));
                FogOfWarClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"fogofwar.reignofnether.chunk_bugs"));
                FogOfWarClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"fogofwar.reignofnether.cpu_usage"));
                FogOfWarClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
                FogOfWarClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237115_((String)"fogofwar.reignofnether.to_confirm"));
                FogOfWarClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)""));
            } else {
                FogOfWarServerboundPacket.setServerFog(true);
            }
            return 1;
        })));
        evt.getDispatcher().register((LiteralArgumentBuilder)Commands.m_82127_((String)"rts-fog").then(Commands.m_82127_((String)"disable").executes(command -> {
            if (FogOfWarClientEvents.MC.f_91074_ == null) {
                return -1;
            }
            if (!FogOfWarClientEvents.MC.f_91074_.m_20310_(4)) {
                return -1;
            }
            FogOfWarServerboundPacket.setServerFog(false);
            return 1;
        })));
    }

    public static float getPosBrightness(BlockPos pPos) {
        if (FogOfWarClientEvents.MC.f_91073_ == null) {
            return 1.0f;
        }
        if (!FogOfWarClientEvents.MC.f_91073_.m_6857_().m_61937_(pPos)) {
            return 0.1f;
        }
        for (ChunkPos chunkPos : brightChunks) {
            if (!new ChunkPos(pPos).equals((Object)chunkPos)) continue;
            return 1.0f;
        }
        if (FogOfWarClientEvents.isEnabled()) {
            return 0.35f;
        }
        return 1.0f;
    }

    public static boolean isBuildingInBrightChunk(BuildingPlacement building) {
        if (!FogOfWarClientEvents.isEnabled()) {
            return true;
        }
        for (BlockPos bp : BuildingUtils.getUniqueChunkBps(building)) {
            if (!FogOfWarClientEvents.isInBrightChunk(bp)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInBrightChunk(BlockPos bp) {
        if (!FogOfWarClientEvents.isEnabled() || FogOfWarClientEvents.MC.f_91073_ == null) {
            return true;
        }
        for (ChunkPos chunkPos : brightChunks) {
            if (!new ChunkPos(bp).equals((Object)chunkPos)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInBrightChunk(Entity entity) {
        RangedAttackerUnit rangedAttackerUnit;
        if (!FogOfWarClientEvents.isEnabled() || FogOfWarClientEvents.MC.f_91073_ == null) {
            return true;
        }
        for (ChunkPos chunkPos : brightChunks) {
            if (!new ChunkPos(entity.m_20097_()).equals((Object)chunkPos)) continue;
            return true;
        }
        return entity instanceof RangedAttackerUnit && (rangedAttackerUnit = (RangedAttackerUnit)entity).getFogRevealDuration() > 0;
    }

    @SubscribeEvent
    public static void onRenderLivingEntity(RenderLivingEvent.Pre<? extends LivingEntity, ? extends Model> evt) {
        if (FogOfWarClientEvents.MC.f_91073_ != null && !FogOfWarClientEvents.MC.f_91073_.m_6857_().m_61937_(evt.getEntity().m_20097_())) {
            evt.setCanceled(true);
            return;
        }
        if (FogOfWarClientEvents.isInBrightChunk((Entity)evt.getEntity())) {
            return;
        }
        evt.setCanceled(true);
    }

    public static Set<ChunkPos> getEnemyOccupiedChunks() {
        ConcurrentHashMap.KeySetView enemyOccupiedChunks = ConcurrentHashMap.newKeySet();
        for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
            if (UnitClientEvents.getPlayerToEntityRelationship(entity) == Relationship.OWNED) continue;
            enemyOccupiedChunks.add(new ChunkPos(entity.m_20097_()));
        }
        for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
            if (BuildingClientEvents.getPlayerToBuildingRelationship(building) == Relationship.OWNED || FogOfWarClientEvents.isPlayerRevealed(building.ownerName) || FogOfWarClientEvents.MC.f_91073_ == null) continue;
            enemyOccupiedChunks.addAll(building.getRenderChunkOrigins(true).stream().map(bp -> FogOfWarClientEvents.MC.f_91073_.m_46865_(bp).m_7697_()).toList());
        }
        return enemyOccupiedChunks;
    }

    public static void updateFogChunks() {
        int z;
        brightChunks.clear();
        ConcurrentHashMap.KeySetView viewerChunks = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView farViewerChunks = ConcurrentHashMap.newKeySet();
        for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
            if (!(entity instanceof Unit)) continue;
            Unit unit = (Unit)entity;
            if (FogOfWarClientEvents.MC.f_91074_ == null || UnitClientEvents.getPlayerToEntityRelationship(entity) != Relationship.OWNED && !FogOfWarClientEvents.isPlayerRevealed(unit.getOwnerName()) && !AlliancesClient.isAllied(FogOfWarClientEvents.MC.f_91074_.m_7755_().getString(), unit.getOwnerName())) continue;
            if (entity instanceof GhastUnit) {
                farViewerChunks.add(new ChunkPos(entity.m_20097_()));
                continue;
            }
            viewerChunks.add(new ChunkPos(entity.m_20097_()));
        }
        for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
            GarrisonableBuilding garr;
            if (BuildingClientEvents.getPlayerToBuildingRelationship(building) != Relationship.OWNED && !FogOfWarClientEvents.isPlayerRevealed(building.ownerName)) continue;
            if (building instanceof GarrisonableBuilding && (garr = (GarrisonableBuilding)((Object)building)).getCapacity() > 0 && GarrisonableBuilding.getNumOccupants(building) > 0 && building.isBuilt || building.isCapitol) {
                farViewerChunks.add(new ChunkPos(building.centrePos));
                continue;
            }
            viewerChunks.add(new ChunkPos(building.centrePos));
        }
        for (Object chunkPos : viewerChunks) {
            for (int x = -1; x <= 1; ++x) {
                for (z = -1; z <= 1; ++z) {
                    brightChunks.add(new ChunkPos(((ChunkPos)chunkPos).f_45578_ + x, ((ChunkPos)chunkPos).f_45579_ + z));
                }
            }
        }
        for (Object chunkPos : farViewerChunks) {
            for (int x = -2; x <= 2; ++x) {
                for (z = -2; z <= 2; ++z) {
                    brightChunks.add(new ChunkPos(((ChunkPos)chunkPos).f_45578_ + x, ((ChunkPos)chunkPos).f_45579_ + z));
                }
            }
        }
        ConcurrentHashMap.KeySetView newlyDarkChunks = ConcurrentHashMap.newKeySet();
        newlyDarkChunks.addAll(lastBrightChunks);
        newlyDarkChunks.removeAll(brightChunks);
        for (ChunkPos cpos : newlyDarkChunks) {
            FogOfWarClientEvents.onChunkUnexplore(cpos);
            for (int x = -1; x <= 1; ++x) {
                for (int z2 = -1; z2 <= 1; ++z2) {
                    rerenderChunks.add(new ChunkPos(cpos.f_45578_ + x, cpos.f_45579_ + z2));
                }
            }
        }
        ConcurrentHashMap.KeySetView newlyBrightChunks = ConcurrentHashMap.newKeySet();
        newlyBrightChunks.addAll(brightChunks);
        newlyBrightChunks.removeAll(lastBrightChunks);
        for (ChunkPos cpos : newlyBrightChunks) {
            FogOfWarClientEvents.onChunkExplore(cpos);
        }
        if (OrthoviewClientEvents.isEnabled()) {
            semiFrozenChunks.removeIf(bp -> bp.m_7918_(8, 8, 8).m_123331_((Vec3i)FogOfWarClientEvents.MC.f_91074_.m_20097_()) > Math.pow(OrthoviewClientEvents.getZoom() * 3.0f, 2.0));
        } else {
            semiFrozenChunks.removeIf(bp -> bp.m_7918_(8, 8, 8).m_123331_((Vec3i)FogOfWarClientEvents.MC.f_91074_.m_20097_()) > Math.pow(FogOfWarClientEvents.MC.f_91060_.m_173017_() * 8.0, 2.0));
        }
        semiFrozenChunks.removeIf(bp -> {
            if (FogOfWarClientEvents.isInBrightChunk(bp)) {
                FogOfWarClientEvents.updateChunkLighting(bp);
                return true;
            }
            return false;
        });
        lastBrightChunks.clear();
        lastBrightChunks.addAll(brightChunks);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (!FogOfWarClientEvents.isEnabled() || FogOfWarClientEvents.MC.f_91073_ == null || FogOfWarClientEvents.MC.f_91074_ == null || evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (updateTicksLeft > 0) {
            --updateTicksLeft;
        } else {
            updateTicksLeft = 10;
            FogOfWarClientEvents.updateFogChunks();
        }
    }

    public static void updateChunkLighting(BlockPos originBp) {
        if (FogOfWarClientEvents.MC.f_91073_ == null) {
            return;
        }
        block0: for (int i = 0; i < 4; ++i) {
            BlockPos updatePos = originBp.m_7918_(4 * i, 0, 4 * i);
            for (int y = FogOfWarClientEvents.MC.f_91073_.m_151558_(); y > FogOfWarClientEvents.MC.f_91073_.m_141937_(); --y) {
                BlockPos bp = new BlockPos(updatePos.m_123341_(), y, updatePos.m_123343_());
                BlockState bs = FogOfWarClientEvents.MC.f_91073_.m_8055_(bp);
                if (bs.m_60795_()) continue;
                FogOfWarClientEvents.MC.f_91073_.m_46597_(bp, Blocks.f_50141_.m_49966_());
                FogOfWarClientEvents.MC.f_91073_.m_46597_(bp, bs);
                continue block0;
            }
        }
    }

    public static void onChunkExplore(ChunkPos cpos) {
        if (FogOfWarClientEvents.MC.f_91073_ == null) {
            return;
        }
        Set chunksInFrustum = renderChunksInFrustum.stream().map(rci -> FogOfWarClientEvents.MC.f_91073_.m_46865_(rci.f_109839_.m_112839_()).m_7697_()).collect(Collectors.toSet());
        if (!chunksInFrustum.contains(cpos)) {
            chunksToRefresh.add(cpos);
        }
        frozenChunks.removeIf(fc -> fc.removeOnExplore && FogOfWarClientEvents.MC.f_91073_.m_46865_(fc.origin).m_7697_().equals((Object)cpos));
        for (FrozenChunk frozenChunk : frozenChunks) {
            if (!FogOfWarClientEvents.MC.f_91073_.m_46865_(frozenChunk.origin).m_7697_().equals((Object)cpos)) continue;
            frozenChunk.unloadBlocks();
        }
        for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
            if (building.isExploredClientside) continue;
            for (BlockPos bp : building.getRenderChunkOrigins(false)) {
                if (bp.m_123341_() != cpos.m_45615_().m_123341_() || bp.m_123343_() != cpos.m_45615_().m_123343_()) continue;
                building.isExploredClientside = true;
            }
        }
    }

    public static void onChunkUnexplore(ChunkPos cpos) {
        frozenChunks.removeIf(fc -> fc.removeOnExplore && FogOfWarClientEvents.MC.f_91073_.m_46865_(fc.origin).m_7697_().equals((Object)cpos));
        for (FrozenChunk frozenChunk : frozenChunks) {
            if (!FogOfWarClientEvents.MC.f_91073_.m_46865_(frozenChunk.origin).m_7697_().equals((Object)cpos) || !FogOfWarClientEvents.MC.f_91073_.m_46749_(frozenChunk.origin)) continue;
            frozenChunk.saveBlocks();
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load evt) {
        BlockPos bp = evt.getChunk().m_7697_().m_45615_();
        for (FrozenChunk fc : frozenChunks) {
            if (!evt.getLevel().m_5776_() || bp.m_123341_() != fc.origin.m_123341_() || bp.m_123343_() != fc.origin.m_123343_()) continue;
            if (fc.unsaved) {
                fc.saveFakeBlocks();
            }
            if (FogOfWarClientEvents.isInBrightChunk(bp)) continue;
            fc.loadBlocks();
        }
    }

    public static void setBuildingDestroyedServerside(BlockPos buildingOrigin) {
        for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
            if (!building.originPos.equals((Object)buildingOrigin)) continue;
            building.isDestroyedServerside = true;
        }
    }

    public static void setBuildingBuiltServerside(BlockPos buildingOrigin) {
        for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
            if (!building.originPos.equals((Object)buildingOrigin)) continue;
            building.isBuiltServerside = true;
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
    }

    public static void revealRangedUnit(String playerBeingAttacked, int unitId) {
        if (FogOfWarClientEvents.MC.f_91074_ != null && FogOfWarClientEvents.MC.f_91074_.m_7755_().getString().equals(playerBeingAttacked)) {
            for (LivingEntity entity : UnitClientEvents.getAllUnits()) {
                if (entity.m_19879_() != unitId || !(entity instanceof RangedAttackerUnit)) continue;
                RangedAttackerUnit unit = (RangedAttackerUnit)entity;
                unit.setFogRevealDuration(60);
            }
        }
    }

    public static void unmuteChunks() {
        SoundClientEvents.mutedBps.clear();
    }
}

