/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.gamerules;

import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.solegendary.reignofnether.gamerules.GameruleClientboundPacket;
import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GameruleServerEvents {
    @SubscribeEvent
    public static void onCommandUsed(CommandEvent evt) {
        Map args;
        List nodes = evt.getParseResults().getContext().getNodes();
        if (nodes.size() <= 2) {
            return;
        }
        if (!((ParsedCommandNode)nodes.get(0)).getNode().getName().equals("gamerule")) {
            return;
        }
        if (((ParsedCommandNode)nodes.get(1)).getNode().getName().equals("maxPopulation")) {
            Map args2 = evt.getParseResults().getContext().getArguments();
            if (args2.containsKey("value")) {
                UnitServerEvents.maxPopulation = (Integer)((ParsedArgument)args2.get("value")).getResult();
                GameruleClientboundPacket.setMaxPopulation(UnitServerEvents.maxPopulation);
            }
        } else if (((ParsedCommandNode)nodes.get(1)).getNode().getName().equals("groundYLevel")) {
            Map args3 = evt.getParseResults().getContext().getArguments();
            if (args3.containsKey("value")) {
                double groundYLevel = ((Integer)((ParsedArgument)args3.get("value")).getResult()).doubleValue();
                GameruleClientboundPacket.setGroundYLevel((long)groundYLevel);
            }
        } else if (((ParsedCommandNode)nodes.get(1)).getNode().getName().equals("flyingMaxYLevel")) {
            Map args4 = evt.getParseResults().getContext().getArguments();
            if (args4.containsKey("value")) {
                double flyingMaxYLevel = ((Integer)((ParsedArgument)args4.get("value")).getResult()).doubleValue();
                GameruleClientboundPacket.setFlyingMaxYLevel((long)flyingMaxYLevel);
            }
        } else if (((ParsedCommandNode)nodes.get(1)).getNode().getName().equals("improvedPathfinding")) {
            Map args5 = evt.getParseResults().getContext().getArguments();
            if (args5.containsKey("value")) {
                boolean value = (Boolean)((ParsedArgument)args5.get("value")).getResult();
                for (LivingEntity le : UnitServerEvents.getAllUnits()) {
                    UnitServerEvents.improvedPathfinding = value;
                    AttributeInstance ai = le.m_21051_(Attributes.f_22277_);
                    if (ai == null) continue;
                    ai.m_22100_((double)Unit.getFollowRange());
                }
                GameruleClientboundPacket.setImprovedPathfinding(value);
            }
        } else if (((ParsedCommandNode)nodes.get(1)).getNode().getName().equals("neutralAggro")) {
            Map args6 = evt.getParseResults().getContext().getArguments();
            if (args6.containsKey("value")) {
                boolean value = (Boolean)((ParsedArgument)args6.get("value")).getResult();
                GameruleClientboundPacket.setNeutralAggro(value);
            }
        } else if (((ParsedCommandNode)nodes.get(1)).getNode().getName().equals("allowBeacons")) {
            Map args7 = evt.getParseResults().getContext().getArguments();
            if (args7.containsKey("value")) {
                boolean value = (Boolean)((ParsedArgument)args7.get("value")).getResult();
                GameruleClientboundPacket.setAllowBeacons(value);
            }
        } else if (((ParsedCommandNode)nodes.get(1)).getNode().getName().equals("pvpModesOnly")) {
            Map args8 = evt.getParseResults().getContext().getArguments();
            if (args8.containsKey("value")) {
                boolean value = (Boolean)((ParsedArgument)args8.get("value")).getResult();
                GameruleClientboundPacket.setPvpModesOnly(value);
            }
        } else if (((ParsedCommandNode)nodes.get(1)).getNode().getName().equals("beaconWinMinutes")) {
            Map args9 = evt.getParseResults().getContext().getArguments();
            if (args9.containsKey("value")) {
                double beaconWinMinutes = ((Integer)((ParsedArgument)args9.get("value")).getResult()).doubleValue();
                GameruleClientboundPacket.setBeaconWinMinutes((long)beaconWinMinutes);
            }
        } else if (((ParsedCommandNode)nodes.get(1)).getNode().getName().equals("slantedBuilding")) {
            Map args10 = evt.getParseResults().getContext().getArguments();
            if (args10.containsKey("value")) {
                boolean value = (Boolean)((ParsedArgument)args10.get("value")).getResult();
                GameruleClientboundPacket.setSlantedBuilding(value);
            }
        } else if (((ParsedCommandNode)nodes.get(1)).getNode().getName().equals("allowHeroes") && (args = evt.getParseResults().getContext().getArguments()).containsKey("value")) {
            boolean value = (Boolean)((ParsedArgument)args.get("value")).getResult();
            GameruleClientboundPacket.setAllowHeroes(value);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        MinecraftServer server = evt.getEntity().m_9236_().m_7654_();
        if (server != null) {
            boolean logFalling = ((GameRules.BooleanValue)server.m_129900_().m_46170_(GameRuleRegistrar.LOG_FALLING)).m_46223_();
            GameruleClientboundPacket.setLogFalling(logFalling);
            boolean neutralAggro = ((GameRules.BooleanValue)server.m_129900_().m_46170_(GameRuleRegistrar.NEUTRAL_AGGRO)).m_46223_();
            GameruleClientboundPacket.setNeutralAggro(neutralAggro);
            int maxPopulation = server.m_129900_().m_46215_(GameRuleRegistrar.MAX_POPULATION);
            GameruleClientboundPacket.setMaxPopulation(maxPopulation);
            boolean unitGriefing = ((GameRules.BooleanValue)server.m_129900_().m_46170_(GameRuleRegistrar.DO_UNIT_GRIEFING)).m_46223_();
            GameruleClientboundPacket.setUnitGriefing(unitGriefing);
            boolean playerGriefing = ((GameRules.BooleanValue)server.m_129900_().m_46170_(GameRuleRegistrar.DO_PLAYER_GRIEFING)).m_46223_();
            GameruleClientboundPacket.setPlayerGriefing(playerGriefing);
            boolean improvedPathfinding = ((GameRules.BooleanValue)server.m_129900_().m_46170_(GameRuleRegistrar.IMPROVED_PATHFINDING)).m_46223_();
            GameruleClientboundPacket.setImprovedPathfinding(improvedPathfinding);
            int groundYLevel = ((GameRules.IntegerValue)server.m_129900_().m_46170_(GameRuleRegistrar.GROUND_Y_LEVEL)).m_46288_();
            GameruleClientboundPacket.setGroundYLevel(groundYLevel);
            int flyingMaxYLevel = ((GameRules.IntegerValue)server.m_129900_().m_46170_(GameRuleRegistrar.FLYING_MAX_Y_LEVEL)).m_46288_();
            GameruleClientboundPacket.setFlyingMaxYLevel(flyingMaxYLevel);
            boolean allowBeacons = ((GameRules.BooleanValue)server.m_129900_().m_46170_(GameRuleRegistrar.ALLOW_BEACONS)).m_46223_();
            GameruleClientboundPacket.setAllowBeacons(allowBeacons);
            boolean pvpModesOnly = ((GameRules.BooleanValue)server.m_129900_().m_46170_(GameRuleRegistrar.PVP_MODES_ONLY)).m_46223_();
            GameruleClientboundPacket.setPvpModesOnly(pvpModesOnly);
            int beaconWinMinutes = ((GameRules.IntegerValue)server.m_129900_().m_46170_(GameRuleRegistrar.BEACON_WIN_MINUTES)).m_46288_();
            GameruleClientboundPacket.setBeaconWinMinutes(beaconWinMinutes);
            boolean slantedBuilding = ((GameRules.BooleanValue)server.m_129900_().m_46170_(GameRuleRegistrar.SLANTED_BUILDING)).m_46223_();
            GameruleClientboundPacket.setSlantedBuilding(slantedBuilding);
            boolean allowHeroes = ((GameRules.BooleanValue)server.m_129900_().m_46170_(GameRuleRegistrar.ALLOW_HEROES)).m_46223_();
            GameruleClientboundPacket.setAllowHeroes(allowHeroes);
        }
    }
}

