/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud;

import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ActiveProduction;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.building.production.StopProductionButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.hud.RectZone;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class GlobalProductionQueueRenderer {
    private static final Minecraft MC = Minecraft.m_91087_();

    private static void aggregateQueue(ProductionPlacement placement, Map<ProductionItem, ProductionQueueGroup> grouped, List<ProductionQueueGroup> ordered) {
        for (int i = 0; i < placement.productionQueue.size(); ++i) {
            ActiveProduction production = placement.productionQueue.get(i);
            ProductionQueueGroup group = grouped.computeIfAbsent(production.item, k -> {
                ProductionQueueGroup g = new ProductionQueueGroup((ProductionItem)k);
                ordered.add(g);
                return g;
            });
            group.add(production, i, placement);
        }
    }

    private static List<ProductionQueueGroup> groupPlayerProductionQueues(String playerName) {
        if (playerName == null) {
            return Collections.emptyList();
        }
        LinkedHashMap<ProductionItem, ProductionQueueGroup> grouped = new LinkedHashMap<ProductionItem, ProductionQueueGroup>();
        ArrayList<ProductionQueueGroup> ordered = new ArrayList<ProductionQueueGroup>();
        for (BuildingPlacement b : BuildingClientEvents.getBuildings()) {
            if (!(b instanceof ProductionPlacement)) continue;
            ProductionPlacement p = (ProductionPlacement)b;
            if (!playerName.equals(p.ownerName)) continue;
            GlobalProductionQueueRenderer.aggregateQueue(p, grouped, ordered);
        }
        return ordered;
    }

    private static void renderQueueGroupCount(GuiGraphics guiGraphics, int x, int y, int iconFrameSize, int count) {
        if (count <= 1) {
            return;
        }
        String countText = String.valueOf(count);
        int textWidth = GlobalProductionQueueRenderer.MC.f_91062_.m_92895_(countText);
        guiGraphics.m_280488_(GlobalProductionQueueRenderer.MC.f_91062_, countText, x + iconFrameSize - textWidth - 3, y + iconFrameSize - 10, 0xFFFFFF);
    }

    private static Button createQueueButton(ProductionQueueGroup group) {
        StopProductionButton btn = group.item.getCancelButton(group.placement, group.includesFront);
        btn.onLeftClick = () -> {
            if (group.placements.isEmpty()) {
                return;
            }
            ProductionPlacement next = group.placements.get(0);
            if (HudClientEvents.hudSelectedPlacement instanceof ProductionPlacement && group.placements.contains(HudClientEvents.hudSelectedPlacement)) {
                next = group.placements.get((group.placements.indexOf(HudClientEvents.hudSelectedPlacement) + 1) % group.placements.size());
            }
            BuildingClientEvents.clearSelectedBuildings();
            UnitClientEvents.clearSelectedUnits();
            BuildingClientEvents.addSelectedBuilding(next);
            OrthoviewClientEvents.centreCameraOnPos(next.centrePos);
        };
        float frac = Mth.m_14036_((float)group.getProgress(), (float)0.0f, (float)1.0f);
        btn.greyPercent = 1.0f - (group.includesFront ? frac : 0.99f);
        ArrayList<FormattedCharSequence> tooltip = new ArrayList<FormattedCharSequence>();
        tooltip.add(MiscUtil.fcs(btn.name));
        int progressPercent = Math.round((1.0f - frac) * 100.0f);
        if (progressPercent > 0) {
            tooltip.add(MiscUtil.fcs(progressPercent + "%"));
        }
        btn.tooltipLines = tooltip;
        return btn;
    }

    public static Pair<List<RectZone>, List<Button>> renderQueue(GuiGraphics guiGraphics, String playerName, int baseX, int baseY, int mouseX, int mouseY) {
        List<ProductionQueueGroup> groupedQueue = GlobalProductionQueueRenderer.groupPlayerProductionQueues(playerName);
        ArrayList<RectZone> hudZones = new ArrayList<RectZone>();
        ArrayList<Button> renderedButtons = new ArrayList<Button>();
        if (groupedQueue.isEmpty()) {
            return new Pair(hudZones, renderedButtons);
        }
        int iconFrameSize = Button.DEFAULT_ICON_FRAME_SIZE;
        int iconsPerRow = 5;
        int rows = (int)Math.ceil((double)groupedQueue.size() / (double)iconsPerRow);
        hudZones.add(MyRenderer.renderFrameWithBg(guiGraphics, baseX, baseY, iconFrameSize * Math.min(groupedQueue.size(), iconsPerRow) + 10, iconFrameSize * rows + 10, -1610612736));
        int startX = baseX + 5;
        int startY = baseY + 5;
        for (int i = 0; i < groupedQueue.size(); ++i) {
            ProductionQueueGroup group = groupedQueue.get(i);
            int iconX = startX + i % iconsPerRow * iconFrameSize;
            int iconY = startY + i / iconsPerRow * iconFrameSize;
            Button btn = GlobalProductionQueueRenderer.createQueueButton(group);
            btn.render(guiGraphics, iconX, iconY, mouseX, mouseY);
            renderedButtons.add(btn);
            GlobalProductionQueueRenderer.renderQueueGroupCount(guiGraphics, iconX, iconY, iconFrameSize, group.count);
            if (!btn.isMouseOver(mouseX, mouseY)) continue;
            btn.renderTooltip(guiGraphics, mouseX, mouseY);
        }
        return new Pair(hudZones, renderedButtons);
    }

    private static class ProductionQueueGroup {
        final ProductionItem item;
        final List<ProductionPlacement> placements = new ArrayList<ProductionPlacement>();
        ActiveProduction activeProd;
        ProductionPlacement placement;
        int count;
        boolean includesFront;

        ProductionQueueGroup(ProductionItem item) {
            this.item = item;
        }

        void add(ActiveProduction p, int idx, ProductionPlacement plac) {
            ++this.count;
            if (!this.placements.contains(plac)) {
                this.placements.add(plac);
            }
            if (idx == 0) {
                this.includesFront = true;
            }
            if (this.activeProd == null || p.ticksLeft < this.activeProd.ticksLeft) {
                this.activeProd = p;
                this.placement = plac;
            }
        }

        float getProgress() {
            if (this.activeProd == null || this.placement == null) {
                return 0.0f;
            }
            float total = this.activeProd.item.getCost((boolean)true, (String)this.placement.ownerName).ticks;
            return total <= 0.0f ? 0.0f : this.activeProd.ticksLeft / total;
        }
    }
}

