/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.hud.buttons;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerboundPacket;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.building.buildings.neutral.Beacon;
import com.solegendary.reignofnether.building.buildings.placements.BeaconPlacement;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.player.RTSPlayer;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.time.TimeUtils;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class HelperButtons {
    private static final Minecraft MC = Minecraft.m_91087_();
    public static final int ICON_SIZE = 14;
    private static int idleWorkerIndex = 0;
    public static Button idleWorkerButton;
    public static Button chatButton;
    public static Button buildingCancelButton;
    public static Button armyButton;

    public static void updateButtons() {
        chatButton = new Button("Chat", 14, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/book.png"), (Keybinding)null, () -> false, () -> false, () -> true, () -> MC.m_91152_((Screen)new ChatScreen("")), null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.helperbuttons.reignofnether.chat", (Object[])new Object[0]), (Style)Style.f_131099_)));
        idleWorkerButton = new Button("Idle workers (CTRL-click to select all)", 14, HelperButtons.getIdleWorkerIcon(), Keybindings.keyJ, () -> false, UnitClientEvents.idleWorkerIds::isEmpty, () -> true, () -> {
            if (HelperButtons.MC.f_91073_ == null) {
                return;
            }
            if (Keybindings.ctrlMod.isDown()) {
                UnitClientEvents.clearSelectedUnits();
                for (int id : UnitClientEvents.idleWorkerIds) {
                    Entity entity = HelperButtons.MC.f_91073_.m_6815_(id);
                    if (!(entity instanceof WorkerUnit)) continue;
                    UnitClientEvents.addSelectedUnit((LivingEntity)entity);
                }
            } else {
                Entity entity;
                if (idleWorkerIndex >= UnitClientEvents.idleWorkerIds.size()) {
                    idleWorkerIndex = 0;
                }
                if ((entity = HelperButtons.MC.f_91073_.m_6815_(UnitClientEvents.idleWorkerIds.get(idleWorkerIndex).intValue())) instanceof WorkerUnit) {
                    OrthoviewClientEvents.centreCameraOnPos(entity.m_20182_());
                    UnitClientEvents.clearSelectedUnits();
                    UnitClientEvents.addSelectedUnit((LivingEntity)entity);
                }
                if (++idleWorkerIndex >= UnitClientEvents.idleWorkerIds.size()) {
                    idleWorkerIndex = 0;
                }
            }
        }, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.helperbuttons.reignofnether.idle_workers", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.helperbuttons.reignofnether.idle_workers_shift", (Object[])new Object[0]), (Style)Style.f_131099_)));
        buildingCancelButton = new Button("Cancel", 14, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/barrier.png"), Keybindings.cancelBuild, () -> false, () -> {
            if (HudClientEvents.hudSelectedPlacement == null) {
                return false;
            }
            boolean isSandboxPlayer = HelperButtons.MC.f_91074_ != null && SandboxClientEvents.isSandboxPlayer(HelperButtons.MC.f_91074_.m_7755_().getString());
            return BuildingUtils.getTotalCompletedBuildingsOwned(true, HudClientEvents.hudSelectedPlacement.ownerName) == 0 && !isSandboxPlayer;
        }, () -> true, () -> {
            if (HelperButtons.MC.f_91074_ != null) {
                BuildingServerboundPacket.cancelBuilding(HudClientEvents.hudSelectedPlacement.minCorner, HelperButtons.MC.f_91074_.m_7755_().getString());
            }
            HudClientEvents.hudSelectedPlacement = null;
        }, null, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"hud.helperbuttons.reignofnether.cancel", (Object[])new Object[0]), (Style)Style.f_131099_)));
        armyButton = new Button("Select all military units", 14, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/sword_and_bow.png"), Keybindings.keyK, () -> false, () -> {
            List<LivingEntity> militaryUnits = UnitClientEvents.getAllUnits().stream().filter(u -> !(u instanceof WorkerUnit) && GarrisonableBuilding.getGarrison((Unit)u) == null && UnitClientEvents.getPlayerToEntityRelationship(u) == Relationship.OWNED).toList();
            return militaryUnits.isEmpty();
        }, () -> true, () -> {
            ArrayList<LivingEntity> militaryUnits = new ArrayList<LivingEntity>();
            if (Keybindings.shiftMod.isDown()) {
                militaryUnits.addAll(UnitClientEvents.getMilitaryUnitsOnScreen());
            } else {
                militaryUnits.addAll(UnitClientEvents.getAllUnits().stream().filter(u -> !(u instanceof WorkerUnit) && GarrisonableBuilding.getGarrison((Unit)u) == null && UnitClientEvents.getPlayerToEntityRelationship(u) == Relationship.OWNED).toList());
            }
            UnitClientEvents.clearSelectedUnits();
            for (LivingEntity militaryUnit : militaryUnits) {
                UnitClientEvents.addSelectedUnit(militaryUnit);
            }
            HudClientEvents.setLowestCdHudEntity();
        }, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.helperbuttons.reignofnether.select_all_military_units", (Object[])new Object[0]), Style.f_131099_), MiscUtil.fcs(I18n.m_118938_((String)"hud.helperbuttons.reignofnether.select_all_military_units_shift", (Object[])new Object[0]), Style.f_131099_)));
    }

    private static ResourceLocation getIdleWorkerIcon() {
        return switch (PlayerClientEvents.getFaction()) {
            case Faction.MONSTERS -> ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/zombie_villager.png");
            case Faction.PIGLINS -> ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/grunt.png");
            default -> ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/villager.png");
        };
    }

    private static List<FormattedCharSequence> getBeaconButtonTooltip(String ownerName) {
        ArrayList<FormattedCharSequence> fcsList = new ArrayList<FormattedCharSequence>();
        BeaconPlacement beacon = BuildingUtils.getBeacon(true);
        if (beacon == null) {
            return fcsList;
        }
        fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"hud.helperbuttons.reignofnether.beacon.beacon_level_title", (Object[])new Object[]{beacon.getUpgradeLevel(), 5})));
        if (beacon.getUpgradeLevel() < 5) {
            fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"hud.helperbuttons.reignofnether.beacon.player_controls", (Object[])new Object[]{ownerName}), true));
        } else {
            boolean noController = true;
            for (RTSPlayer rtsPlayer : PlayerClientEvents.rtsPlayers) {
                if (rtsPlayer.beaconOwnerTicks <= 0) continue;
                noController = false;
                break;
            }
            if (noController) {
                fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"hud.helperbuttons.reignofnether.beacon.no_controller", (Object[])new Object[0])));
            } else {
                for (RTSPlayer rtsPlayer : PlayerClientEvents.rtsPlayers) {
                    long ticksToWin = Math.max(0, Beacon.getTicksToWin(beacon.getLevel()) - rtsPlayer.beaconOwnerTicks);
                    String timeToWin = TimeUtils.getTimeStrFromTicks(ticksToWin);
                    fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"hud.helperbuttons.reignofnether.beacon.player_wins_in", (Object[])new Object[]{rtsPlayer.name, timeToWin}), ownerName.equals(rtsPlayer.name)));
                }
            }
        }
        fcsList.add(MiscUtil.fcs(I18n.m_118938_((String)"hud.helperbuttons.reignofnether.beacon.click_to_centre", (Object[])new Object[0])));
        return fcsList;
    }

    public static Button getBeaconButton(String ownerName) {
        return new Button("Beacon", 14, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/nether_star.png"), (Keybinding)null, () -> false, () -> BuildingUtils.getBeacon(true) == null, () -> true, () -> {
            List<BuildingPlacement> beacons = BuildingClientEvents.getBuildings().stream().filter(b -> b instanceof BeaconPlacement).toList();
            if (!beacons.isEmpty()) {
                BlockPos bp = beacons.get((int)0).centrePos;
                OrthoviewClientEvents.centreCameraOnPos(bp);
            }
        }, null, HelperButtons.getBeaconButtonTooltip(ownerName));
    }

    static {
        HelperButtons.updateButtons();
    }
}

