/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.minimap;

import com.solegendary.reignofnether.minimap.MinimapClientEvents;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class MapMarkerClientboundPacket {
    private final int x;
    private final int z;
    private final String playerName;

    public MapMarkerClientboundPacket(int x, int z, String playerName) {
        this.x = x;
        this.z = z;
        this.playerName = playerName;
    }

    public MapMarkerClientboundPacket(FriendlyByteBuf buffer) {
        this.x = buffer.readInt();
        this.z = buffer.readInt();
        this.playerName = buffer.m_130277_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.z);
        buffer.m_130070_(this.playerName);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            MinimapClientEvents.addMapMarker(this.x, this.z, this.playerName);
            success.set(true);
        }));
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

