/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.minimap;

import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.minimap.MapMarkerClientboundPacket;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.sounds.SoundAction;
import com.solegendary.reignofnether.sounds.SoundClientboundPacket;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MapMarkerServerboundPacket {
    private final int x;
    private final int z;

    public MapMarkerServerboundPacket(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public MapMarkerServerboundPacket(FriendlyByteBuf buffer) {
        this.x = buffer.readInt();
        this.z = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.z);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            MinecraftServer server = player.m_20194_();
            if (server == null) {
                return;
            }
            PlayerList playerList = server.m_6846_();
            HashSet<ServerPlayer> recipients = new HashSet<ServerPlayer>();
            recipients.add(player);
            String playerName = player.m_7755_().getString();
            for (String allyName : AlliancesServerEvents.getAllAllies(playerName)) {
                ServerPlayer allyPlayer = playerList.m_11255_(allyName);
                if (allyPlayer == null) continue;
                recipients.add(allyPlayer);
            }
            MapMarkerClientboundPacket markerPacket = new MapMarkerClientboundPacket(this.x, this.z, playerName);
            for (ServerPlayer target : recipients) {
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> target), (Object)markerPacket);
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> target), (Object)new SoundClientboundPacket(SoundAction.ALLY, BlockPos.f_121853_, "", 1.0f));
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

