/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.mixin;

import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.unit.units.villagers.WitchUnit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThrownPotion.class})
public abstract class ThrownPotionMixin
extends ThrowableItemProjectile {
    protected ThrownPotionMixin(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"makeAreaOfEffectCloud"}, at={@At(value="HEAD")}, cancellable=true)
    private void makeAreaOfEffectCloud(ItemStack pStack, Potion pPotion, CallbackInfo ci) {
        ci.cancel();
        AreaEffectCloud aec = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            aec.m_19718_(le);
        }
        aec.m_19712_(3.0f);
        aec.m_19732_(-0.5f);
        aec.m_19740_(10);
        entity = this.m_19749_();
        if (entity instanceof WitchUnit) {
            WitchUnit witchUnit = (WitchUnit)entity;
            aec.m_19712_(3.0f);
            aec.m_19732_(0.0f);
            aec.m_146785_(0);
            aec.m_19740_(10);
            int duration = 100;
            if (this.m_9236_().m_5776_() && ResearchClient.hasResearch(ProductionItems.RESEARCH_LINGERING_POTIONS)) {
                duration = 200;
            } else if (!this.m_9236_().m_5776_() && ResearchServerEvents.playerHasResearch(witchUnit.getOwnerName(), ProductionItems.RESEARCH_LINGERING_POTIONS)) {
                duration = 200;
            }
            aec.m_19734_(duration);
        }
        aec.m_19738_(-aec.m_19743_() / (float)aec.m_19748_());
        aec.m_19722_(pPotion);
        for (MobEffectInstance $$4 : PotionUtils.m_43571_((ItemStack)pStack)) {
            aec.m_19716_(new MobEffectInstance($$4));
        }
        CompoundTag $$5 = pStack.m_41783_();
        if ($$5 != null && $$5.m_128425_("CustomPotionColor", 99)) {
            aec.m_19714_($$5.m_128451_("CustomPotionColor"));
        }
        this.m_9236_().m_7967_((Entity)aec);
    }

    @Inject(method={"onHit"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHit(HitResult pResult, CallbackInfo ci) {
        Entity entity;
        ItemStack item = this.m_7846_();
        if (pResult.m_6662_() == HitResult.Type.ENTITY && item.m_41720_() instanceof LingeringPotionItem && (entity = this.m_19749_()) instanceof WitchUnit) {
            WitchUnit witchUnit = (WitchUnit)entity;
            ci.cancel();
        }
    }
}

