/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.orthoview;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.RangeIndicator;
import com.solegendary.reignofnether.config.ReignOfNetherClientConfigs;
import com.solegendary.reignofnether.fogofwar.FogOfWarClientEvents;
import com.solegendary.reignofnether.guiscreen.TopdownGui;
import com.solegendary.reignofnether.guiscreen.TopdownGuiServerboundPacket;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.minimap.MinimapClientEvents;
import com.solegendary.reignofnether.player.PlayerServerboundPacket;
import com.solegendary.reignofnether.startpos.StartPosClientEvents;
import com.solegendary.reignofnether.startpos.StartPosServerboundPacket;
import com.solegendary.reignofnether.tutorial.TutorialClientEvents;
import com.solegendary.reignofnether.tutorial.TutorialStage;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import com.solegendary.reignofnether.util.MyMath;
import java.nio.DoubleBuffer;
import java.util.List;
import net.minecraft.client.CameraType;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;

public class OrthoviewClientEvents {
    public static LeafHideMethod hideLeavesMethod = LeafHideMethod.NONE;
    public static int enabledCount = 0;
    public static boolean enabled = false;
    private static boolean cameraMovingByMouse = false;
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final float ZOOM_STEP_KEY = 5.0f;
    private static final float ZOOM_STEP_SCROLL = 1.0f;
    private static final float ZOOM_MIN = 10.0f;
    private static final float ZOOM_MAX = 90.0f;
    private static final float CAMROTY_MAX = -20.0f;
    private static final float CAMROTY_MIN = -90.0f;
    private static final float CAMROT_MOUSE_SENSITIVITY = 0.12f;
    private static final float ZOOM_DEFAULT = 30.0f;
    private static final float CAMROTX_DEFAULT = 135.0f;
    private static final float CAMROTY_DEFAULT = -45.0f;
    private static final int FORCE_PAN_TICKS_MAX = 20;
    private static int forcePanTicksLeft = 0;
    private static float forcePanTargetX = 0.0f;
    private static float forcePanTargetZ = 0.0f;
    private static float forcePanOriginalX = 0.0f;
    private static float forcePanOriginalZ = 0.0f;
    private static float forcePanOriginalZoom = 0.0f;
    private static final int FORCE_ROT_FRAMES_MAX = 20;
    private static int forceRotFramesLeft = 0;
    private static float forceRotTargetX = 0.0f;
    private static float forceRotOriginalX = 0.0f;
    private static int cameraLockTicksLeft = 0;
    private static boolean cameraLocked = false;
    private static float zoom = 30.0f;
    private static float camRotX = 135.0f;
    private static float camRotY = -45.0f;
    private static float camRotAdjX = 0.0f;
    private static float camRotAdjY = 0.0f;
    private static float mouseRightDownX = 0.0f;
    private static float mouseRightDownY = 0.0f;
    private static float mouseLeftDownX = 0.0f;
    private static float mouseLeftDownY = 0.0f;
    public static final float MAX_PAN_SENSITIVITY = 3.0f;
    public static double orthoviewPlayerBaseY = 100.0;
    public static double orthoviewPlayerMaxY = 160.0;
    private static double minOrthoviewY = 0.0;

    public static boolean shouldHideLeaves() {
        return hideLeavesMethod != LeafHideMethod.NONE;
    }

    public static void setMinOrthoviewY(double value) {
        minOrthoviewY = value;
        if (OrthoviewClientEvents.MC.f_91073_ != null && OrthoviewClientEvents.MC.f_91074_ != null && OrthoviewClientEvents.MC.f_91074_.m_20186_() < value + 15.0) {
            OrthoviewClientEvents.MC.f_91074_.m_6478_(MoverType.SELF, new Vec3(0.0, minOrthoviewY - OrthoviewClientEvents.MC.f_91074_.m_20186_() + 15.0, 0.0));
        }
    }

    private static float getEdgeCamPanSensitivity() {
        return (float)(Math.sqrt(OrthoviewClientEvents.getZoom()) / Math.sqrt(90.0)) * OrthoviewClientEvents.getPanSensitivityMult();
    }

    public static float getPanSensitivityMult() {
        return (float)((Integer)ReignOfNetherClientConfigs.CAMERA_SENSITIVITY.get()).intValue() / 10.0f;
    }

    public static void adjustPanSensitivityMult(boolean increase) {
        if (increase && (float)Math.round(OrthoviewClientEvents.getPanSensitivityMult() * 10.0f) < 30.0f) {
            ReignOfNetherClientConfigs.CAMERA_SENSITIVITY.set((Object)((Integer)ReignOfNetherClientConfigs.CAMERA_SENSITIVITY.get() + 1));
        } else if (!increase && Math.round(OrthoviewClientEvents.getPanSensitivityMult() * 10.0f) > 1) {
            ReignOfNetherClientConfigs.CAMERA_SENSITIVITY.set((Object)((Integer)ReignOfNetherClientConfigs.CAMERA_SENSITIVITY.get() - 1));
        }
    }

    public static void updateOrthoviewY() {
        if (OrthoviewClientEvents.MC.f_91074_ != null && OrthoviewClientEvents.MC.f_91073_ != null) {
            BlockPos playerPos = OrthoviewClientEvents.MC.f_91074_.m_20183_();
            int radius = 10;
            int sumHeights = 0;
            int count = 0;
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    int blockX = playerPos.m_123341_() + x;
                    int blockZ = playerPos.m_123343_() + z;
                    int height = OrthoviewClientEvents.MC.f_91073_.m_6924_(Heightmap.Types.MOTION_BLOCKING, blockX, blockZ);
                    sumHeights += height;
                    ++count;
                }
            }
            int avgHeight = count > 0 ? sumHeights / count : playerPos.m_123342_();
            orthoviewPlayerBaseY = Math.max((double)(avgHeight + 30), minOrthoviewY);
            orthoviewPlayerMaxY = avgHeight + 100;
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isCameraMovingByMouse() {
        return cameraMovingByMouse;
    }

    public static float getZoom() {
        return zoom;
    }

    public static float getCamRotX() {
        return -camRotX - camRotAdjX;
    }

    public static float getCamRotY() {
        return -camRotY - camRotAdjY;
    }

    public static boolean isCameraLocked() {
        return cameraLockTicksLeft > 0 || cameraLocked;
    }

    public static void lockCam() {
        cameraLocked = true;
    }

    public static void unlockCam() {
        cameraLocked = false;
    }

    private static void reset() {
        zoom = 30.0f;
        camRotX = 135.0f;
        camRotY = -45.0f;
    }

    public static void rotateCam(float x, float y) {
        if (OrthoviewClientEvents.isCameraLocked()) {
            return;
        }
        if ((camRotX += x) >= 360.0f) {
            camRotX -= 360.0f;
        }
        if (camRotX <= -360.0f) {
            camRotX += 360.0f;
        }
    }

    public static void zoomCam(float zoomAdj) {
        if (OrthoviewClientEvents.isCameraLocked()) {
            return;
        }
        if ((zoom += zoomAdj) < 10.0f) {
            zoom = 10.0f;
        }
        if (zoom > 90.0f) {
            zoom = 90.0f;
        }
    }

    public static void panCam(float x, float y, float z) {
        if (OrthoviewClientEvents.MC.f_91074_ != null) {
            Vec2 XZRotated = MyMath.rotateCoords(x, z, -camRotX - camRotAdjX);
            OrthoviewClientEvents.MC.f_91074_.m_6478_(MoverType.SELF, new Vec3((double)XZRotated.f_82470_, (double)y, (double)XZRotated.f_82471_));
        }
    }

    public static void forceMoveCam(int x, int z, int cameraLockTicks) {
        if (OrthoviewClientEvents.MC.f_91074_ != null) {
            forcePanTicksLeft = 20;
            forcePanTargetX = x;
            forcePanTargetZ = z;
            cameraLockTicksLeft = 20 + cameraLockTicks;
            forcePanOriginalX = OrthoviewClientEvents.MC.f_91074_.m_20097_().m_123341_();
            forcePanOriginalZ = OrthoviewClientEvents.MC.f_91074_.m_20097_().m_123343_();
            forcePanOriginalZoom = zoom;
        }
    }

    public static void forceMoveCam(Vec3i pos, int cameraLockTicks) {
        OrthoviewClientEvents.forceMoveCam(pos.m_123341_(), pos.m_123343_(), cameraLockTicks);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END) {
            return;
        }
        if (OrthoviewClientEvents.isEnabled() && OrthoviewClientEvents.MC.f_91072_ != null && (OrthoviewClientEvents.MC.f_91072_.m_105295_() == GameType.ADVENTURE || OrthoviewClientEvents.MC.f_91072_.m_105295_() == GameType.SURVIVAL)) {
            OrthoviewClientEvents.toggleEnable();
        }
        if (cameraLockTicksLeft > 0) {
            --cameraLockTicksLeft;
        }
        if (!OrthoviewClientEvents.isEnabled() || OrthoviewClientEvents.MC.f_91074_ == null || OrthoviewClientEvents.MC.f_91073_ == null) {
            forcePanTicksLeft = 0;
            return;
        }
        if (MiscUtil.isGroundBlock((Level)OrthoviewClientEvents.MC.f_91073_, OrthoviewClientEvents.MC.f_91074_.m_20183_().m_7918_(0, -5, 0)) && (double)OrthoviewClientEvents.MC.f_91074_.m_20097_().m_123342_() <= orthoviewPlayerMaxY) {
            OrthoviewClientEvents.panCam(0.0f, 1.0f, 0.0f);
        }
        if (!MiscUtil.isGroundBlock((Level)OrthoviewClientEvents.MC.f_91073_, OrthoviewClientEvents.MC.f_91074_.m_20183_().m_7918_(0, -6, 0)) && (double)OrthoviewClientEvents.MC.f_91074_.m_20097_().m_123342_() >= orthoviewPlayerBaseY) {
            OrthoviewClientEvents.panCam(0.0f, -1.0f, 0.0f);
        }
        if (forcePanTicksLeft > 0) {
            float xDiff = (forcePanTargetX - forcePanOriginalX) / 20.0f;
            float zDiff = (forcePanTargetZ - forcePanOriginalZ) / 20.0f;
            float zoomDiff = (30.0f - forcePanOriginalZoom) / 20.0f;
            zoom += zoomDiff;
            OrthoviewClientEvents.MC.f_91074_.m_6478_(MoverType.SELF, new Vec3((double)xDiff, 0.0, (double)zDiff));
            --forcePanTicksLeft;
        }
        OrthoviewClientEvents.updateOrthoviewY();
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent evt) throws NoSuchFieldException {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || !OrthoviewClientEvents.isEnabled()) {
            return;
        }
        if (forceRotFramesLeft > 0) {
            float xDiff = (forceRotTargetX - forceRotOriginalX) / 20.0f;
            OrthoviewClientEvents.rotateCam(-xDiff, 0.0f);
            if (--forceRotFramesLeft <= 0) {
                camRotX = -forceRotTargetX;
                OrthoviewClientEvents.rotateCam(0.0f, 0.0f);
            }
        }
    }

    public static void toggleEnable() {
        if (OrthoviewClientEvents.MC.f_91073_ == null || OrthoviewClientEvents.MC.f_91074_ == null) {
            return;
        }
        for (BuildingPlacement building : BuildingClientEvents.getBuildings()) {
            if (!(building instanceof RangeIndicator)) continue;
            RangeIndicator ri = (RangeIndicator)((Object)building);
            ri.updateBorderBps();
        }
        boolean bl = enabled = !enabled;
        if (enabled) {
            OrthoviewClientEvents.MC.f_91066_.f_92030_ = TutorialSteps.NONE;
            MC.m_91301_().m_120594_();
            ++enabledCount;
            PlayerServerboundPacket.enableOrthoview();
            MinimapClientEvents.setMapCentre(OrthoviewClientEvents.MC.f_91074_.m_20185_(), OrthoviewClientEvents.MC.f_91074_.m_20189_());
            PlayerServerboundPacket.teleportPlayer(OrthoviewClientEvents.MC.f_91074_.m_20185_(), orthoviewPlayerBaseY, OrthoviewClientEvents.MC.f_91074_.m_20189_());
            TopdownGuiServerboundPacket.openTopdownGui(OrthoviewClientEvents.MC.f_91074_.m_19879_());
            OrthoviewClientEvents.MC.f_91066_.m_232050_().m_231514_((Object)CloudStatus.OFF);
            OrthoviewClientEvents.MC.f_91066_.f_92062_ = false;
            OrthoviewClientEvents.MC.f_91066_.m_92157_(CameraType.FIRST_PERSON);
            OrthoviewClientEvents.switchToEasyIfPeaceful();
        } else {
            PlayerServerboundPacket.disableOrthoview();
            TopdownGuiServerboundPacket.closeTopdownGui(OrthoviewClientEvents.MC.f_91074_.m_19879_());
            if (StartPosClientEvents.hasReservedPos()) {
                StartPosClientEvents.selectedFaction = Faction.NONE;
                StartPosServerboundPacket.unreservePos(StartPosClientEvents.getPos().pos);
            }
        }
        TutorialClientEvents.updateStage();
    }

    public static void centreCameraOnPos(BlockPos bp) {
        OrthoviewClientEvents.centreCameraOnPos(new Vec3((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_()));
    }

    public static void centreCameraOnPos(Vec3 pos) {
        if (OrthoviewClientEvents.MC.f_91074_ == null) {
            return;
        }
        MinimapClientEvents.setMapCentre(pos.f_82479_, pos.f_82481_);
        Vec2 XZRotated = MyMath.rotateCoords(0.0f, -20.0f, OrthoviewClientEvents.getCamRotX());
        float offset = (float)(Math.sqrt(OrthoviewClientEvents.getZoom()) / Math.sqrt(90.0));
        int yDiff = (int)(OrthoviewClientEvents.MC.f_91074_.m_20186_() - pos.f_82480_) - 40;
        Vec2 XZRotatedOffset = MyMath.rotateCoords(0.0f, -(offset * 35.0f) - (float)yDiff, -camRotX - camRotAdjX);
        PlayerServerboundPacket.teleportPlayer(pos.f_82479_ + (double)XZRotated.f_82470_ + (double)XZRotatedOffset.f_82470_, OrthoviewClientEvents.MC.f_91074_.m_20186_(), pos.f_82481_ + (double)XZRotated.f_82471_ + (double)XZRotatedOffset.f_82471_);
    }

    @SubscribeEvent
    public static void onRenderArm(RenderArmEvent evt) {
        if (OrthoviewClientEvents.isEnabled()) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderHand(RenderHandEvent evt) {
        if (OrthoviewClientEvents.isEnabled()) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onInput(InputEvent.Key evt) {
        if (evt.getAction() == 1) {
            if (evt.getKey() == Keybindings.getFnum((int)12).key) {
                OrthoviewClientEvents.tryToToggleEnable();
            } else if (evt.getKey() == Keybindings.reset.key) {
                OrthoviewClientEvents.reset();
            }
        }
    }

    public static void fixedRotateCam(boolean clockwise) {
        if (forceRotFramesLeft <= 0) {
            camRotAdjX = 0.0f;
            int roundedRotX = Math.round(OrthoviewClientEvents.getCamRotX() / 90.0f) * 90 + 45;
            forceRotTargetX = (float)roundedRotX > OrthoviewClientEvents.getCamRotX() && clockwise ? (float)roundedRotX : ((float)roundedRotX < OrthoviewClientEvents.getCamRotX() && !clockwise ? (float)(roundedRotX - 90) : (clockwise ? (float)roundedRotX : (float)(roundedRotX - 90)));
            if (forceRotTargetX == OrthoviewClientEvents.getCamRotX() && clockwise) {
                forceRotTargetX += 90.0f;
            } else if (forceRotTargetX == OrthoviewClientEvents.getCamRotX()) {
                forceRotTargetX -= 90.0f;
            }
            forceRotOriginalX = OrthoviewClientEvents.getCamRotX();
            forceRotFramesLeft = 20;
        }
    }

    public static void tryToToggleEnable() {
        if (!OrthoviewClientEvents.isCameraLocked() && OrthoviewClientEvents.MC.f_91072_ != null) {
            if (OrthoviewClientEvents.MC.f_91074_ != null && (OrthoviewClientEvents.MC.f_91072_.m_105295_() == GameType.ADVENTURE || OrthoviewClientEvents.MC.f_91072_.m_105295_() == GameType.SURVIVAL)) {
                OrthoviewClientEvents.MC.f_91074_.m_213846_((Component)Component.m_237113_((String)I18n.m_118938_((String)"hud.orthoview.reignofnether.ortho_error", (Object[])new Object[0])));
            } else {
                OrthoviewClientEvents.toggleEnable();
            }
        }
    }

    public static Button getLeavesHidingButton() {
        return new Button("Hide Leaves Method", 14, switch (hideLeavesMethod) {
            default -> throw new IncompatibleClassChangeError();
            case LeafHideMethod.NONE -> ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/leaves.png");
            case LeafHideMethod.AROUND_UNITS_AND_CURSOR -> ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/lime_stained_glass.png");
            case LeafHideMethod.ALL -> ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/glass.png");
        }, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/icon_frame.png"), null, () -> false, () -> !TutorialClientEvents.isAtOrPastStage(TutorialStage.MINIMAP_CLICK) || !MinimapClientEvents.isLargeMap(), () -> true, () -> {
            FogOfWarClientEvents.resetFogChunks();
            UnitClientEvents.windowUpdateTicks = 0;
            if (hideLeavesMethod == LeafHideMethod.NONE) {
                hideLeavesMethod = LeafHideMethod.AROUND_UNITS_AND_CURSOR;
            } else if (hideLeavesMethod == LeafHideMethod.AROUND_UNITS_AND_CURSOR) {
                hideLeavesMethod = LeafHideMethod.ALL;
            } else if (hideLeavesMethod == LeafHideMethod.ALL) {
                hideLeavesMethod = LeafHideMethod.NONE;
            }
        }, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.orthoview.reignofnether.hiding_leaves_around", (Object[])new Object[0]), hideLeavesMethod == LeafHideMethod.AROUND_UNITS_AND_CURSOR), MiscUtil.fcs(I18n.m_118938_((String)"hud.orthoview.reignofnether.hiding_leaves_all", (Object[])new Object[0]), hideLeavesMethod == LeafHideMethod.ALL), MiscUtil.fcs(I18n.m_118938_((String)"hud.orthoview.reignofnether.disabled_hiding_leaves", (Object[])new Object[0]), hideLeavesMethod == LeafHideMethod.NONE)));
    }

    private static void switchToEasyIfPeaceful() {
        Difficulty currentDifficulty;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_91092_() != null && (currentDifficulty = minecraft.f_91073_.m_46791_()) == Difficulty.PEACEFUL) {
            minecraft.m_91092_().m_129827_(Difficulty.EASY, true);
            HudClientEvents.showTemporaryMessage("RTS units cannot spawn in Peaceful. Your difficulty has been set to Easy.");
        }
    }

    @SubscribeEvent
    public static void onMouseScroll(ScreenEvent.MouseScrolled evt) {
        if (!enabled || OrthoviewClientEvents.isCameraLocked()) {
            return;
        }
        if (Keybindings.altMod.isDown()) {
            OrthoviewClientEvents.zoomCam((float)Mth.m_14205_((double)evt.getScrollDelta()) * -1.0f);
        }
    }

    @SubscribeEvent
    public static void onDrawScreen(ScreenEvent.Render evt) {
        if (!enabled || !(evt.getScreen() instanceof TopdownGui)) {
            return;
        }
        long glfwWindow = MC.m_91268_().m_85439_();
        int glfwWinWidth = MC.m_91268_().m_85443_();
        int glfwWinHeight = MC.m_91268_().m_85444_();
        DoubleBuffer glfwCursorX = BufferUtils.createDoubleBuffer((int)1);
        DoubleBuffer glfwCursorY = BufferUtils.createDoubleBuffer((int)1);
        GLFW.glfwGetCursorPos((long)glfwWindow, (DoubleBuffer)glfwCursorX, (DoubleBuffer)glfwCursorY);
        double cursorX = glfwCursorX.get();
        double cursorY = glfwCursorY.get();
        if (!Keybindings.altMod.isDown() && MC.m_91302_() && !OrthoviewClientEvents.isCameraLocked()) {
            if (cursorX <= 0.0) {
                OrthoviewClientEvents.panCam(OrthoviewClientEvents.getEdgeCamPanSensitivity(), 0.0f, 0.0f);
                TutorialClientEvents.pannedLeft = true;
            } else if (cursorX >= (double)glfwWinWidth) {
                OrthoviewClientEvents.panCam(-OrthoviewClientEvents.getEdgeCamPanSensitivity(), 0.0f, 0.0f);
                TutorialClientEvents.pannedRight = true;
            }
            if (cursorY <= 0.0) {
                OrthoviewClientEvents.panCam(0.0f, 0.0f, OrthoviewClientEvents.getEdgeCamPanSensitivity());
                TutorialClientEvents.pannedUp = true;
            } else if (cursorY >= (double)glfwWinHeight) {
                OrthoviewClientEvents.panCam(0.0f, 0.0f, -OrthoviewClientEvents.getEdgeCamPanSensitivity());
                TutorialClientEvents.pannedDown = true;
            }
        }
        if (cursorX >= (double)glfwWinWidth) {
            GLFW.glfwSetCursorPos((long)glfwWindow, (double)glfwWinWidth, (double)cursorY);
        }
        if (cursorY >= (double)glfwWinHeight) {
            GLFW.glfwSetCursorPos((long)glfwWindow, (double)cursorX, (double)glfwWinHeight);
        }
        if (cursorX <= 0.0) {
            GLFW.glfwSetCursorPos((long)glfwWindow, (double)0.0, (double)cursorY);
        }
        if (cursorY <= 0.0) {
            GLFW.glfwSetCursorPos((long)glfwWindow, (double)cursorX, (double)0.0);
        }
        LocalPlayer player = OrthoviewClientEvents.MC.f_91074_;
        if (Keybindings.zoomIn.isDown()) {
            OrthoviewClientEvents.zoomCam(-5.0f);
        }
        if (Keybindings.zoomOut.isDown()) {
            OrthoviewClientEvents.zoomCam(5.0f);
        }
        float panKeyStep = 1.5f * (OrthoviewClientEvents.getZoom() / 90.0f);
        if (!OrthoviewClientEvents.isCameraLocked() && !Keybindings.altMod.isDown()) {
            if (Keybindings.panPlusX.isDown()) {
                OrthoviewClientEvents.panCam(OrthoviewClientEvents.getEdgeCamPanSensitivity(), 0.0f, 0.0f);
            } else if (Keybindings.panMinusX.isDown()) {
                OrthoviewClientEvents.panCam(-OrthoviewClientEvents.getEdgeCamPanSensitivity(), 0.0f, 0.0f);
            }
            if (Keybindings.panPlusZ.isDown()) {
                OrthoviewClientEvents.panCam(0.0f, 0.0f, OrthoviewClientEvents.getEdgeCamPanSensitivity());
            } else if (Keybindings.panMinusZ.isDown()) {
                OrthoviewClientEvents.panCam(0.0f, 0.0f, -OrthoviewClientEvents.getEdgeCamPanSensitivity());
            }
        }
        if (player != null) {
            player.m_146926_(-camRotY - camRotAdjY);
            player.m_146922_(-camRotX - camRotAdjX);
        }
    }

    @SubscribeEvent
    public static void onRenderBlockOverlay(RenderBlockScreenEffectEvent evt) {
        if (enabled) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Post evt) {
        if (!enabled || OrthoviewClientEvents.isCameraLocked()) {
            return;
        }
        if (evt.getButton() == 0) {
            mouseLeftDownX = (float)evt.getMouseX();
            mouseLeftDownY = (float)evt.getMouseY();
        } else if (evt.getButton() == 1) {
            mouseRightDownX = (float)evt.getMouseX();
            mouseRightDownY = (float)evt.getMouseY();
        }
    }

    @SubscribeEvent
    public static void onMouseRelease(ScreenEvent.MouseButtonReleased evt) {
        if (!enabled || OrthoviewClientEvents.isCameraLocked()) {
            return;
        }
        if (evt.getButton() == 0) {
            cameraMovingByMouse = false;
        }
        if (evt.getButton() == 1) {
            cameraMovingByMouse = false;
            OrthoviewClientEvents.rotateCam(camRotAdjX, camRotAdjY);
            camRotAdjX = 0.0f;
            camRotAdjY = 0.0f;
        }
    }

    @SubscribeEvent
    public static void onMouseDrag(ScreenEvent.MouseDragged evt) {
        if (!enabled || OrthoviewClientEvents.isCameraLocked()) {
            return;
        }
        if (evt.getMouseButton() == 0 && Keybindings.altMod.isDown() || evt.getMouseButton() == 2) {
            cameraMovingByMouse = true;
            float moveX = (float)evt.getDragX() * 0.2f * (zoom / 90.0f) * OrthoviewClientEvents.getPanSensitivityMult();
            float moveZ = (float)evt.getDragY() * 0.2f * (zoom / 90.0f) * OrthoviewClientEvents.getPanSensitivityMult();
            OrthoviewClientEvents.panCam(moveX, 0.0f, moveZ);
        } else if (evt.getMouseButton() == 1 && Keybindings.altMod.isDown()) {
            cameraMovingByMouse = true;
            camRotAdjX = (float)(evt.getMouseX() - (double)mouseRightDownX) * 0.12f;
        }
    }

    @SubscribeEvent
    public static void onPlayerRender(RenderPlayerEvent.Pre evt) {
        if (enabled && (evt.getEntity().m_5833_() || evt.getEntity().m_7500_())) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFovModifier(ViewportEvent.ComputeFov evt) {
        if (enabled) {
            evt.setFOV(180.0);
        }
    }

    public static Matrix4f getOrthographicProjection() {
        int width = MC.m_91268_().m_85443_();
        int height = MC.m_91268_().m_85444_();
        float near = -3000.0f;
        float far = 3000.0f;
        float zoomFinal = zoom;
        float wView = zoomFinal / (float)height * (float)width;
        float left = -wView / 2.0f;
        float rgt = wView / 2.0f;
        float top = zoomFinal / 2.0f;
        float bot = -zoomFinal / 2.0f;
        Matrix4f m1 = new Matrix4f(2.0f / (rgt - left), 0.0f, 0.0f, -(rgt + left) / (rgt - left), 0.0f, 2.0f / (top - bot), 0.0f, -(top + bot) / (top - bot), 0.0f, 0.0f, -2.0f / (far - near), -(far + near) / (far - near), 0.0f, 0.0f, 0.0f, 1.0f);
        return m1;
    }

    public static enum LeafHideMethod {
        NONE,
        AROUND_UNITS_AND_CURSOR,
        ALL;

    }
}

