/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.registrars;

import com.solegendary.reignofnether.blocks.FallingRotatedPillarBlock;
import com.solegendary.reignofnether.blocks.GarrisonEntryBlock;
import com.solegendary.reignofnether.blocks.GarrisonExitBlock;
import com.solegendary.reignofnether.blocks.GarrisonZoneBlock;
import com.solegendary.reignofnether.blocks.RTSStartBlock;
import com.solegendary.reignofnether.blocks.RTSStructureBlock;
import com.solegendary.reignofnether.blocks.WalkableMagmaBlock;
import com.solegendary.reignofnether.registrars.ItemRegistrar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockRegistrar {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"reignofnether");
    public static final RegistryObject<Block> DECAYABLE_NETHER_WART_BLOCK = BlockRegistrar.registerBlock("decayable_nether_wart_block", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50054_).m_284180_(MapColor.f_283913_).m_60978_(1.0f).m_60977_().m_284180_(MapColor.f_283913_).m_60918_(SoundType.f_56719_)), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    public static final RegistryObject<Block> DECAYABLE_WARPED_WART_BLOCK = BlockRegistrar.registerBlock("decayable_warped_wart_block", () -> new LeavesBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50054_).m_284180_(MapColor.f_283898_).m_60978_(1.0f).m_60977_().m_284180_(MapColor.f_283898_).m_60918_(SoundType.f_56719_)), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    public static final RegistryObject<Block> FALLING_OAK_LOG = BlockRegistrar.registerBlock("falling_oak_log", () -> BlockRegistrar.fallingLog(MapColor.f_283825_, MapColor.f_283819_), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    public static final RegistryObject<Block> FALLING_SPRUCE_LOG = BlockRegistrar.registerBlock("falling_spruce_log", () -> BlockRegistrar.fallingLog(MapColor.f_283819_, MapColor.f_283748_), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    public static final RegistryObject<Block> FALLING_BIRCH_LOG = BlockRegistrar.registerBlock("falling_birch_log", () -> BlockRegistrar.fallingLog(MapColor.f_283761_, MapColor.f_283942_), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    public static final RegistryObject<Block> FALLING_JUNGLE_LOG = BlockRegistrar.registerBlock("falling_jungle_log", () -> BlockRegistrar.fallingLog(MapColor.f_283762_, MapColor.f_283819_), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    public static final RegistryObject<Block> FALLING_ACACIA_LOG = BlockRegistrar.registerBlock("falling_acacia_log", () -> BlockRegistrar.fallingLog(MapColor.f_283750_, MapColor.f_283947_), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    public static final RegistryObject<Block> FALLING_DARK_OAK_LOG = BlockRegistrar.registerBlock("falling_dark_oak_log", () -> BlockRegistrar.fallingLog(MapColor.f_283748_, MapColor.f_283748_), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    public static final RegistryObject<Block> FALLING_MANGROVE_LOG = BlockRegistrar.registerBlock("falling_mangrove_log", () -> BlockRegistrar.fallingLog(MapColor.f_283913_, MapColor.f_283819_), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    public static final RegistryObject<Block> FALLING_WARPED_STEM = BlockRegistrar.registerBlock("falling_warped_stem", () -> BlockRegistrar.fallingNetherStem(MapColor.f_283749_), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    public static final RegistryObject<Block> FALLING_CRIMSON_STEM = BlockRegistrar.registerBlock("falling_crimson_stem", () -> BlockRegistrar.fallingNetherStem(MapColor.f_283804_), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    public static final RegistryObject<Block> WALKABLE_MAGMA_BLOCK = BlockRegistrar.registerBlock("walkable_magma_block", () -> new WalkableMagmaBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283820_).m_60999_().m_60953_(p_50828_ -> 3).m_60977_().m_60978_(0.5f).m_60922_((p_187421_, p_187422_, p_187423_, p_187424_) -> p_187424_.m_20672_()).m_60982_(BlockRegistrar::always).m_60991_(BlockRegistrar::always)), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256788_);
    public static final RegistryObject<Block> RTS_START_BLOCK_BLUE = BlockRegistrar.registerBlock("rts_start_block_blue", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283743_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_YELLOW = BlockRegistrar.registerBlock("rts_start_block_yellow", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283832_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_GREEN = BlockRegistrar.registerBlock("rts_start_block_green", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283784_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_RED = BlockRegistrar.registerBlock("rts_start_block_red", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283913_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_ORANGE = BlockRegistrar.registerBlock("rts_start_block_orange", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283750_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_CYAN = BlockRegistrar.registerBlock("rts_start_block_cyan", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283772_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_MAGENTA = BlockRegistrar.registerBlock("rts_start_block_magenta", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283931_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_BROWN = BlockRegistrar.registerBlock("rts_start_block_brown", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283748_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_WHITE = BlockRegistrar.registerBlock("rts_start_block_white", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283811_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_BLACK = BlockRegistrar.registerBlock("rts_start_block_black", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283927_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_LIGHT_BLUE = BlockRegistrar.registerBlock("rts_start_block_light_blue", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283869_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_LIME = BlockRegistrar.registerBlock("rts_start_block_lime", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283916_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_LIGHT_GRAY = BlockRegistrar.registerBlock("rts_start_block_light_gray", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283779_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_GRAY = BlockRegistrar.registerBlock("rts_start_block_gray", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283818_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_PURPLE = BlockRegistrar.registerBlock("rts_start_block_purple", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283889_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_START_BLOCK_PINK = BlockRegistrar.registerBlock("rts_start_block_pink", () -> new RTSStartBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_284180_(MapColor.f_283765_).m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> RTS_STRUCTURE_BLOCK = BlockRegistrar.registerBlock("rts_structure_block", () -> new RTSStructureBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283779_).m_60999_().m_60913_(-1.0f, 3600000.0f).m_222994_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> GARRISON_ENTRY_BLOCK = BlockRegistrar.registerBlock("garrison_entry_block", () -> new GarrisonEntryBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283779_).m_60913_(-1.0f, 3600000.0f).m_222994_().m_60955_().m_60910_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> GARRISON_EXIT_BLOCK = BlockRegistrar.registerBlock("garrison_exit_block", () -> new GarrisonExitBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283779_).m_60913_(-1.0f, 3600000.0f).m_222994_().m_60955_().m_60910_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static final RegistryObject<Block> GARRISON_ZONE_BLOCK = BlockRegistrar.registerBlock("garrison_zone_block", () -> new GarrisonZoneBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283779_).m_60913_(-1.0f, 3600000.0f).m_222994_().m_60955_().m_60910_()), (ResourceKey<CreativeModeTab>)CreativeModeTabs.f_256791_);
    public static Map<ResourceKey<CreativeModeTab>, List<Item>> blockItems = new HashMap<ResourceKey<CreativeModeTab>, List<Item>>();

    private static FallingRotatedPillarBlock fallingLog(MapColor pTopColor, MapColor pBarkColor) {
        return new FallingRotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284495_(p_152624_ -> p_152624_.m_61143_((Property)RotatedPillarBlock.f_55923_) == Direction.Axis.Y ? pTopColor : pBarkColor).m_60978_(2.0f).m_60918_(SoundType.f_56736_));
    }

    private static FallingRotatedPillarBlock fallingNetherStem(MapColor pMapColor) {
        return new FallingRotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284495_(p_152620_ -> pMapColor).m_60978_(2.0f).m_60918_(SoundType.f_56763_));
    }

    private static boolean always(BlockState p_50775_, BlockGetter p_50776_, BlockPos p_50777_) {
        return true;
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block, ResourceKey<CreativeModeTab> tab) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockRegistrar.registerBlockItem(name, toReturn, tab);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block, ResourceKey<CreativeModeTab> tab) {
        return ItemRegistrar.ITEMS.register(name, () -> {
            BlockItem blockItem = new BlockItem((Block)block.get(), new Item.Properties());
            blockItems.computeIfAbsent(tab, k -> new ArrayList()).add(blockItem);
            return blockItem;
        });
    }

    public static void init(FMLJavaModLoadingContext context) {
        BLOCKS.register(context.getModEventBus());
    }
}

