/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research.researchItems;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProdDupeRule;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.building.production.StartProductionButton;
import com.solegendary.reignofnether.building.production.StopProductionButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.ZombieUnit;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EntityType;

public class ResearchDrowned
extends ProductionItem {
    public static final String itemName = "Drowned Zombies";
    public static final ResourceCost cost = ResourceCosts.RESEARCH_DROWNED;

    public ResearchDrowned() {
        super(cost, ProdDupeRule.DISALLOW);
        this.onComplete = (level, placement) -> {
            if (level.m_5776_()) {
                ResearchClient.addResearch(placement.ownerName, ProductionItems.RESEARCH_DROWNED);
            } else {
                ResearchServerEvents.addResearch(placement.ownerName, ProductionItems.RESEARCH_DROWNED);
                UnitServerEvents.convertAllToUnit(placement.ownerName, (ServerLevel)level, entity -> {
                    ZombieUnit zUnit;
                    return entity instanceof ZombieUnit && (zUnit = (ZombieUnit)entity).getOwnerName().equals(placement.ownerName) && !zUnit.isSummonedByNecromancer();
                }, (EntityType<? extends Unit>)((EntityType)EntityRegistrar.DROWNED_UNIT.get()));
            }
        };
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    @Override
    public StartProductionButton getStartButton(ProductionPlacement prodBuilding, Keybinding hotkey) {
        return new StartProductionButton(itemName, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/drowned.png"), ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/icon_frame_bronze.png"), hotkey, () -> ProductionItems.RESEARCH_DROWNED.itemIsBeingProduced(prodBuilding.ownerName) || ResearchClient.hasResearch(ProductionItems.RESEARCH_DROWNED), () -> BuildingClientEvents.hasFinishedBuilding(Buildings.GRAVEYARD), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.research_drowned", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.research_drowned.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.research_drowned.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.research_drowned.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public StopProductionButton getCancelButton(ProductionPlacement prodBuilding, boolean first) {
        return new StopProductionButton(itemName, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/drowned.png"), ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/icon_frame_bronze.png"), prodBuilding, this, first);
    }
}

