/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.research.researchItems;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.Buildings;
import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProdDupeRule;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.building.production.StartProductionButton;
import com.solegendary.reignofnether.building.production.StopProductionButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.SpiderUnit;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EntityType;

public class ResearchPoisonSpiders
extends ProductionItem {
    public static final String itemName = "Poison Spiders";
    public static final ResourceCost cost = ResourceCosts.RESEARCH_POISON_SPIDERS;

    public ResearchPoisonSpiders() {
        super(cost, ProdDupeRule.DISALLOW);
        this.onComplete = (level, placement) -> {
            if (level.m_5776_()) {
                ResearchClient.addResearch(placement.ownerName, ProductionItems.RESEARCH_POISON_SPIDERS);
            } else {
                ResearchServerEvents.addResearch(placement.ownerName, ProductionItems.RESEARCH_POISON_SPIDERS);
                UnitServerEvents.convertAllToUnit(placement.ownerName, (ServerLevel)level, entity -> {
                    SpiderUnit zUnit;
                    return entity instanceof SpiderUnit && (zUnit = (SpiderUnit)entity).getOwnerName().equals(placement.ownerName);
                }, (EntityType<? extends Unit>)((EntityType)EntityRegistrar.POISON_SPIDER_UNIT.get()));
            }
        };
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    @Override
    public StartProductionButton getStartButton(ProductionPlacement prodBuilding, Keybinding hotkey) {
        return new StartProductionButton(itemName, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/cave_spider.png"), ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/icon_frame_bronze.png"), hotkey, () -> ProductionItems.RESEARCH_POISON_SPIDERS.itemIsBeingProduced(prodBuilding.ownerName) || ResearchClient.hasResearch(ProductionItems.RESEARCH_POISON_SPIDERS), () -> BuildingClientEvents.hasFinishedBuilding(Buildings.SPIDER_LAIR), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.research_poison_spiders", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.research_poison_spiders.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.research_poison_spiders.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"research.reignofnether.research_poison_spiders.tooltip3", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public StopProductionButton getCancelButton(ProductionPlacement prodBuilding, boolean first) {
        return new StopProductionButton(itemName, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/cave_spider.png"), ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/icon_frame_bronze.png"), prodBuilding, this, first);
    }
}

