/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources;

import com.solegendary.reignofnether.registrars.BlockRegistrar;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;

public class BlockUtils {
    public static boolean isLogBlock(BlockState bs) {
        return List.of(Blocks.f_49999_, Blocks.f_50001_, Blocks.f_50003_, Blocks.f_50004_, Blocks.f_50002_, Blocks.f_220832_, Blocks.f_50000_, Blocks.f_50011_, Blocks.f_50013_, Blocks.f_50015_, Blocks.f_50043_, Blocks.f_50014_, Blocks.f_220836_, Blocks.f_50012_, Blocks.f_50695_, Blocks.f_50686_, Blocks.f_50182_, Blocks.f_50181_, Blocks.f_50180_, Blocks.f_50697_, Blocks.f_50688_).contains(bs.m_60734_()) || bs.m_204343_().collect(Collectors.toSet()).contains(BlockTags.f_13106_);
    }

    public static boolean isFallingLogBlock(BlockState bs) {
        return List.of((Block)BlockRegistrar.FALLING_OAK_LOG.get(), (Block)BlockRegistrar.FALLING_BIRCH_LOG.get(), (Block)BlockRegistrar.FALLING_ACACIA_LOG.get(), (Block)BlockRegistrar.FALLING_DARK_OAK_LOG.get(), (Block)BlockRegistrar.FALLING_JUNGLE_LOG.get(), (Block)BlockRegistrar.FALLING_MANGROVE_LOG.get(), (Block)BlockRegistrar.FALLING_SPRUCE_LOG.get(), (Block)BlockRegistrar.FALLING_CRIMSON_STEM.get(), (Block)BlockRegistrar.FALLING_WARPED_STEM.get()).contains(bs.m_60734_());
    }

    public static BlockState getNonFallingLog(BlockState bs) {
        BlockState nonFallingLogBlock = bs;
        if (bs.m_60734_() == BlockRegistrar.FALLING_OAK_LOG.get()) {
            nonFallingLogBlock = Blocks.f_49999_.m_49966_();
        } else if (bs.m_60734_() == BlockRegistrar.FALLING_BIRCH_LOG.get()) {
            nonFallingLogBlock = Blocks.f_50001_.m_49966_();
        } else if (bs.m_60734_() == BlockRegistrar.FALLING_ACACIA_LOG.get()) {
            nonFallingLogBlock = Blocks.f_50003_.m_49966_();
        } else if (bs.m_60734_() == BlockRegistrar.FALLING_DARK_OAK_LOG.get()) {
            nonFallingLogBlock = Blocks.f_50004_.m_49966_();
        } else if (bs.m_60734_() == BlockRegistrar.FALLING_JUNGLE_LOG.get()) {
            nonFallingLogBlock = Blocks.f_50002_.m_49966_();
        } else if (bs.m_60734_() == BlockRegistrar.FALLING_MANGROVE_LOG.get()) {
            nonFallingLogBlock = Blocks.f_220832_.m_49966_();
        } else if (bs.m_60734_() == BlockRegistrar.FALLING_SPRUCE_LOG.get()) {
            nonFallingLogBlock = Blocks.f_50000_.m_49966_();
        } else if (bs.m_60734_() == BlockRegistrar.FALLING_CRIMSON_STEM.get()) {
            nonFallingLogBlock = Blocks.f_50695_.m_49966_();
        } else if (bs.m_60734_() == BlockRegistrar.FALLING_WARPED_STEM.get()) {
            nonFallingLogBlock = Blocks.f_50686_.m_49966_();
        }
        return nonFallingLogBlock;
    }

    public static boolean isLeafBlock(BlockState bs) {
        if (bs.m_204336_(BlockTags.f_13035_)) {
            return true;
        }
        return List.of(Blocks.f_50050_, Blocks.f_50052_, Blocks.f_50054_, Blocks.f_50055_, Blocks.f_50053_, Blocks.f_220838_, Blocks.f_50051_, (Block)BlockRegistrar.DECAYABLE_NETHER_WART_BLOCK.get(), (Block)BlockRegistrar.DECAYABLE_WARPED_WART_BLOCK.get(), Blocks.f_50181_, Blocks.f_50180_).contains(bs.m_60734_());
    }

    public static boolean isBottomSlab(BlockState bs) {
        if (bs.m_60734_() instanceof SlabBlock) {
            SlabType type = (SlabType)bs.m_61143_((Property)SlabBlock.f_56353_);
            return type == SlabType.BOTTOM;
        }
        return false;
    }

    public static int numAirOrLeafBlocksBelow(BlockPos bp, Level level) {
        int blocks = 0;
        for (int i = -1; i > -10; --i) {
            BlockState bs = level.m_8055_(bp.m_7918_(0, i, 0));
            if (bs.m_60795_() || BlockUtils.isLeafBlock(bs)) {
                ++blocks;
                continue;
            }
            if (!BlockUtils.isLogBlock(bs)) break;
        }
        return blocks;
    }
}

