/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.resources;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesAction;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ResourcesServerboundPacket {
    ResourcesAction action;
    public String senderName;
    public String receiverName;
    public int food;
    public int wood;
    public int ore;

    public static void sendResources(Resources resources, String senderName) {
        PacketHandler.INSTANCE.sendToServer((Object)new ResourcesServerboundPacket(ResourcesAction.SEND_RESOURCES, senderName, resources.ownerName, resources.food, resources.wood, resources.ore));
    }

    public ResourcesServerboundPacket(ResourcesAction action, String senderName, String receiverName, int food, int wood, int ore) {
        this.action = action;
        this.senderName = senderName;
        this.receiverName = receiverName;
        this.food = food;
        this.wood = wood;
        this.ore = ore;
    }

    public ResourcesServerboundPacket(FriendlyByteBuf buffer) {
        this.action = (ResourcesAction)buffer.m_130066_(ResourcesAction.class);
        this.senderName = buffer.m_130277_();
        this.receiverName = buffer.m_130277_();
        this.food = buffer.readInt();
        this.wood = buffer.readInt();
        this.ore = buffer.readInt();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.action);
        buffer.m_130070_(this.senderName);
        buffer.m_130070_(this.receiverName);
        buffer.writeInt(this.food);
        buffer.writeInt(this.wood);
        buffer.writeInt(this.ore);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                ReignOfNether.LOGGER.warn("ResourcesServerboundPacket: Sender was null");
                success.set(false);
                return;
            }
            if (!player.m_7755_().getString().equals(this.senderName)) {
                ReignOfNether.LOGGER.warn("ResourcesServerboundPacket: Tried to process packet from " + player.m_7755_() + " for: " + this.senderName);
                success.set(false);
                return;
            }
            if (this.action == ResourcesAction.SEND_RESOURCES) {
                ResourcesServerEvents.trySendingAnyResources(this.receiverName, new Resources(this.senderName, this.food, this.wood, this.ore));
            }
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

