/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.sandbox;

import com.solegendary.reignofnether.building.BuildingClientEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.sandbox.SandboxAction;
import com.solegendary.reignofnether.sandbox.SandboxClientEvents;
import com.solegendary.reignofnether.sandbox.SandboxServerboundPacket;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SandboxActionButtons {
    private static final Minecraft MC = Minecraft.m_91087_();
    public static Button setAnchor;
    public static Button resetToAnchor;
    public static Button removeAnchor;
    public static Button removeBuildingPlacement;

    private static boolean neutralUnitsSelected() {
        for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
            Unit unit;
            if (!(entity instanceof Unit) || (unit = (Unit)entity).getOwnerName().isBlank()) continue;
            return false;
        }
        return true;
    }

    private static boolean selectedUnitsHaveAnchor() {
        for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
            Unit unit;
            if (!(entity instanceof Unit) || (unit = (Unit)entity).getAnchor() == null || unit.getAnchor().equals((Object)new BlockPos(0, 0, 0))) continue;
            return true;
        }
        return false;
    }

    public static void updateButtons() {
        setAnchor = new Button("Set Anchor", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/respawn_anchor_side4.png"), (Keybinding)null, () -> CursorClientEvents.getLeftClickSandboxAction() == SandboxAction.SET_ANCHOR, () -> !SandboxClientEvents.isSandboxPlayer(), () -> true, () -> CursorClientEvents.setLeftClickSandboxAction(SandboxAction.SET_ANCHOR), null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.actionbuttons.reignofnether.set_anchor", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"hud.actionbuttons.reignofnether.set_anchor.tooltip1", (Object[])new Object[0]))));
        resetToAnchor = new Button("Reset to Anchor", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/respawn_anchor_top_off.png"), (Keybinding)null, () -> CursorClientEvents.getLeftClickSandboxAction() == SandboxAction.RESET_TO_ANCHOR, () -> !SandboxClientEvents.isSandboxPlayer(), SandboxActionButtons::selectedUnitsHaveAnchor, () -> {
            SandboxServerboundPacket.resetToAnchor(UnitClientEvents.getSelectedUnits().stream().mapToInt(Entity::m_19879_).toArray());
            for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
                if (!(entity instanceof Unit)) continue;
                Unit unit = (Unit)entity;
                Unit.fullResetBehaviours(unit);
            }
        }, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.actionbuttons.reignofnether.reset_to_anchor", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"hud.actionbuttons.reignofnether.reset_to_anchor.tooltip1", (Object[])new Object[0]))));
        removeAnchor = new Button("Remove Anchor", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/barrier.png"), (Keybinding)null, () -> CursorClientEvents.getLeftClickSandboxAction() == SandboxAction.REMOVE_ANCHOR, () -> !SandboxClientEvents.isSandboxPlayer(), SandboxActionButtons::selectedUnitsHaveAnchor, () -> SandboxServerboundPacket.removeAnchor(UnitClientEvents.getSelectedUnits().stream().mapToInt(Entity::m_19879_).toArray()), null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.actionbuttons.reignofnether.remove_anchor", (Object[])new Object[0]), true)));
        removeBuildingPlacement = new Button("Remove Building Placement", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/items/barrier.png"), (Keybinding)null, () -> false, () -> !SandboxClientEvents.isSandboxPlayer(), () -> true, () -> {
            if (HudClientEvents.hudSelectedPlacement != null) {
                SandboxServerboundPacket.removeBuilding(HudClientEvents.hudSelectedPlacement.originPos);
            }
        }, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.actionbuttons.reignofnether.remove_building", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"hud.actionbuttons.reignofnether.remove_building.tooltip1", (Object[])new Object[0]))));
    }

    public static Button getSetRelationshipButton() {
        Relationship relationship = Relationship.OWNED;
        if (HudClientEvents.hudSelectedEntity != null) {
            relationship = UnitClientEvents.getPlayerToEntityRelationship(HudClientEvents.hudSelectedEntity);
        } else if (HudClientEvents.hudSelectedPlacement != null) {
            relationship = BuildingClientEvents.getPlayerToBuildingRelationship(HudClientEvents.hudSelectedPlacement);
        }
        Relationship finalRelationship = relationship;
        return new Button("Toggle Relationship", Button.itemIconSize, switch (finalRelationship) {
            default -> throw new IncompatibleClassChangeError();
            case Relationship.OWNED -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/lime_wool.png");
            case Relationship.FRIENDLY -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/blue_wool.png");
            case Relationship.NEUTRAL -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/yellow_wool.png");
            case Relationship.HOSTILE -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/red_wool.png");
        }, (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            if (SandboxActionButtons.MC.f_91074_ != null) {
                block8: for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
                    if (!(entity instanceof Unit)) continue;
                    Unit unit = (Unit)entity;
                    switch (finalRelationship) {
                        default: {
                            unit.setOwnerName("");
                            continue block8;
                        }
                        case NEUTRAL: {
                            unit.setOwnerName("Enemy");
                            continue block8;
                        }
                        case HOSTILE: 
                    }
                    unit.setOwnerName(SandboxActionButtons.MC.f_91074_.m_7755_().getString());
                }
                LivingEntity patt7767$temp = HudClientEvents.hudSelectedEntity;
                if (patt7767$temp instanceof Unit) {
                    Unit unit = (Unit)patt7767$temp;
                    SandboxServerboundPacket.setUnitOwner(UnitClientEvents.getSelectedUnits().stream().mapToInt(Entity::m_19879_).toArray(), unit.getOwnerName());
                    SandboxActionButtons.updateButtons();
                }
                for (BuildingPlacement bpl : BuildingClientEvents.getSelectedBuildings()) {
                    switch (finalRelationship) {
                        default: {
                            bpl.ownerName = "";
                            break;
                        }
                        case NEUTRAL: {
                            bpl.ownerName = "Enemy";
                            break;
                        }
                        case HOSTILE: {
                            bpl.ownerName = SandboxActionButtons.MC.f_91074_.m_7755_().getString();
                        }
                    }
                    SandboxServerboundPacket.setBuildingOwner(bpl.originPos, bpl.ownerName);
                    SandboxActionButtons.updateButtons();
                }
            }
        }, () -> {
            if (SandboxActionButtons.MC.f_91074_ != null) {
                block8: for (LivingEntity entity : UnitClientEvents.getSelectedUnits()) {
                    if (!(entity instanceof Unit)) continue;
                    Unit unit = (Unit)entity;
                    switch (finalRelationship) {
                        default: {
                            unit.setOwnerName("Enemy");
                            continue block8;
                        }
                        case NEUTRAL: {
                            unit.setOwnerName(SandboxActionButtons.MC.f_91074_.m_7755_().getString());
                            continue block8;
                        }
                        case HOSTILE: 
                    }
                    unit.setOwnerName("");
                }
                LivingEntity patt9378$temp = HudClientEvents.hudSelectedEntity;
                if (patt9378$temp instanceof Unit) {
                    Unit unit = (Unit)patt9378$temp;
                    SandboxServerboundPacket.setUnitOwner(UnitClientEvents.getSelectedUnits().stream().mapToInt(Entity::m_19879_).toArray(), unit.getOwnerName());
                    SandboxActionButtons.updateButtons();
                }
                for (BuildingPlacement bpl : BuildingClientEvents.getSelectedBuildings()) {
                    switch (finalRelationship) {
                        default: {
                            bpl.ownerName = "Enemy";
                            break;
                        }
                        case NEUTRAL: {
                            bpl.ownerName = SandboxActionButtons.MC.f_91074_.m_7755_().getString();
                            break;
                        }
                        case HOSTILE: {
                            bpl.ownerName = "";
                        }
                    }
                    SandboxServerboundPacket.setBuildingOwner(bpl.originPos, bpl.ownerName);
                    SandboxActionButtons.updateButtons();
                }
            }
        }, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.relationship.reignofnether.owned", (Object[])new Object[0]), relationship == Relationship.OWNED), MiscUtil.fcs(I18n.m_118938_((String)"hud.relationship.reignofnether.neutral", (Object[])new Object[0]), relationship == Relationship.NEUTRAL), MiscUtil.fcs(I18n.m_118938_((String)"hud.relationship.reignofnether.enemy", (Object[])new Object[0]), relationship == Relationship.HOSTILE)));
    }

    static {
        SandboxActionButtons.updateButtons();
    }
}

