/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.sandbox;

import com.solegendary.reignofnether.api.ReignOfNetherRegistries;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingPlaceButton;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.custombuilding.CustomBuildingClientEvents;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.gamemode.ClientGameModeHelper;
import com.solegendary.reignofnether.gamemode.GameMode;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.hud.buttons.UnitSpawnButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.orthoview.OrthoviewClientEvents;
import com.solegendary.reignofnether.player.PlayerClientEvents;
import com.solegendary.reignofnether.player.PlayerServerboundPacket;
import com.solegendary.reignofnether.registrars.BlockRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerboundPacket;
import com.solegendary.reignofnether.sandbox.SandboxAction;
import com.solegendary.reignofnether.sandbox.SandboxMenuType;
import com.solegendary.reignofnether.sandbox.SandboxServerboundPacket;
import com.solegendary.reignofnether.unit.Relationship;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.units.monsters.ZombieVillagerUnit;
import com.solegendary.reignofnether.unit.units.piglins.GruntUnit;
import com.solegendary.reignofnether.unit.units.villagers.VillagerUnit;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SandboxClientEvents {
    private static Faction faction = Faction.NONE;
    public static Relationship relationship = Relationship.OWNED;
    public static SandboxMenuType sandboxMenuType = SandboxMenuType.UNITS;
    private static final Minecraft MC = Minecraft.m_91087_();
    public static String spawnUnitName = "";

    public static Faction getFaction() {
        return faction;
    }

    public static boolean isSandboxPlayer(String playerName) {
        return SandboxClientEvents.MC.f_91074_ != null && playerName.equals(SandboxClientEvents.MC.f_91074_.m_7755_().getString()) && PlayerClientEvents.isRTSPlayer() && ClientGameModeHelper.gameMode == GameMode.SANDBOX;
    }

    public static boolean isSandboxPlayer() {
        return PlayerClientEvents.isRTSPlayer() && ClientGameModeHelper.gameMode == GameMode.SANDBOX;
    }

    public static List<BuildingPlaceButton> getNeutralBuildingButtons() {
        ArrayList<BuildingPlaceButton> buildingButtons = new ArrayList<BuildingPlaceButton>();
        List<Keybinding> keybindings = BuildingUtils.keybindings;
        int index = 0;
        for (Building building : ReignOfNetherRegistries.BUILDING) {
            BuildingPlaceButton button;
            if (building.getFaction() != Faction.NONE || (button = building.getBuildButton(index >= keybindings.size() ? null : keybindings.get(index))) == null) continue;
            buildingButtons.add(button);
            ++index;
        }
        return buildingButtons;
    }

    public static List<BuildingPlaceButton> getBuildingButtons() {
        return switch (faction) {
            default -> throw new IncompatibleClassChangeError();
            case Faction.VILLAGERS -> VillagerUnit.getBuildingButtons();
            case Faction.MONSTERS -> ZombieVillagerUnit.getBuildingButtons();
            case Faction.PIGLINS -> GruntUnit.getBuildingButtons();
            case Faction.NONE -> SandboxClientEvents.getNeutralBuildingButtons();
        };
    }

    public static List<Button> getCustomBuildingButtons() {
        if (CustomBuildingClientEvents.customBuildings.isEmpty()) {
            return List.of(new Button("Custom building info", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/help.png"), (Keybinding)null, () -> false, () -> false, () -> true, () -> {
                if (SandboxClientEvents.MC.f_91074_ != null) {
                    SandboxClientEvents.MC.f_91074_.m_36356_(new ItemStack((ItemLike)BlockRegistrar.RTS_STRUCTURE_BLOCK.get()));
                }
            }, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings_info.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings_info.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.custom_buildings_info.tooltip3", (Object[])new Object[0])))));
        }
        return CustomBuildingClientEvents.customBuildings.stream().map(cb -> cb.getBuildButton(null)).toList();
    }

    public static List<UnitSpawnButton> getUnitButtons() {
        return switch (faction) {
            default -> throw new IncompatibleClassChangeError();
            case Faction.VILLAGERS -> List.of(ProductionItems.VILLAGER.getPlaceButton(), ProductionItems.VINDICATOR.getPlaceButton(), ProductionItems.PILLAGER.getPlaceButton(), ProductionItems.IRON_GOLEM.getPlaceButton(), ProductionItems.WITCH.getPlaceButton(), ProductionItems.EVOKER.getPlaceButton(), ProductionItems.RAVAGER.getPlaceButton(), ProductionItems.ROYAL_GUARD.getPlaceButton(), ProductionItems.ENCHANTER.getPlaceButton());
            case Faction.MONSTERS -> List.of(ProductionItems.ZOMBIE_VILLAGER.getPlaceButton(), ProductionItems.ZOMBIE.getPlaceButton(), ProductionItems.DROWNED.getPlaceButton(), ProductionItems.HUSK.getPlaceButton(), ProductionItems.SKELETON.getPlaceButton(), ProductionItems.STRAY.getPlaceButton(), ProductionItems.SPIDER.getPlaceButton(), ProductionItems.POISON_SPIDER.getPlaceButton(), ProductionItems.CREEPER.getPlaceButton(), ProductionItems.SLIME.getPlaceButton(), ProductionItems.WARDEN.getPlaceButton(), ProductionItems.ZOMBIE_PIGLIN.getPlaceButton(), ProductionItems.ZOGLIN.getPlaceButton(), ProductionItems.NECROMANCER.getPlaceButton(), ProductionItems.WRETCHED_WRAITH.getPlaceButton());
            case Faction.PIGLINS -> List.of(ProductionItems.GRUNT.getPlaceButton(), ProductionItems.BRUTE.getPlaceButton(), ProductionItems.HEADHUNTER.getPlaceButton(), ProductionItems.HOGLIN.getPlaceButton(), ProductionItems.BLAZE.getPlaceButton(), ProductionItems.WITHER_SKELETON.getPlaceButton(), ProductionItems.MAGMA_CUBE.getPlaceButton(), ProductionItems.GHAST.getPlaceButton(), ProductionItems.PIGLIN_MERCHANT.getPlaceButton(), ProductionItems.WILDFIRE.getPlaceButton());
            case Faction.NONE -> List.of(ProductionItems.ENDERMAN.getPlaceButton(), ProductionItems.POLAR_BEAR.getPlaceButton(), ProductionItems.GRIZZLY_BEAR.getPlaceButton(), ProductionItems.PANDA.getPlaceButton(), ProductionItems.WOLF.getPlaceButton(), ProductionItems.LLAMA.getPlaceButton());
        };
    }

    private static String getFactionName() {
        return switch (faction) {
            default -> throw new IncompatibleClassChangeError();
            case Faction.VILLAGERS -> I18n.m_118938_((String)"hud.faction.reignofnether.villager", (Object[])new Object[0]);
            case Faction.MONSTERS -> I18n.m_118938_((String)"hud.faction.reignofnether.monster", (Object[])new Object[0]);
            case Faction.PIGLINS -> I18n.m_118938_((String)"hud.faction.reignofnether.piglin", (Object[])new Object[0]);
            case Faction.NONE -> I18n.m_118938_((String)"hud.faction.reignofnether.neutral", (Object[])new Object[0]);
        };
    }

    public static String getRelationshipName(Relationship relationship) {
        return switch (relationship) {
            default -> throw new IncompatibleClassChangeError();
            case Relationship.OWNED -> I18n.m_118938_((String)"hud.relationship.reignofnether.owned", (Object[])new Object[0]);
            case Relationship.FRIENDLY -> I18n.m_118938_((String)"hud.relationship.reignofnether.allied", (Object[])new Object[0]);
            case Relationship.NEUTRAL -> I18n.m_118938_((String)"hud.relationship.reignofnether.neutral", (Object[])new Object[0]);
            case Relationship.HOSTILE -> I18n.m_118938_((String)"hud.relationship.reignofnether.enemy", (Object[])new Object[0]);
        };
    }

    public static Button getToggleFactionButton() {
        return new Button("Toggle Faction", Button.itemIconSize, switch (faction) {
            default -> throw new IncompatibleClassChangeError();
            case Faction.VILLAGERS -> ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/villager.png");
            case Faction.MONSTERS -> ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/creeper.png");
            case Faction.PIGLINS -> ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/grunt.png");
            case Faction.NONE -> ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/sheep.png");
        }, (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            switch (faction) {
                case VILLAGERS: {
                    faction = Faction.MONSTERS;
                    break;
                }
                case MONSTERS: {
                    faction = Faction.PIGLINS;
                    break;
                }
                case PIGLINS: {
                    faction = Faction.NONE;
                    break;
                }
                case NONE: {
                    faction = Faction.VILLAGERS;
                }
            }
        }, () -> {
            switch (faction) {
                case VILLAGERS: {
                    faction = Faction.NONE;
                    break;
                }
                case MONSTERS: {
                    faction = Faction.VILLAGERS;
                    break;
                }
                case PIGLINS: {
                    faction = Faction.MONSTERS;
                    break;
                }
                case NONE: {
                    faction = Faction.PIGLINS;
                }
            }
        }, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.faction.reignofnether.villager", (Object[])new Object[0]), faction == Faction.VILLAGERS), MiscUtil.fcs(I18n.m_118938_((String)"hud.faction.reignofnether.monster", (Object[])new Object[0]), faction == Faction.MONSTERS), MiscUtil.fcs(I18n.m_118938_((String)"hud.faction.reignofnether.piglin", (Object[])new Object[0]), faction == Faction.PIGLINS), MiscUtil.fcs(I18n.m_118938_((String)"hud.faction.reignofnether.neutral", (Object[])new Object[0]), faction == Faction.NONE)));
    }

    public static Button getToggleRelationshipButton() {
        return new Button("Toggle Relationship", Button.itemIconSize, switch (relationship) {
            default -> throw new IncompatibleClassChangeError();
            case Relationship.OWNED -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/lime_wool.png");
            case Relationship.FRIENDLY -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/blue_wool.png");
            case Relationship.NEUTRAL -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/yellow_wool.png");
            case Relationship.HOSTILE -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/red_wool.png");
        }, (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            switch (relationship) {
                default: {
                    relationship = Relationship.NEUTRAL;
                    break;
                }
                case NEUTRAL: {
                    relationship = Relationship.HOSTILE;
                    break;
                }
                case HOSTILE: {
                    relationship = Relationship.OWNED;
                }
            }
        }, () -> {
            switch (relationship) {
                default: {
                    relationship = Relationship.HOSTILE;
                    break;
                }
                case NEUTRAL: {
                    relationship = Relationship.OWNED;
                    break;
                }
                case HOSTILE: {
                    relationship = Relationship.NEUTRAL;
                }
            }
        }, List.of(MiscUtil.fcs(I18n.m_118938_((String)"hud.relationship.reignofnether.owned", (Object[])new Object[0]), relationship == Relationship.OWNED), MiscUtil.fcs(I18n.m_118938_((String)"hud.relationship.reignofnether.neutral", (Object[])new Object[0]), relationship == Relationship.NEUTRAL), MiscUtil.fcs(I18n.m_118938_((String)"hud.relationship.reignofnether.enemy", (Object[])new Object[0]), relationship == Relationship.HOSTILE)));
    }

    public static Button getCycleBuildingOrUnitsButton() {
        return new Button("Toggle Building or Units", Button.itemIconSize, switch (sandboxMenuType) {
            default -> throw new IncompatibleClassChangeError();
            case SandboxMenuType.UNITS -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/spawn_egg.png");
            case SandboxMenuType.BUILDINGS -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/crafting_table_front.png");
            case SandboxMenuType.CUSTOM_BUILDINGS -> ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/block/smithing_table_front.png");
        }, (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            switch (sandboxMenuType) {
                case UNITS: {
                    sandboxMenuType = SandboxMenuType.BUILDINGS;
                    break;
                }
                case BUILDINGS: {
                    sandboxMenuType = SandboxMenuType.CUSTOM_BUILDINGS;
                    break;
                }
                case CUSTOM_BUILDINGS: {
                    sandboxMenuType = SandboxMenuType.UNITS;
                }
            }
        }, () -> {
            switch (sandboxMenuType) {
                case UNITS: {
                    sandboxMenuType = SandboxMenuType.CUSTOM_BUILDINGS;
                    break;
                }
                case BUILDINGS: {
                    sandboxMenuType = SandboxMenuType.UNITS;
                    break;
                }
                case CUSTOM_BUILDINGS: {
                    sandboxMenuType = SandboxMenuType.BUILDINGS;
                }
            }
        }, List.of(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.menu_type_button_units", (Object[])new Object[0]), sandboxMenuType == SandboxMenuType.UNITS), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.menu_type_button_buildings", (Object[])new Object[0]), sandboxMenuType == SandboxMenuType.BUILDINGS), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.menu_type_button_custom_buildings", (Object[])new Object[0]), sandboxMenuType == SandboxMenuType.CUSTOM_BUILDINGS)));
    }

    public static Button getToggleBuildingCheatsButton() {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ == null) {
            return null;
        }
        boolean hasCheats = ResearchClient.hasCheat("warpten") && ResearchClient.hasCheat("modifythephasevariance");
        String playerName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        return new Button("Toggle Building Cheats", Button.itemIconSize, hasCheats ? ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/command_block_side.png") : ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/command_block_side_dark.png"), (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            if (hasCheats) {
                ResearchServerboundPacket.removeCheat(playerName, "warpten");
                ResearchServerboundPacket.removeCheat(playerName, "modifythephasevariance");
            } else {
                ResearchServerboundPacket.addCheat(playerName, "warpten");
                ResearchServerboundPacket.addCheat(playerName, "modifythephasevariance");
            }
        }, null, List.of(hasCheats ? MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.building_cheats_on", (Object[])new Object[0])) : MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.building_cheats_off", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.building_cheats1", (Object[])new Object[0]))));
    }

    public static Button getToggleUnitCheatsButton() {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ == null) {
            return null;
        }
        boolean hasCheats = ResearchClient.hasCheat("operationcwal") && ResearchClient.hasCheat("medievalman") && ResearchClient.hasCheat("foodforthought") && ResearchClient.hasCheat("slipslopslap");
        String playerName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        return new Button("Toggle Unit Cheats", Button.itemIconSize, hasCheats ? ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/chain_command_block_side.png") : ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/chain_command_block_side_dark.png"), (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            if (hasCheats) {
                ResearchServerboundPacket.removeCheat(playerName, "operationcwal");
                ResearchServerboundPacket.removeCheat(playerName, "medievalman");
                ResearchServerboundPacket.removeCheat(playerName, "foodforthought");
                ResearchServerboundPacket.removeCheat(playerName, "slipslopslap");
            } else {
                ResearchServerboundPacket.addCheat(playerName, "operationcwal");
                ResearchServerboundPacket.addCheat(playerName, "medievalman");
                ResearchServerboundPacket.addCheat(playerName, "foodforthought");
                ResearchServerboundPacket.addCheat(playerName, "slipslopslap");
            }
        }, null, List.of(hasCheats ? MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.unit_cheats_on", (Object[])new Object[0])) : MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.unit_cheats_off", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.unit_cheats1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.unit_cheats2", (Object[])new Object[0]))));
    }

    public static Button getToggleNonUnitControlButton() {
        Minecraft MC = Minecraft.m_91087_();
        if (MC.f_91074_ == null) {
            return null;
        }
        boolean hasCheat = ResearchClient.hasCheat("wouldyoukindly");
        String playerName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        return new Button("Toggle Full Unit Control", Button.itemIconSize, hasCheat ? ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/repeating_command_block_side.png") : ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/icons/blocks/repeating_command_block_side_dark.png"), (Keybinding)null, () -> false, () -> false, () -> true, () -> {
            if (hasCheat) {
                ResearchServerboundPacket.removeCheat(playerName, "wouldyoukindly");
            } else {
                ResearchServerboundPacket.addCheat(playerName, "wouldyoukindly");
            }
        }, null, List.of(hasCheat ? MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.nonunit_control_cheat_on", (Object[])new Object[0])) : MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.nonunit_control_cheat_off", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.nonunit_control_cheat1", (Object[])new Object[0]))));
    }

    public static Button getExitSandboxButton() {
        return new Button("Exit Sandbox Mode", Button.itemIconSize, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/hud/cross.png"), (Keybinding)null, () -> false, () -> false, () -> true, PlayerServerboundPacket::resetRTS, null, List.of(MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.exit1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"sandbox.reignofnether.exit2", (Object[])new Object[0]))));
    }

    @SubscribeEvent
    public static void onMouseClick(ScreenEvent.MouseButtonPressed.Post evt) {
        if (!OrthoviewClientEvents.isEnabled()) {
            return;
        }
        if (HudClientEvents.isMouseOverAnyButtonOrHud() || SandboxClientEvents.MC.f_91074_ == null) {
            CursorClientEvents.setLeftClickSandboxAction(null);
            return;
        }
        SandboxAction sandboxAction = CursorClientEvents.getLeftClickSandboxAction();
        if (evt.getButton() == 0 && sandboxAction != null) {
            String ownerName = switch (relationship) {
                case Relationship.NEUTRAL -> "";
                case Relationship.HOSTILE -> "Enemy";
                default -> SandboxClientEvents.MC.f_91074_.m_7755_().getString();
            };
            switch (sandboxAction) {
                case SPAWN_UNIT: {
                    SandboxServerboundPacket.spawnUnit(CursorClientEvents.getLeftClickSandboxAction(), ownerName, spawnUnitName, CursorClientEvents.getPreselectedBlockPos());
                    break;
                }
                case SET_ANCHOR: {
                    SandboxServerboundPacket.setAnchor(CursorClientEvents.getPreselectedBlockPos(), UnitClientEvents.getSelectedUnits().stream().mapToInt(Entity::m_19879_).toArray());
                }
            }
            if (!Keybindings.shiftMod.isDown()) {
                spawnUnitName = "";
                CursorClientEvents.setLeftClickSandboxAction(null);
            }
        }
        if (evt.getButton() == 1) {
            spawnUnitName = "";
            CursorClientEvents.setLeftClickSandboxAction(null);
        }
    }
}

