/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit;

import com.mojang.datafixers.util.Pair;
import com.solegendary.reignofnether.registrars.GameRuleRegistrar;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.units.monsters.PhantomSummon;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class NonUnitServerEvents {
    public static final List<PathfinderMob> attackSuppressedNonUnits = Collections.synchronizedList(new ArrayList());
    public static final List<PathfinderMob> moveSuppressedNonUnits = Collections.synchronizedList(new ArrayList());
    public static final List<Pair<PathfinderMob, BlockPos>> nonUnitMoveTargets = Collections.synchronizedList(new ArrayList());

    public static boolean canControlAllMobs(Level level, String playerName) {
        return ResearchServerEvents.playerHasCheat(playerName, "wouldyoukindly");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent evt) {
        if (evt.phase != TickEvent.Phase.END || evt.level.m_5776_() || evt.level.m_46472_() != Level.f_46428_) {
            return;
        }
        List<Pair<PathfinderMob, BlockPos>> list = nonUnitMoveTargets;
        synchronized (list) {
            nonUnitMoveTargets.removeIf(pair -> {
                PathfinderMob mob = (PathfinderMob)pair.getFirst();
                BlockPos finalTargetBp = (BlockPos)pair.getSecond();
                Path navPath = mob.m_21573_().m_26570_();
                if (mob.m_20238_(finalTargetBp.m_252807_()) < 4.0) {
                    return true;
                }
                if (mob.f_19797_ % 20 == 0 && navPath == null || navPath != null && navPath.m_77395_() != null && mob.m_20238_(navPath.m_77395_().m_77288_().m_252807_()) < 4.0) {
                    Path path = mob.m_21573_().m_26524_((double)finalTargetBp.m_123341_(), (double)finalTargetBp.m_123342_(), (double)finalTargetBp.m_123343_(), 0);
                    mob.m_21573_().m_26536_(path, 1.0);
                }
                return false;
            });
        }
        list = attackSuppressedNonUnits;
        synchronized (list) {
            attackSuppressedNonUnits.removeIf(mob -> mob.m_21224_() || mob.m_213877_() || mob.m_21573_().m_26571_() && mob.m_5448_() == null);
        }
        list = moveSuppressedNonUnits;
        synchronized (list) {
            moveSuppressedNonUnits.removeIf(mob -> mob.m_21224_() || mob.m_213877_() || mob.m_21573_().m_26571_() && mob.m_5448_() == null);
        }
        if (evt.level.m_7654_() != null && ((GameRules.BooleanValue)evt.level.m_7654_().m_129900_().m_46170_(GameRuleRegistrar.NEUTRAL_AGGRO)).m_46223_()) {
            HashSet pfMobs = new HashSet();
            for (LivingEntity unit : UnitServerEvents.getAllUnits()) {
                if (unit.f_19797_ % 20 != 0) continue;
                AABB aabb = new AABB(unit.m_20183_().m_7918_(-10, -10, -10), unit.m_20183_().m_7918_(10, 10, 10));
                pfMobs.addAll(evt.level.m_45971_(PathfinderMob.class, TargetingConditions.m_148352_(), unit, aabb));
            }
            for (PathfinderMob pfMob : pfMobs) {
                LivingEntity target;
                if (!NonUnitServerEvents.shouldMobBeAggressive((Mob)pfMob)) continue;
                boolean hasAttackGoal = false;
                for (WrappedGoal wrappedGoal : pfMob.f_21346_.m_148105_()) {
                    if (!(wrappedGoal.m_26015_() instanceof NearestAttackableTargetGoal)) continue;
                    hasAttackGoal = true;
                }
                if (pfMob.m_5448_() != null || !hasAttackGoal || attackSuppressedNonUnits.contains(pfMob) || (target = MiscUtil.findClosestAttackableEntity((Mob)pfMob, 10.0f, (ServerLevel)evt.level)) == null) continue;
                pfMob.m_6710_(target);
            }
        }
    }

    private static boolean shouldMobBeAggressive(Mob mob) {
        return !(mob instanceof Vex) && !(mob instanceof PhantomSummon);
    }
}

