/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.unit.TargetResourcesSave;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;

public class TargetResourcesSaveData
extends SavedData {
    public final ArrayList<TargetResourcesSave> targetData = new ArrayList();

    private static TargetResourcesSaveData create() {
        return new TargetResourcesSaveData();
    }

    @Nonnull
    public static TargetResourcesSaveData getInstance(LevelAccessor level) {
        MinecraftServer server = level.m_7654_();
        if (server == null) {
            return TargetResourcesSaveData.create();
        }
        return (TargetResourcesSaveData)server.m_129783_().m_8895_().m_164861_(TargetResourcesSaveData::load, TargetResourcesSaveData::create, "saved-target-resources-data");
    }

    public static TargetResourcesSaveData load(CompoundTag tag) {
        ReignOfNether.LOGGER.info("TargetResourcesSaveData.load");
        TargetResourcesSaveData data = TargetResourcesSaveData.create();
        ListTag ltag = (ListTag)tag.m_128423_("targetResourcesData");
        if (ltag != null) {
            for (Tag ctag : ltag) {
                CompoundTag tdTag = (CompoundTag)ctag;
                String unitUUID = tdTag.m_128461_("uuid");
                BlockPos gatherTarget = null;
                if (tdTag.m_128441_("gatherTargetX") && tdTag.m_128441_("gatherTargetY") && tdTag.m_128441_("gatherTargetZ")) {
                    gatherTarget = new BlockPos(tdTag.m_128451_("gatherTargetX"), tdTag.m_128451_("gatherTargetY"), tdTag.m_128451_("gatherTargetZ"));
                }
                ResourceName resourceName = ResourceName.valueOf(tdTag.m_128461_("targetResourceName"));
                BuildingPlacement targetFarm = null;
                if (tdTag.m_128441_("farmX") && tdTag.m_128441_("farmY") && tdTag.m_128441_("farmZ")) {
                    BlockPos farmPos = new BlockPos(tdTag.m_128451_("farmX"), tdTag.m_128451_("farmY"), tdTag.m_128451_("farmZ"));
                    targetFarm = BuildingUtils.findBuilding(false, farmPos);
                }
                TargetResourcesSave resData = new TargetResourcesSave();
                resData.unitUUID = unitUUID;
                resData.gatherTarget = gatherTarget;
                resData.targetResourceName = resourceName;
                resData.targetFarm = targetFarm;
                data.targetData.add(resData);
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.targetData.forEach(td -> {
            CompoundTag cTag = new CompoundTag();
            cTag.m_128359_("uuid", td.unitUUID);
            if (td.gatherTarget != null) {
                cTag.m_128405_("gatherTargetX", td.gatherTarget.m_123341_());
                cTag.m_128405_("gatherTargetY", td.gatherTarget.m_123342_());
                cTag.m_128405_("gatherTargetZ", td.gatherTarget.m_123343_());
            }
            cTag.m_128359_("targetResourceName", td.targetResourceName.toString());
            if (td.targetFarm != null) {
                cTag.m_128405_("farmX", td.targetFarm.originPos.m_123341_());
                cTag.m_128405_("farmY", td.targetFarm.originPos.m_123342_());
                cTag.m_128405_("farmZ", td.targetFarm.originPos.m_123343_());
            }
            list.add((Object)cTag);
        });
        tag.m_128365_("targetResourcesData", (Tag)list);
        return tag;
    }

    public void save() {
        this.m_77762_();
    }
}

