/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.goals;

import com.solegendary.reignofnether.alliance.AlliancesClient;
import com.solegendary.reignofnether.alliance.AlliancesServerEvents;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.GarrisonableBuilding;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;

public class GarrisonGoal
extends MoveToTargetBlockGoal {
    private BuildingPlacement buildingTarget;

    public GarrisonGoal(Mob mob) {
        super(mob, true, 0);
    }

    public void m_8037_() {
        GarrisonableBuilding garr;
        BuildingPlacement buildingPlacement = this.buildingTarget;
        if (buildingPlacement instanceof GarrisonableBuilding && (garr = (GarrisonableBuilding)((Object)buildingPlacement)).getCapacity() > 0) {
            this.calcMoveTarget();
            if (this.buildingTarget.getBlocksPlaced() <= 0) {
                this.stopGarrisoning();
            }
            if (this.moveTarget != null) {
                Vec3 vec3 = new Vec3((double)((float)this.moveTarget.m_123341_() + 0.5f), (double)((float)this.moveTarget.m_123342_() + 0.5f), (double)((float)this.moveTarget.m_123343_() + 0.5f));
                if (this.mob.m_20238_(vec3) <= 3.0) {
                    if (!garr.isFull() && this.buildingTarget.isBuilt && garr.getEntryPosition() != null) {
                        BlockPos bp = garr.getEntryPosition();
                        this.mob.m_6021_((double)((float)bp.m_123341_() + 0.5f), (double)((float)bp.m_123342_() + 0.5f), (double)((float)bp.m_123343_() + 0.5f));
                    }
                    this.stopGarrisoning();
                }
            }
        } else {
            this.moveTarget = null;
        }
    }

    private void calcMoveTarget() {
        GarrisonableBuilding garr;
        BuildingPlacement buildingPlacement = this.buildingTarget;
        if (buildingPlacement instanceof GarrisonableBuilding && (garr = (GarrisonableBuilding)((Object)buildingPlacement)).getCapacity() > 0) {
            this.moveTarget = this.buildingTarget.getClosestGroundPos(this.mob.m_20097_(), 1);
        }
    }

    public void setBuildingTarget(BlockPos blockPos) {
        if (blockPos != null) {
            GarrisonableBuilding garr;
            boolean clientside = this.mob.m_9236_().m_5776_();
            BuildingPlacement building = BuildingUtils.findBuilding(clientside, blockPos);
            if (building == null) {
                return;
            }
            boolean isAllied = clientside ? AlliancesClient.isAllied(building.ownerName, ((Unit)this.mob).getOwnerName()) : AlliancesServerEvents.isAllied(building.ownerName, ((Unit)this.mob).getOwnerName());
            if (!(building instanceof GarrisonableBuilding) || (garr = (GarrisonableBuilding)((Object)building)).getCapacity() <= 0 || !building.ownerName.equals(((Unit)this.mob).getOwnerName()) && !isAllied) {
                if (clientside) {
                    HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.reignofnether.not_garrisonable", (Object[])new Object[0]));
                }
            } else if (garr.isFull()) {
                if (clientside) {
                    HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"hud.reignofnether.building_full", (Object[])new Object[0]));
                }
            } else {
                if (clientside) {
                    MiscUtil.addUnitCheckpoint((Unit)this.mob, new BlockPos(building.centrePos.m_123341_(), building.originPos.m_123342_() + 1, building.centrePos.m_123343_()), true);
                }
                this.buildingTarget = building;
                this.calcMoveTarget();
                this.m_8056_();
            }
        }
    }

    public BuildingPlacement getBuildingTarget() {
        return this.buildingTarget;
    }

    public void stopGarrisoning() {
        this.buildingTarget = null;
        super.stopMoving();
    }
}

