/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.modelling.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.solegendary.reignofnether.unit.modelling.animations.WildfireAnimations;
import com.solegendary.reignofnether.unit.modelling.models.KeyframeHierarchicalModel;
import com.solegendary.reignofnether.unit.units.piglins.WildfireUnit;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class WildfireModel<T extends Entity>
extends KeyframeHierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"wildfire_layer"), "main");
    private final ModelPart main;
    private final ModelPart head;
    private final ModelPart bodySegment1;
    private final ModelPart bodySegment2;
    private final ModelPart bodySegment3;
    private final ModelPart bodyParts;
    private final ModelPart upperBodyParts0;
    private final ModelPart upperBodyParts1;
    private final ModelPart upperBodyParts2;
    private final ModelPart netherPiece0;
    private final ModelPart netherPiece1;
    private final ModelPart netherPiece2;
    private final ModelPart shields;
    private final ModelPart shield1;
    private final ModelPart shield2;
    private final ModelPart shield3;
    private final ModelPart shield4;
    private float partialTick = 0.0f;

    public WildfireModel(ModelPart root) {
        this.main = root.m_171324_("main");
        this.head = this.main.m_171324_("head");
        this.bodySegment1 = this.main.m_171324_("bodySegment1");
        this.bodySegment2 = this.bodySegment1.m_171324_("bodySegment2");
        this.bodySegment3 = this.bodySegment2.m_171324_("bodySegment3");
        this.bodyParts = this.main.m_171324_("bodyParts");
        this.upperBodyParts0 = this.bodyParts.m_171324_("upperBodyParts0");
        this.upperBodyParts1 = this.bodyParts.m_171324_("upperBodyParts1");
        this.upperBodyParts2 = this.bodyParts.m_171324_("upperBodyParts2");
        this.netherPiece0 = this.bodyParts.m_171324_("netherPiece0");
        this.netherPiece1 = this.bodyParts.m_171324_("netherPiece1");
        this.netherPiece2 = this.bodyParts.m_171324_("netherPiece2");
        this.shields = this.main.m_171324_("shields");
        this.shield1 = this.shields.m_171324_("shield1");
        this.shield2 = this.shields.m_171324_("shield2");
        this.shield3 = this.shields.m_171324_("shield3");
        this.shield4 = this.shields.m_171324_("shield4");
    }

    public ModelPart m_142109_() {
        return this.main;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition main = partdefinition.m_171599_("main", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = main.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(46, 46).m_171488_(-6.0f, -10.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(86, 51).m_171488_(-9.0f, -12.0f, -7.0f, 16.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(124, 44).m_171488_(-3.0f, -6.0f, -7.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(116, 59).m_171488_(-5.0f, -15.0f, -7.0f, 8.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(94, 80).m_171488_(-2.0f, -12.0f, -5.0f, 2.0f, 2.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(122, 77).m_171488_(-2.0f, -10.0f, 5.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(106, 113).m_171488_(0.0f, -12.0f, -1.0f, 8.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(114, 94).m_171488_(-10.0f, -12.0f, -1.0f, 8.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(56, 117).m_171488_(5.0f, -20.0f, -1.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 119).m_171488_(-10.0f, -17.0f, -1.0f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(76, 125).m_171488_(-10.0f, -19.0f, -1.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(122, 88).m_171488_(2.0f, -20.0f, -1.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-48.0f, (float)-2.0f));
        PartDefinition bodySegment1 = main.m_171599_("bodySegment1", CubeListBuilder.m_171558_().m_171514_(94, 59).m_171488_(-3.0f, 0.0f, -3.0f, 6.0f, 16.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)-47.0f, (float)-1.0f));
        PartDefinition bodySegment2 = bodySegment1.m_171599_("bodySegment2", CubeListBuilder.m_171558_().m_171514_(90, 113).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition bodySegment3 = bodySegment2.m_171599_("bodySegment3", CubeListBuilder.m_171558_().m_171514_(18, 92).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition bodyParts = main.m_171599_("bodyParts", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)-34.3333f, (float)-2.0f));
        PartDefinition upperBodyParts0 = bodyParts.m_171599_("upperBodyParts0", CubeListBuilder.m_171558_().m_171514_(24, 124).m_171488_(0.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)9.0f, (float)-11.6667f, (float)-1.0f));
        PartDefinition upperBodyParts1 = bodyParts.m_171599_("upperBodyParts1", CubeListBuilder.m_171558_().m_171514_(32, 124).m_171488_(0.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)3.3333f, (float)7.0f));
        PartDefinition upperBodyParts2 = bodyParts.m_171599_("upperBodyParts2", CubeListBuilder.m_171558_().m_171514_(124, 34).m_171488_(0.0f, -1.0f, 0.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-3.6667f, (float)-6.0f));
        PartDefinition netherPiece0 = bodyParts.m_171599_("netherPiece0", CubeListBuilder.m_171558_().m_171514_(78, 11).m_171488_(-2.0f, -6.0f, -1.0f, 3.0f, 6.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(93, 17).m_171488_(-3.0f, -4.0f, 2.0f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-9.0f, (float)-1.6667f, (float)2.0f));
        PartDefinition netherPiece1 = bodyParts.m_171599_("netherPiece1", CubeListBuilder.m_171558_().m_171514_(83, 20).m_171488_(-2.0f, -2.0f, -1.0f, 4.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(88, 13).m_171488_(-2.0f, -4.0f, 0.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(76, 6).m_171488_(-1.0f, 0.0f, 0.0f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)6.0f, (float)4.3333f, (float)6.0f));
        PartDefinition netherPiece2 = bodyParts.m_171599_("netherPiece2", CubeListBuilder.m_171558_().m_171514_(122, 51).m_171488_(-3.0f, -4.0f, -1.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(89, 17).m_171488_(-2.0f, -6.0f, 0.0f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)9.3333f, (float)-8.0f));
        PartDefinition shields = main.m_171599_("shields", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.4983f, (float)-21.4462f, (float)-0.875f));
        PartDefinition shield1 = shields.m_171599_("shield1", CubeListBuilder.m_171558_().m_171514_(183, 2).m_171488_(-11.65f, -23.7f, -0.75f, 24.0f, 40.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(190, 2).m_171488_(-8.65f, -29.7f, -0.75f, 6.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(197, 2).m_171488_(2.35f, -31.7f, -1.75f, 3.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(196, 46).m_171488_(-6.65f, 16.3f, -0.75f, 3.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(197, 46).m_171488_(-10.65f, 16.3f, -0.75f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 48).m_171488_(-1.65f, 16.3f, -0.75f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 48).m_171488_(6.35f, 16.3f, -0.75f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 48).m_171488_(11.35f, 16.3f, -0.75f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(196, 2).m_171488_(7.35f, -27.7f, -0.75f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.8517f, (float)0.1462f, (float)-28.375f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition shield2 = shields.m_171599_("shield2", CubeListBuilder.m_171558_().m_171514_(183, 2).m_171488_(-13.15f, -23.7f, -0.75f, 24.0f, 40.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(185, 3).m_171488_(-12.15f, -23.7f, -1.75f, 22.0f, 40.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(192, 2).m_171488_(-10.65f, -27.7f, -0.75f, 6.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(197, 2).m_171488_(-4.65f, -30.7f, -1.75f, 5.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(197, 46).m_171488_(-8.65f, 16.3f, -0.75f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(199, 46).m_171488_(-10.65f, 16.3f, -0.75f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 48).m_171488_(-0.65f, 16.3f, -0.75f, 5.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 48).m_171488_(6.35f, 16.3f, -0.75f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 48).m_171488_(4.35f, 16.3f, -0.75f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(196, 2).m_171488_(3.35f, -27.7f, -0.75f, 5.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(196, 2).m_171488_(0.35f, -27.7f, -0.75f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(198, 2).m_171488_(2.35f, -34.7f, -0.75f, 1.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)24.7483f, (float)0.1462f, (float)-1.475f, (float)0.0f, (float)-1.5708f, (float)-0.0436f));
        PartDefinition shield3 = shields.m_171599_("shield3", CubeListBuilder.m_171558_().m_171514_(184, 2).m_171488_(-12.65f, -23.7f, -0.75f, 24.0f, 40.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(186, 3).m_171488_(-11.65f, -23.7f, -1.75f, 22.0f, 40.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(192, 2).m_171488_(-11.15f, -25.7f, -0.75f, 14.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(192, 2).m_171488_(3.85f, -27.7f, -0.75f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(192, 2).m_171488_(7.85f, -25.7f, -0.75f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(191, 2).m_171488_(-12.15f, -24.7f, -0.75f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(191, 2).m_171488_(2.85f, -29.7f, -0.75f, 1.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(199, 47).m_171488_(-3.65f, 16.3f, -0.75f, 6.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 48).m_171488_(2.35f, 16.3f, -0.75f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 48).m_171488_(-6.65f, 16.3f, -0.75f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 48).m_171488_(5.35f, 16.3f, -0.75f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 48).m_171488_(-8.65f, 16.3f, -0.75f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.2517f, (float)0.1462f, (float)30.525f, (float)3.098f, (float)0.0f, (float)3.1416f));
        PartDefinition shield4 = shields.m_171599_("shield4", CubeListBuilder.m_171558_().m_171514_(183, 2).m_171488_(-13.65f, -23.7f, -0.75f, 24.0f, 40.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(187, 3).m_171488_(-12.65f, -23.7f, -1.75f, 22.0f, 40.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(197, 46).m_171488_(-9.65f, 16.3f, -0.75f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(197, 46).m_171488_(-13.65f, 16.3f, -0.75f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(196, 48).m_171488_(-5.65f, 16.3f, -0.75f, 9.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 48).m_171488_(5.35f, 16.3f, -0.75f, 4.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 48).m_171488_(3.35f, 16.3f, -0.75f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(191, 2).m_171488_(-4.65f, -26.7f, -0.75f, 11.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(194, 2).m_171488_(-13.65f, -25.7f, -0.75f, 9.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(200, 2).m_171488_(6.35f, -28.7f, -0.75f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-23.2517f, (float)0.1462f, (float)-1.475f, (float)0.0f, (float)1.5708f, (float)0.0436f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void m_6839_(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        this.partialTick = partialTicks;
    }

    private void desyncShieldRotations(WildfireUnit wildfire) {
        float bodyYaw = Mth.m_14179_((float)this.partialTick, (float)wildfire.f_19859_, (float)wildfire.m_146908_());
        this.shields.f_104204_ = -bodyYaw * ((float)Math.PI / 180);
    }

    public void m_6973_(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        AttributeInstance ms;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        WildfireUnit wildfire = (WildfireUnit)entity;
        if (wildfire.animateScale > 0.0f && wildfire.animateScaleReducing) {
            wildfire.animateScale -= 0.02f;
        }
        if (wildfire.animateScale <= 0.0f) {
            wildfire.animateScale = 1.0f;
            wildfire.activeAnimDef = null;
            wildfire.activeAnimState = null;
            wildfire.animateScaleReducing = false;
            wildfire.stopAllAnimations();
        }
        if ((ms = wildfire.m_21051_(Attributes.f_22279_)) == null) {
            return;
        }
        float speed = (float)ms.m_22135_() * 10.0f;
        if (wildfire.activeAnimDef != null && wildfire.activeAnimState != null && wildfire.animateTicks > 0) {
            this.restartThenAnimate(wildfire, wildfire.activeAnimState, wildfire.activeAnimDef, ageInTicks, wildfire.animateScale);
        } else {
            if (wildfire.m_5448_() == null) {
                this.desyncShieldRotations(wildfire);
            }
            if (!entity.m_20072_() && limbSwingAmount > 0.001f) {
                this.restart(wildfire, wildfire.walkAnimState, WildfireAnimations.WALK, ageInTicks);
                this.m_267799_(WildfireAnimations.WALK, limbSwing, limbSwingAmount, speed, speed);
            } else {
                this.restartThenAnimate(wildfire, wildfire.idleAnimState, WildfireAnimations.IDLE, ageInTicks);
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.main.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

