/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.monsters;

import com.solegendary.reignofnether.ability.Abilities;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.ability.heroAbilities.shared.PlaceholderUntargetedAbility;
import com.solegendary.reignofnether.hero.HeroClientboundPacket;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.time.NightUtils;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.GenericTargetedSpellGoal;
import com.solegendary.reignofnether.unit.goals.GenericUntargetedSpellGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeWindupAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeWindupAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.MountGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.KeyframeAnimated;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.modelling.animations.WretchedWraithAnimations;
import com.solegendary.reignofnether.util.Faction;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WretchedWraithUnit
extends Zombie
implements Unit,
AttackerUnit,
HeroUnit,
KeyframeAnimated {
    public static final Abilities ABILITIES = new Abilities();
    Object2ObjectArrayMap<Ability, Float> cooldowns = Unit.createCooldownMap();
    Object2ObjectArrayMap<Ability, Integer> charges = new Object2ObjectArrayMap();
    Object2ObjectArrayMap<HeroAbility, Integer> heroAbilityRanks = new Object2ObjectArrayMap();
    Ability autocast;
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    public MountGoal mountGoal;
    private GenericUntargetedSpellGoal castIceNovaGoal;
    private GenericTargetedSpellGoal castFrostblinkGoal;
    private GenericUntargetedSpellGoal castBlizzardGoal;
    private BlockPos attackMoveTarget = null;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    public static final EntityDataAccessor<String> ownerDataAccessor;
    private int skillPoints = 1;
    private int experience = 0;
    private boolean rankUpMenuOpen = false;
    private float baseMaxMana;
    private float maxMana;
    private float mana = this.maxMana = (this.baseMaxMana = 120.0f);
    private float manaRegenPerSecond = 1.0f;
    private float manaBonusPerLevel = 10.0f;
    public static final float attackDamage = 6.0f;
    public static final float attackBonusPerLevel = 0.4f;
    public static final float attacksPerSecond = 0.4f;
    public static final float maxHealth = 140.0f;
    public static final float maxHealthBonusPerLevel = 12.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.28f;
    public static final float attackRange = 3.0f;
    public static final float aggroRange = 10.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public int maxResources = 100;
    public int fogRevealDuration = 0;
    private AbstractMeleeAttackUnitGoal attackGoal;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private Abilities abilities = ABILITIES.clone();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    public final AnimationState idleAnimState = new AnimationState();
    public final AnimationState walkAnimState = new AnimationState();
    public final AnimationState spellChargeAnimState = new AnimationState();
    public final AnimationState spellActivateAnimState = new AnimationState();
    public final AnimationState attackAnimState = new AnimationState();
    private static final int ATTACK_WINDUP_TICKS = 12;
    public AnimationDefinition activeAnimDef = null;
    public AnimationState activeAnimState = null;
    public int animateTicks = 0;
    public float animateScale = 1.0f;
    public boolean animateScaleReducing = false;

    @Override
    public Object2ObjectArrayMap<HeroAbility, Integer> getHeroAbilityRanks() {
        return this.heroAbilityRanks;
    }

    @Override
    public void updateAbilityButtons() {
        this.abilities = ABILITIES.clone();
    }

    @Override
    public Object2ObjectArrayMap<Ability, Float> getCooldowns() {
        return this.cooldowns;
    }

    @Override
    public boolean hasAutocast(Ability ability) {
        return this.autocast == ability;
    }

    @Override
    public void setAutocast(Ability autocast) {
        this.autocast = autocast;
    }

    @Override
    public Object2ObjectArrayMap<Ability, Integer> getCharges() {
        return this.charges;
    }

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.MONSTERS;
    }

    @Override
    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    public MountGoal getMountGoal() {
        return this.mountGoal;
    }

    public GenericUntargetedSpellGoal getCastIceNovaGoal() {
        return this.castIceNovaGoal;
    }

    public GenericTargetedSpellGoal getCastFrostblinkGoal() {
        return this.castFrostblinkGoal;
    }

    public GenericUntargetedSpellGoal getCastBlizzardGoal() {
        return this.castBlizzardGoal;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 50;
    }

    @Override
    public float getAttacksPerSecond() {
        return 0.4f;
    }

    @Override
    public float getAggroRange() {
        return 10.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 3.0f;
    }

    @Override
    public float getMovementSpeed() {
        return 0.28f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 6.0f + 0.4f * (float)this.getHeroLevel();
    }

    @Override
    public float getUnitMaxHealth() {
        return 140.0f + 12.0f * (float)this.getHeroLevel();
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.WRETCHED_WRAITH;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public int getSkillPoints() {
        return this.skillPoints;
    }

    @Override
    public void setSkillPoints(int points) {
        this.skillPoints = points;
    }

    @Override
    public boolean isRankUpMenuOpen() {
        return this.rankUpMenuOpen;
    }

    @Override
    public void showRankUpMenu(boolean show) {
        this.rankUpMenuOpen = show;
    }

    @Override
    public int getExperience() {
        return this.experience;
    }

    @Override
    public void setExperience(int amount) {
        this.experience = amount;
        this.setStatsForLevel();
    }

    @Override
    public float getBaseMaxMana() {
        return this.baseMaxMana;
    }

    @Override
    public float getMaxMana() {
        return this.maxMana;
    }

    @Override
    public void setMaxMana(float amount) {
        this.maxMana = amount;
        if (!this.m_9236_().m_5776_()) {
            HeroClientboundPacket.setMaxMana(this.m_19879_(), amount);
        }
    }

    @Override
    public float getMana() {
        return this.mana;
    }

    @Override
    public void setMana(float amount) {
        this.mana = Math.min(this.maxMana, amount);
        if (!this.m_9236_().m_5776_()) {
            HeroClientboundPacket.setMana(this.m_19879_(), this.mana);
        }
    }

    @Override
    public float getManaRegenPerSecond() {
        return this.manaRegenPerSecond;
    }

    @Override
    public float getManaBonusPerLevel() {
        return this.manaBonusPerLevel;
    }

    @Override
    public float getHealthBonusPerLevel() {
        return 12.0f;
    }

    @Override
    public float getAttackBonusPerLevel() {
        return 0.4f;
    }

    @Override
    public float getBaseHealth() {
        return 140.0f;
    }

    @Override
    public float getBaseAttack() {
        return 6.0f;
    }

    public int getFogRevealDuration() {
        return this.fogRevealDuration;
    }

    public void setFogRevealDuration(int duration) {
        this.fogRevealDuration = duration;
    }

    @Override
    public void stopAllAnimations() {
        this.idleAnimState.m_216973_();
        this.walkAnimState.m_216973_();
        this.spellChargeAnimState.m_216973_();
        this.spellActivateAnimState.m_216973_();
        this.attackAnimState.m_216973_();
    }

    @Override
    public void setAnimateTicksLeft(int ticks) {
        this.animateTicks = ticks;
    }

    @Override
    public int getAnimateTicksLeft() {
        return this.animateTicks;
    }

    @Override
    public void playSingleAnimation(UnitAnimationAction animAction) {
        this.animateScaleReducing = false;
        switch (animAction) {
            case ATTACK_UNIT: 
            case ATTACK_BUILDING: {
                this.activeAnimDef = WretchedWraithAnimations.ATTACK;
                this.activeAnimState = this.attackAnimState;
                this.animateScale = 1.0f;
                this.startAnimation(this.activeAnimDef);
                break;
            }
            case TELEPORT: {
                this.activeAnimDef = WretchedWraithAnimations.TELEPORT;
                this.activeAnimState = this.spellChargeAnimState;
                this.animateScale = 1.0f;
                this.startAnimation(this.activeAnimDef);
                break;
            }
            case ULTIMATE: {
                this.activeAnimDef = WretchedWraithAnimations.ULTIMATE;
                this.activeAnimState = this.spellActivateAnimState;
                this.animateScale = 1.0f;
                this.startAnimation(this.activeAnimDef);
                break;
            }
            default: {
                this.animateScaleReducing = true;
            }
        }
    }

    public WretchedWraithUnit(EntityType<? extends Zombie> entityType, Level level) {
        super(entityType, level);
        this.updateAbilityButtons();
        this.setStatsForLevel();
    }

    public float m_6515_(DamageSource pSource, float pDamage) {
        pDamage = super.m_6515_(pSource, pDamage);
        if (pSource.m_269533_(DamageTypeTags.f_268731_)) {
            pDamage *= 0.7f;
        }
        return pDamage;
    }

    @Override
    public void resetBehaviours() {
        this.animateScaleReducing = true;
        this.castIceNovaGoal.m_8041_();
        this.castFrostblinkGoal.m_8041_();
        this.castBlizzardGoal.m_8041_();
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22276_, 140.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22287_, 0.0);
    }

    public void m_8119_() {
        this.m_21553_(true);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
        HeroUnit.tick(this);
        if (this.m_9236_().m_5776_() && this.animateTicks > 0) {
            --this.animateTicks;
        }
        this.castIceNovaGoal.m_8037_();
        this.castFrostblinkGoal.m_8037_();
        this.castBlizzardGoal.m_8037_();
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    protected boolean m_21527_() {
        return NightUtils.isSunBurnTick((Mob)this);
    }

    @Override
    public Unit.SunlightEffect getSunlightEffect() {
        return Unit.SunlightEffect.SLOWNESS_I;
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, false);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new MeleeWindupAttackUnitGoal((Mob)this, false, 12);
        this.attackBuildingGoal = new MeleeWindupAttackBuildingGoal((Mob)this, 12);
        this.returnResourcesGoal = new ReturnResourcesGoal((Mob)this);
        this.castIceNovaGoal = new GenericUntargetedSpellGoal((LivingEntity)this, 0, this::iceNova, UnitAnimationAction.CHARGE_SPELL, UnitAnimationAction.STOP, UnitAnimationAction.CAST_SPELL);
        this.castFrostblinkGoal = new GenericTargetedSpellGoal((Mob)this, 0, 12.0f, UnitAnimationAction.CAST_SPELL, null, this::frostBlink, null);
        this.castBlizzardGoal = new GenericUntargetedSpellGoal((LivingEntity)this, 200, this::blizzard, UnitAnimationAction.ULTIMATE, UnitAnimationAction.STOP, UnitAnimationAction.STOP);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.returnResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
    }

    public void iceNova() {
    }

    public void frostBlink(BlockPos bp) {
    }

    public void blizzard() {
    }

    static {
        ABILITIES.add(new PlaceholderUntargetedAbility());
        ownerDataAccessor = SynchedEntityData.m_135353_(WretchedWraithUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    }
}

