/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.monsters;

import com.solegendary.reignofnether.building.buildings.placements.ProductionPlacement;
import com.solegendary.reignofnether.building.production.ProductionItem;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.building.production.StartProductionButton;
import com.solegendary.reignofnether.building.production.StopProductionButton;
import com.solegendary.reignofnether.hud.buttons.UnitSpawnButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.registrars.EntityRegistrar;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.EntityType;

public class ZombieProd
extends ProductionItem {
    public static final String itemName = "Zombie";
    public static final ResourceCost cost = ResourceCosts.ZOMBIE;

    public ZombieProd() {
        super(cost);
        this.onComplete = (level, building) -> {
            if (!level.m_5776_()) {
                if (ResearchServerEvents.playerHasResearch(building.ownerName, ProductionItems.RESEARCH_HUSKS)) {
                    building.produceUnit((ServerLevel)level, (EntityType<? extends Unit>)((EntityType)EntityRegistrar.HUSK_UNIT.get()), building.ownerName, true);
                } else if (ResearchServerEvents.playerHasResearch(building.ownerName, ProductionItems.RESEARCH_DROWNED)) {
                    building.produceUnit((ServerLevel)level, (EntityType<? extends Unit>)((EntityType)EntityRegistrar.DROWNED_UNIT.get()), building.ownerName, true);
                } else {
                    building.produceUnit((ServerLevel)level, (EntityType<? extends Unit>)((EntityType)EntityRegistrar.ZOMBIE_UNIT.get()), building.ownerName, true);
                }
            }
        };
    }

    @Override
    public String getItemName() {
        return itemName;
    }

    private static ResourceLocation getIcon() {
        if (ResearchClient.hasResearch(ProductionItems.RESEARCH_HUSKS)) {
            return ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/husk.png");
        }
        if (ResearchClient.hasResearch(ProductionItems.RESEARCH_DROWNED)) {
            return ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/drowned.png");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/zombie.png");
    }

    private static String getCancelName() {
        if (ResearchClient.hasResearch(ProductionItems.RESEARCH_HUSKS)) {
            return "Husk";
        }
        if (ResearchClient.hasResearch(ProductionItems.RESEARCH_DROWNED)) {
            return "Drowned";
        }
        return itemName;
    }

    public UnitSpawnButton getPlaceButton() {
        return new UnitSpawnButton(itemName, ResourceLocation.fromNamespaceAndPath((String)"reignofnether", (String)"textures/mobheads/zombie.png"), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.zombie", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.zombie.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.zombie.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)));
    }

    @Override
    public StartProductionButton getStartButton(ProductionPlacement prodBuilding, Keybinding hotkey) {
        return new StartProductionButton(itemName, ZombieProd.getIcon(), hotkey, () -> ResearchClient.hasResearch(ProductionItems.RESEARCH_HUSKS) || ResearchClient.hasResearch(ProductionItems.RESEARCH_DROWNED), () -> true, List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.zombie", (Object[])new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))), ResourceCosts.getFormattedCost(cost), ResourceCosts.getFormattedPopAndTime(cost), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.zombie.tooltip1", (Object[])new Object[0]), (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)"", (Style)Style.f_131099_), FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"units.monsters.reignofnether.zombie.tooltip2", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    @Override
    public StopProductionButton getCancelButton(ProductionPlacement prodBuilding, boolean first) {
        return new StopProductionButton(ZombieProd.getCancelName(), ZombieProd.getIcon(), prodBuilding, this, first);
    }
}

