/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.piglins;

import com.solegendary.reignofnether.ability.Abilities;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.abilities.Bloodlust;
import com.solegendary.reignofnether.ability.abilities.ToggleShield;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingUtils;
import com.solegendary.reignofnether.building.buildings.piglins.BasaltSprings;
import com.solegendary.reignofnether.building.buildings.piglins.FlameSanctuary;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.keybinds.Keybindings;
import com.solegendary.reignofnether.research.ResearchServerEvents;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.RandomLookAroundUnitGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.packets.UnitAnimationClientboundPacket;
import com.solegendary.reignofnether.util.Faction;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BruteUnit
extends PiglinBrute
implements Unit,
AttackerUnit {
    public static final Abilities ABILITIES = new Abilities();
    Object2ObjectArrayMap<Ability, Float> cooldowns = Unit.createCooldownMap();
    Object2ObjectArrayMap<Ability, Integer> charges = new Object2ObjectArrayMap();
    Ability autocast;
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    GarrisonGoal garrisonGoal;
    UsePortalGoal usePortalGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    private AbstractMeleeAttackUnitGoal attackGoal;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    private BlockPos attackMoveTarget = null;
    public static final EntityDataAccessor<String> ownerDataAccessor;
    public static final float attackDamage = 5.0f;
    public static final float attacksPerSecond = 0.5f;
    public static final float attackRange = 2.0f;
    public static final float aggroRange = 10.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public static final float maxHealth = 55.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.28f;
    public static final float rangedDamageResist = 0.2f;
    public int maxResources = 100;
    public int bloodlustTicks = 0;
    public boolean isHoldingUpShield = false;
    private Abilities abilities = ABILITIES.clone();
    private final List<ItemStack> items = new ArrayList<ItemStack>();

    @Override
    public void updateAbilityButtons() {
        this.abilities = ABILITIES.clone();
    }

    @Override
    public Object2ObjectArrayMap<Ability, Float> getCooldowns() {
        return this.cooldowns;
    }

    @Override
    public boolean hasAutocast(Ability ability) {
        return this.autocast == ability;
    }

    @Override
    public void setAutocast(Ability autocast) {
        this.autocast = autocast;
    }

    @Override
    public Object2ObjectArrayMap<Ability, Integer> getCharges() {
        return this.charges;
    }

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return this.garrisonGoal;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    @Override
    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public float getMovementSpeed() {
        return this.isHoldingUpShield ? 0.14f : 0.28f;
    }

    @Override
    public float getUnitMaxHealth() {
        return 55.0f;
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.BRUTE;
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public float getAttacksPerSecond() {
        if (this.bloodlustTicks > 0) {
            return 0.8f;
        }
        return 0.5f;
    }

    @Override
    public float getAggroRange() {
        return 10.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 2.0f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 5.0f;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public int getAttackCooldown() {
        if (this.bloodlustTicks > 0) {
            return 25;
        }
        return 40;
    }

    public BruteUnit(EntityType<? extends PiglinBrute> entityType, Level level) {
        super(entityType, level);
        this.updateAbilityButtons();
    }

    @Override
    public float getUnitRangedArmorPercentage() {
        if (this.isHoldingUpShield) {
            return 0.8f;
        }
        return 0.2f;
    }

    public void toggleShield() {
        if (this.m_6844_(EquipmentSlot.OFFHAND).m_41720_() != Items.f_42740_) {
            return;
        }
        boolean bl = this.isHoldingUpShield = !this.isHoldingUpShield;
        if (!this.m_9236_().m_5776_()) {
            if (this.isHoldingUpShield) {
                UnitAnimationClientboundPacket.sendBasicPacket(UnitAnimationAction.NON_KEYFRAME_START, (LivingEntity)this);
            } else {
                UnitAnimationClientboundPacket.sendBasicPacket(UnitAnimationAction.NON_KEYFRAME_STOP, (LivingEntity)this);
            }
            BlockPos bp = this.getMoveGoal().getMoveTarget();
            this.getMoveGoal().stopMoving();
            this.getMoveGoal().setMoveTarget(bp);
        }
    }

    protected boolean m_6046_() {
        return false;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22276_, 55.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 0.0);
    }

    public boolean m_21526_() {
        return false;
    }

    protected void m_7581_(ItemEntity pItemEntity) {
    }

    public boolean m_34666_() {
        return false;
    }

    protected void m_8024_() {
    }

    public LivingEntity m_5448_() {
        return this.targetGoal.getTarget();
    }

    public void m_8119_() {
        this.m_21553_(true);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
        if (this.bloodlustTicks > 0) {
            --this.bloodlustTicks;
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.garrisonGoal = new GarrisonGoal((Mob)this);
        this.attackGoal = new MeleeAttackUnitGoal((Mob)this, false);
        this.attackBuildingGoal = new MeleeAttackBuildingGoal((Mob)this);
        this.returnResourcesGoal = new ReturnResourcesGoal((Mob)this);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.returnResourcesGoal);
        this.f_21345_.m_25352_(2, (Goal)this.garrisonGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
        this.f_21345_.m_25352_(4, (Goal)new RandomLookAroundUnitGoal((Mob)this));
    }

    @Override
    public void setupEquipmentAndUpgradesClient() {
    }

    @Override
    public void setupEquipmentAndUpgradesServer() {
        if (!this.hasEnchantedNetheriteSword()) {
            ItemStack swordStack = new ItemStack((ItemLike)Items.f_42430_);
            AttributeModifier mod = new AttributeModifier(UUID.randomUUID().toString(), 0.0, AttributeModifier.Operation.ADDITION);
            swordStack.m_41643_(Attributes.f_22281_, mod, EquipmentSlot.MAINHAND);
            this.m_8061_(EquipmentSlot.MAINHAND, swordStack);
        }
        if (ResearchServerEvents.playerHasResearch(this.getOwnerName(), ProductionItems.RESEARCH_BRUTE_SHIELDS)) {
            ItemStack shieldStack = new ItemStack((ItemLike)Items.f_42740_);
            this.m_8061_(EquipmentSlot.OFFHAND, shieldStack);
        }
    }

    public boolean m_5825_() {
        BuildingPlacement bpl = BuildingUtils.findBuilding(this.m_9236_().m_5776_(), this.m_20097_());
        return super.m_5825_() || bpl != null && (bpl.getBuilding() instanceof FlameSanctuary || bpl.getBuilding() instanceof BasaltSprings);
    }

    public boolean hasNetheriteChestplate() {
        ItemStack itemStack = this.m_6844_(EquipmentSlot.CHEST);
        return itemStack.m_41720_() == Items.f_42481_;
    }

    public boolean hasEnchantedNetheriteSword() {
        ItemStack itemStack = this.m_6844_(EquipmentSlot.MAINHAND);
        return itemStack.m_41720_() == Items.f_42393_ && itemStack.m_41793_();
    }

    @Override
    public boolean canPickUpEquipment(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        return (item == Items.f_42477_ || item == Items.f_42478_ || item == Items.f_42479_ || item == Items.f_42476_ || item == Items.f_42481_ || item == Items.f_42482_ || item == Items.f_42483_ || item == Items.f_42480_ || item == Items.f_42393_) && this.m_6844_(BruteUnit.m_147233_((ItemStack)itemStack)).m_41720_() != item;
    }

    @Override
    public void onPickupEquipment(ItemStack itemStack) {
        if (itemStack.m_41720_() == Items.f_42393_) {
            AttributeModifier mod = new AttributeModifier(UUID.randomUUID().toString(), 2.0, AttributeModifier.Operation.ADDITION);
            itemStack.m_41643_(Attributes.f_22281_, mod, EquipmentSlot.MAINHAND);
        }
        this.m_8061_(BruteUnit.m_147233_((ItemStack)itemStack), itemStack);
    }

    @Override
    public boolean hasBonusAttackSpeed() {
        return this.bloodlustTicks > 0;
    }

    @Override
    public boolean hasBonusDamage() {
        return this.hasEnchantedNetheriteSword();
    }

    static {
        ABILITIES.add(new ToggleShield(), Keybindings.keyQ);
        ABILITIES.add(new Bloodlust(), Keybindings.keyW);
        ownerDataAccessor = SynchedEntityData.m_135353_(BruteUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    }
}

