/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.unit.units.piglins;

import com.solegendary.reignofnether.ability.Abilities;
import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.ability.AbilityClientboundPacket;
import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.ability.heroAbilities.piglin.FancyFeast;
import com.solegendary.reignofnether.ability.heroAbilities.piglin.GreedIsGoodPassive;
import com.solegendary.reignofnether.ability.heroAbilities.piglin.LootExplosion;
import com.solegendary.reignofnether.ability.heroAbilities.piglin.ThrowTNT;
import com.solegendary.reignofnether.entities.ThrowableTntProjectile;
import com.solegendary.reignofnether.hero.HeroClientboundPacket;
import com.solegendary.reignofnether.registrars.ItemRegistrar;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.ResourceCosts;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.unit.Checkpoint;
import com.solegendary.reignofnether.unit.UnitAnimationAction;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.goals.AbstractMeleeAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.GarrisonGoal;
import com.solegendary.reignofnether.unit.goals.GenericTargetedSpellGoal;
import com.solegendary.reignofnether.unit.goals.GenericUntargetedSpellGoal;
import com.solegendary.reignofnether.unit.goals.MeleeAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeWindupAttackBuildingGoal;
import com.solegendary.reignofnether.unit.goals.MeleeWindupAttackUnitGoal;
import com.solegendary.reignofnether.unit.goals.MoveToTargetBlockGoal;
import com.solegendary.reignofnether.unit.goals.ReturnResourcesGoal;
import com.solegendary.reignofnether.unit.goals.SelectedTargetGoal;
import com.solegendary.reignofnether.unit.goals.UsePortalGoal;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.KeyframeAnimated;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.modelling.animations.PiglinMerchantAnimations;
import com.solegendary.reignofnether.unit.units.piglins.ArmouredHoglinUnit;
import com.solegendary.reignofnether.unit.units.piglins.BruteUnit;
import com.solegendary.reignofnether.unit.units.piglins.GhastUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterUnit;
import com.solegendary.reignofnether.unit.units.piglins.HoglinUnit;
import com.solegendary.reignofnether.unit.units.piglins.WitherSkeletonUnit;
import com.solegendary.reignofnether.util.Faction;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PiglinMerchantUnit
extends Piglin
implements Unit,
AttackerUnit,
HeroUnit,
KeyframeAnimated {
    public static final Abilities ABILITIES = new Abilities();
    Object2ObjectArrayMap<Ability, Float> cooldowns = Unit.createCooldownMap();
    Object2ObjectArrayMap<Ability, Integer> charges = new Object2ObjectArrayMap();
    Object2ObjectArrayMap<HeroAbility, Integer> heroAbilityRanks = new Object2ObjectArrayMap();
    Ability autocast;
    private int eatingTicksLeft = 0;
    private BlockPos anchorPos = new BlockPos(0, 0, 0);
    private final ArrayList<Checkpoint> checkpoints = new ArrayList();
    UsePortalGoal usePortalGoal;
    private GenericTargetedSpellGoal castFancyFeastGoal;
    private GenericTargetedSpellGoal castTNTGoal;
    private GenericUntargetedSpellGoal castLootExplosionGoal;
    private MoveToTargetBlockGoal moveGoal;
    private SelectedTargetGoal<? extends LivingEntity> targetGoal;
    private ReturnResourcesGoal returnResourcesGoal;
    private AbstractMeleeAttackUnitGoal attackGoal;
    private MeleeAttackBuildingGoal attackBuildingGoal;
    private LivingEntity followTarget = null;
    private boolean holdPosition = false;
    private BlockPos attackMoveTarget = null;
    public static final EntityDataAccessor<String> ownerDataAccessor;
    private int skillPoints = 1;
    private int experience = 0;
    private boolean rankUpMenuOpen = false;
    private float baseMaxMana;
    private float maxMana;
    private float mana = this.maxMana = (this.baseMaxMana = 125.0f);
    private float manaRegenPerSecond = 0.8f;
    private float manaBonusPerLevel = 8.0f;
    public static final float attackDamage = 8.0f;
    public static final float attackBonusPerLevel = 0.7f;
    public static final float attacksPerSecond = 0.35f;
    public static final float maxHealth = 150.0f;
    public static final float maxHealthBonusPerLevel = 10.0f;
    public static final float armorValue = 0.0f;
    public static final float movementSpeed = 0.28f;
    public static final float attackRange = 2.0f;
    public static final float aggroRange = 10.0f;
    public static final boolean willRetaliate = true;
    public static final boolean aggressiveWhenIdle = true;
    public int maxResources = 100;
    private Abilities abilities = ABILITIES.clone();
    private final List<ItemStack> items = new ArrayList<ItemStack>();
    public final AnimationState idleAnimState = new AnimationState();
    public final AnimationState walkAnimState = new AnimationState();
    public final AnimationState spellChargeAnimState = new AnimationState();
    public final AnimationState spellActivateAnimState = new AnimationState();
    public final AnimationState attackAnimState = new AnimationState();
    private static final int ATTACK_WINDUP_TICKS = 32;
    public AnimationDefinition activeAnimDef = null;
    public AnimationState activeAnimState = null;
    public int animateTicks = 0;
    public float animateScale = 1.0f;
    public boolean animateScaleReducing = false;

    @Override
    public Object2ObjectArrayMap<HeroAbility, Integer> getHeroAbilityRanks() {
        return this.heroAbilityRanks;
    }

    @Override
    public void updateAbilityButtons() {
        this.abilities = ABILITIES.clone();
    }

    @Override
    public Object2ObjectArrayMap<Ability, Float> getCooldowns() {
        return this.cooldowns;
    }

    @Override
    public boolean hasAutocast(Ability ability) {
        return this.autocast == ability;
    }

    @Override
    public void setAutocast(Ability autocast) {
        this.autocast = autocast;
    }

    @Override
    public Object2ObjectArrayMap<Ability, Integer> getCharges() {
        return this.charges;
    }

    @Override
    public void setEatingTicksLeft(int amount) {
        this.eatingTicksLeft = amount;
    }

    @Override
    public int getEatingTicksLeft() {
        return this.eatingTicksLeft;
    }

    @Override
    public void setAnchor(BlockPos bp) {
        this.anchorPos = bp;
    }

    @Override
    public BlockPos getAnchor() {
        return this.anchorPos;
    }

    @Override
    public ArrayList<Checkpoint> getCheckpoints() {
        return this.checkpoints;
    }

    @Override
    public GarrisonGoal getGarrisonGoal() {
        return null;
    }

    @Override
    public boolean canGarrison() {
        return this.getGarrisonGoal() != null;
    }

    @Override
    public UsePortalGoal getUsePortalGoal() {
        return this.usePortalGoal;
    }

    @Override
    public boolean canUsePortal() {
        return this.getUsePortalGoal() != null;
    }

    @Override
    public Faction getFaction() {
        return Faction.PIGLINS;
    }

    @Override
    public Abilities getAbilities() {
        return this.abilities;
    }

    @Override
    public List<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public MoveToTargetBlockGoal getMoveGoal() {
        return this.moveGoal;
    }

    public SelectedTargetGoal<? extends LivingEntity> getTargetGoal() {
        return this.targetGoal;
    }

    @Override
    public ReturnResourcesGoal getReturnResourcesGoal() {
        return this.returnResourcesGoal;
    }

    @Override
    public int getMaxResources() {
        return this.maxResources;
    }

    public GenericTargetedSpellGoal getCastFancyFeastGoal() {
        return this.castFancyFeastGoal;
    }

    public GenericTargetedSpellGoal getCastTNTGoal() {
        return this.castTNTGoal;
    }

    public GenericUntargetedSpellGoal getCastLootExplosionGoal() {
        return this.castLootExplosionGoal;
    }

    @Override
    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    @Override
    public boolean getHoldPosition() {
        return this.holdPosition;
    }

    @Override
    public void setHoldPosition(boolean holdPosition) {
        this.holdPosition = holdPosition;
    }

    @Override
    public String getOwnerName() {
        return (String)this.f_19804_.m_135370_(ownerDataAccessor);
    }

    @Override
    public void setOwnerName(String name) {
        this.f_19804_.m_135381_(ownerDataAccessor, (Object)name);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ownerDataAccessor, (Object)"");
    }

    @Override
    public float getMovementSpeed() {
        return 0.28f;
    }

    @Override
    public float getUnitAttackDamage() {
        return 8.0f + 0.7f * (float)this.getHeroLevel();
    }

    @Override
    public float getUnitMaxHealth() {
        return 150.0f + 10.0f * (float)this.getHeroLevel();
    }

    @Override
    @Nullable
    public ResourceCost getCost() {
        return ResourceCosts.PIGLIN_MERCHANT;
    }

    @Override
    public boolean getWillRetaliate() {
        return true;
    }

    @Override
    public int getAttackCooldown() {
        return 57;
    }

    @Override
    public float getAttacksPerSecond() {
        return 0.35f;
    }

    @Override
    public float getAggroRange() {
        return 10.0f;
    }

    @Override
    public boolean getAggressiveWhenIdle() {
        return !this.m_20160_();
    }

    @Override
    public float getAttackRange() {
        return 2.0f;
    }

    @Override
    public BlockPos getAttackMoveTarget() {
        return this.attackMoveTarget;
    }

    @Override
    public boolean canAttackBuildings() {
        return this.getAttackBuildingGoal() != null;
    }

    @Override
    public Goal getAttackGoal() {
        return this.attackGoal;
    }

    @Override
    public Goal getAttackBuildingGoal() {
        return this.attackBuildingGoal;
    }

    @Override
    public void setAttackMoveTarget(@Nullable BlockPos bp) {
        this.attackMoveTarget = bp;
    }

    @Override
    public void setFollowTarget(@Nullable LivingEntity target) {
        this.followTarget = target;
    }

    @Override
    public int getSkillPoints() {
        return this.skillPoints;
    }

    @Override
    public void setSkillPoints(int points) {
        this.skillPoints = points;
    }

    @Override
    public boolean isRankUpMenuOpen() {
        return this.rankUpMenuOpen;
    }

    @Override
    public void showRankUpMenu(boolean show) {
        this.rankUpMenuOpen = show;
    }

    @Override
    public int getExperience() {
        return this.experience;
    }

    @Override
    public void setExperience(int amount) {
        this.experience = amount;
        this.setStatsForLevel();
    }

    @Override
    public float getBaseMaxMana() {
        return this.baseMaxMana;
    }

    @Override
    public float getMaxMana() {
        return this.maxMana;
    }

    @Override
    public void setMaxMana(float amount) {
        this.maxMana = amount;
        if (!this.m_9236_().m_5776_()) {
            HeroClientboundPacket.setMaxMana(this.m_19879_(), amount);
        }
    }

    @Override
    public float getMana() {
        return this.mana;
    }

    @Override
    public void setMana(float amount) {
        this.mana = Math.min(this.maxMana, amount);
        if (!this.m_9236_().m_5776_()) {
            HeroClientboundPacket.setMana(this.m_19879_(), this.mana);
        }
    }

    @Override
    public float getManaRegenPerSecond() {
        return this.manaRegenPerSecond;
    }

    @Override
    public float getManaBonusPerLevel() {
        return this.manaBonusPerLevel;
    }

    @Override
    public float getHealthBonusPerLevel() {
        return 10.0f;
    }

    @Override
    public float getAttackBonusPerLevel() {
        return 0.7f;
    }

    @Override
    public float getBaseHealth() {
        return 150.0f;
    }

    @Override
    public float getBaseAttack() {
        return 8.0f;
    }

    @Override
    public void stopAllAnimations() {
        this.idleAnimState.m_216973_();
        this.walkAnimState.m_216973_();
        this.spellChargeAnimState.m_216973_();
        this.spellActivateAnimState.m_216973_();
        this.attackAnimState.m_216973_();
    }

    @Override
    public void setAnimateTicksLeft(int ticks) {
        this.animateTicks = ticks;
    }

    @Override
    public int getAnimateTicksLeft() {
        return this.animateTicks;
    }

    @Override
    public void playSingleAnimation(UnitAnimationAction animAction) {
        this.animateScaleReducing = false;
        switch (animAction) {
            case ATTACK_UNIT: 
            case ATTACK_BUILDING: {
                this.activeAnimDef = PiglinMerchantAnimations.ATTACK;
                this.activeAnimState = this.attackAnimState;
                this.animateScale = 1.0f;
                this.startAnimation(this.activeAnimDef);
                break;
            }
            case CAST_SPELL: {
                this.activeAnimDef = PiglinMerchantAnimations.SPELL_FULL;
                this.activeAnimState = this.spellActivateAnimState;
                this.animateScale = 1.0f;
                this.startAnimation(this.activeAnimDef);
                break;
            }
            default: {
                this.animateScaleReducing = true;
            }
        }
    }

    public PiglinMerchantUnit(EntityType<? extends Piglin> entityType, Level level) {
        super(entityType, level);
        this.updateAbilityButtons();
        this.setStatsForLevel();
    }

    public float m_6515_(DamageSource pSource, float pDamage) {
        pDamage = super.m_6515_(pSource, pDamage);
        if (pSource.m_269533_(DamageTypeTags.f_268731_)) {
            pDamage *= 0.7f;
        }
        return pDamage;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22277_, (double)Unit.getFollowRange()).m_22268_(Attributes.f_22284_, 0.0);
    }

    protected void m_7581_(ItemEntity pItemEntity) {
    }

    public boolean m_34666_() {
        return false;
    }

    protected void m_8024_() {
    }

    public LivingEntity m_5448_() {
        return this.targetGoal.getTarget();
    }

    public void m_8119_() {
        this.m_21553_(false);
        super.m_8119_();
        Unit.tick(this);
        AttackerUnit.tick(this);
        HeroUnit.tick(this);
        if (this.m_9236_().m_5776_() && this.animateTicks > 0) {
            --this.animateTicks;
        }
        this.castTNTGoal.m_8037_();
        this.castFancyFeastGoal.m_8037_();
        this.castLootExplosionGoal.m_8037_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19862_) {
            boolean flag = false;
            AABB aabb = this.m_20191_().m_82400_(0.2);
            Iterator var8 = BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_)).iterator();
            while (true) {
                if (!var8.hasNext()) {
                    if (flag || !this.m_20096_()) break;
                    this.m_6135_();
                    break;
                }
                BlockPos blockpos = (BlockPos)var8.next();
                BlockState blockstate = this.m_9236_().m_8055_(blockpos);
                Block block = blockstate.m_60734_();
                if (!(block instanceof LeavesBlock)) continue;
            }
        }
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.addUnitSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.readUnitSaveData(pCompound);
    }

    @Override
    public void initialiseGoals() {
        this.usePortalGoal = new UsePortalGoal((Mob)this);
        this.moveGoal = new MoveToTargetBlockGoal((Mob)this, false, 0);
        this.targetGoal = new SelectedTargetGoal((Mob)this, true, true);
        this.attackGoal = new MeleeWindupAttackUnitGoal((Mob)this, false, 32);
        this.attackBuildingGoal = new MeleeWindupAttackBuildingGoal((Mob)this, 32);
        this.castTNTGoal = new GenericTargetedSpellGoal((Mob)this, 32, 12.0f, UnitAnimationAction.ATTACK_UNIT, null, this::throwTNT, null);
        this.castFancyFeastGoal = new GenericTargetedSpellGoal((Mob)this, 32, 10.0f, UnitAnimationAction.ATTACK_UNIT, null, this::fancyFeast, null);
        this.castLootExplosionGoal = new GenericUntargetedSpellGoal((LivingEntity)this, 60, this::lootExplosion, UnitAnimationAction.CAST_SPELL, UnitAnimationAction.STOP, null);
    }

    protected void m_8099_() {
        this.initialiseGoals();
        this.f_21345_.m_25352_(2, (Goal)this.usePortalGoal);
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)this.attackGoal);
        this.f_21345_.m_25352_(2, (Goal)this.attackBuildingGoal);
        this.f_21346_.m_25352_(2, this.targetGoal);
        this.f_21345_.m_25352_(3, (Goal)this.moveGoal);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        return pSpawnData;
    }

    @Override
    public void resetBehaviours() {
        this.animateScaleReducing = true;
        this.castTNTGoal.m_8041_();
        this.castFancyFeastGoal.m_8041_();
        this.castLootExplosionGoal.m_8041_();
    }

    public ThrowTNT getThrowTNT() {
        for (Ability ability : this.abilities.get()) {
            if (!(ability instanceof ThrowTNT)) continue;
            return (ThrowTNT)ability;
        }
        return null;
    }

    public FancyFeast getFancyFeast() {
        for (Ability ability : this.abilities.get()) {
            if (!(ability instanceof FancyFeast)) continue;
            return (FancyFeast)ability;
        }
        return null;
    }

    public GreedIsGoodPassive getGreedIsGood() {
        for (Ability ability : this.abilities.get()) {
            if (!(ability instanceof GreedIsGoodPassive)) continue;
            return (GreedIsGoodPassive)ability;
        }
        return null;
    }

    public LootExplosion getLootExplosion() {
        for (Ability ability : this.abilities.get()) {
            if (!(ability instanceof LootExplosion)) continue;
            return (LootExplosion)ability;
        }
        return null;
    }

    public void throwTNT(BlockPos targetBp) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        ThrowTNT throwTNT = this.getThrowTNT();
        ThrowableTntProjectile tnt = new ThrowableTntProjectile(this.m_9236_(), (LivingEntity)this, throwTNT.explosionPower);
        tnt.m_37446_(new ItemStack((ItemLike)ItemRegistrar.THROWABLE_TNT.get()));
        Vec3 dMove = Vec3.m_82512_((Vec3i)targetBp).m_82546_(this.m_146892_()).m_82542_(1.0, 0.0, 1.0).m_82490_(0.04).m_82520_(0.0, 0.5, 0.0);
        tnt.m_20256_(dMove);
        this.m_9236_().m_7967_((Entity)tnt);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11877_, SoundSource.NEUTRAL, 0.5f, 0.4f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        GreedIsGoodPassive greedIsGood = this.getGreedIsGood();
        int resourceBonus = 0;
        if (greedIsGood.isAutocasting(this)) {
            resourceBonus = greedIsGood.spendResourcesAndGet100sSpent(ResourceName.WOOD, this);
        }
        float cooldown = Math.max(0.0f, throwTNT.cooldownMax - (float)(resourceBonus * ThrowTNT.LESS_COOLDOWN_PER_100_RESOURCES));
        throwTNT.setCooldown(cooldown, this);
        AbilityClientboundPacket.sendSetCooldownPacket(this.m_19879_(), throwTNT.action, throwTNT.getCooldown(this));
        this.setMana(this.getMana() + (float)(resourceBonus * ThrowTNT.MANA_REFUND_PER_100_RESOURCES));
    }

    public void fancyFeast(BlockPos targetBp) {
        Vec3 pos = this.m_146892_();
        GreedIsGoodPassive greedIsGood = this.getGreedIsGood();
        int resourceBonus = 0;
        if (greedIsGood.isAutocasting(this)) {
            resourceBonus = greedIsGood.spendResourcesAndGet100sSpent(ResourceName.FOOD, this);
        }
        int numItems = 6 + 2 * resourceBonus;
        for (int i = 0; i < numItems; ++i) {
            ItemEntity foodEntity = new ItemEntity(this.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, new ItemStack((ItemLike)this.getFancyFeast().getFoodItem(this)));
            foodEntity.m_32052_(this.m_20148_());
            Vec3 dMove = Vec3.m_82512_((Vec3i)targetBp).m_82546_(pos).m_82542_(1.0, 0.0, 1.0).m_82490_(0.04).m_82520_((double)((this.f_19796_.m_188501_() - 0.5f) / 4.0f), 0.5, (double)((this.f_19796_.m_188501_() - 0.5f) / 4.0f));
            foodEntity.m_20256_(dMove);
            this.m_9236_().m_7967_((Entity)foodEntity);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11877_, SoundSource.NEUTRAL, 0.5f, 0.4f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        }
        this.setMana(this.getMana() + (float)(resourceBonus * FancyFeast.MANA_REFUND_PER_100_RESOURCES));
    }

    private List<ItemStack> getRandomLoot(int amount) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ArrayList<LivingEntity> units = new ArrayList<LivingEntity>(UnitServerEvents.getAllUnits().stream().filter(u -> {
            Unit unit;
            return u instanceof Unit && (unit = (Unit)u).getOwnerName().equals(this.getOwnerName()) && unit instanceof AttackerUnit && !(unit instanceof GhastUnit);
        }).toList());
        Collections.shuffle(units);
        for (int n = 0; n < amount; ++n) {
            if (units.size() > n) {
                WitherSkeletonUnit wither;
                ItemStack itemStack;
                int i = this.f_19796_.m_188503_(100);
                LivingEntity unit = units.get(n);
                if (unit instanceof BruteUnit) {
                    BruteUnit bruteUnit = (BruteUnit)unit;
                    if (i >= 50 && !bruteUnit.hasNetheriteChestplate()) {
                        items.add(new ItemStack((ItemLike)Items.f_42481_));
                        continue;
                    }
                    if (i > 0 && !bruteUnit.hasEnchantedNetheriteSword()) {
                        itemStack = new ItemStack((ItemLike)Items.f_42393_);
                        itemStack.m_41663_(Enchantments.f_44981_, 1);
                        items.add(itemStack);
                        continue;
                    }
                    items.add(new ItemStack((ItemLike)Items.f_42437_));
                    continue;
                }
                if (unit instanceof HeadhunterUnit) {
                    HeadhunterUnit headhunterUnit = (HeadhunterUnit)unit;
                    if (i >= 50 && !headhunterUnit.hasNetheriteChestplate()) {
                        items.add(new ItemStack((ItemLike)Items.f_42481_));
                        continue;
                    }
                    if (i > 0 && !headhunterUnit.hasFireAspectTrident()) {
                        itemStack = new ItemStack((ItemLike)Items.f_42713_);
                        itemStack.m_41663_(Enchantments.f_44981_, 1);
                        itemStack.m_41663_(Enchantments.f_44986_, 1);
                        items.add(itemStack);
                        continue;
                    }
                    items.add(new ItemStack((ItemLike)Items.f_42437_));
                    continue;
                }
                if (unit instanceof HoglinUnit && !(unit instanceof ArmouredHoglinUnit) || unit instanceof WitherSkeletonUnit && !(wither = (WitherSkeletonUnit)unit).hasNetheriteChestplate()) {
                    items.add(new ItemStack((ItemLike)Items.f_42481_));
                    continue;
                }
                items.add(new ItemStack((ItemLike)Items.f_42437_));
                continue;
            }
            items.add(new ItemStack((ItemLike)Items.f_42437_));
        }
        return items;
    }

    public void lootExplosion() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        Vec3 pos = this.m_146892_();
        GreedIsGoodPassive greedIsGood = this.getGreedIsGood();
        int resourceBonus = 0;
        if (greedIsGood.isAutocasting(this)) {
            resourceBonus = greedIsGood.spendResourcesAndGet100sSpent(ResourceName.ORE, this);
        }
        int numItems = 12 + 3 * resourceBonus;
        List<ItemStack> items = this.getRandomLoot(numItems);
        for (ItemStack itemStack : items) {
            ItemEntity item = new ItemEntity(this.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, itemStack);
            item.m_32052_(this.m_20148_());
            Vec3 dMove = new Vec3((double)((this.f_19796_.m_188501_() - 0.5f) / 2.0f), 0.5, (double)((this.f_19796_.m_188501_() - 0.5f) / 2.0f)).m_82490_(1.25);
            item.m_20256_(dMove);
            this.m_9236_().m_7967_((Entity)item);
        }
        this.m_9236_().m_254877_(null, null, null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, false, Level.ExplosionInteraction.NONE);
        this.setMana(this.getMana() + (float)(resourceBonus * LootExplosion.MANA_REFUND_PER_100_RESOURCES));
    }

    static {
        ABILITIES.add(new ThrowTNT());
        ABILITIES.add(new FancyFeast());
        ABILITIES.add(new GreedIsGoodPassive());
        ABILITIES.add(new LootExplosion());
        ownerDataAccessor = SynchedEntityData.m_135353_(PiglinMerchantUnit.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    }
}

