/*
 * Decompiled with CFR 0.152.
 */
package kunga.rpgcameraandcontrols.camera;

import kunga.rpgcameraandcontrols.input.RpgMouseInput;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;

@Environment(value=EnvType.CLIENT)
public final class RpgCamera {
    private static final class_2960 CAMERA_ZOOM_ID = class_2960.method_60655((String)"rpg-camera", (String)"camera-zoom");
    public static double ZOOM_MIN = 1.5;
    public static double ZOOM_MAX = 12.0;
    public static double ZOOM_STEP = 0.5;
    public static double ZOOM_SMOOTHING = 10.0;
    private static double targetZoom = Double.NaN;
    private static double currentZoom = Double.NaN;
    private static boolean hasCalibration = false;
    private static double orbitYawRadians = 0.0;
    private static double orbitPitchRadians = Math.toRadians(20.0);
    private static double orbitRadius = 4.0;
    private static final double MIN_PITCH = Math.toRadians(-85.0);
    private static final double MAX_PITCH = Math.toRadians(85.0);

    private RpgCamera() {
    }

    public static boolean isOrbiting() {
        return RpgMouseInput.isRightMouseHeld();
    }

    public static void ensureDefaultCameraPosition() {
        if (!hasCalibration) {
            RpgCamera.setDefaultCameraPosition();
        }
    }

    private static void setDefaultCameraPosition() {
        orbitYawRadians = Math.toRadians(0.0);
        orbitPitchRadians = Math.toRadians(30.0);
        orbitRadius = 12.0;
        hasCalibration = true;
    }

    public static void updateOrbitFromMouseDelta() {
        if (!RpgMouseInput.isRightMouseHeld()) {
            return;
        }
        double deltaX = RpgMouseInput.getCurrentDeltaX();
        double deltaY = RpgMouseInput.getCurrentDeltaY();
        if (Math.abs(deltaX) < 0.01 && Math.abs(deltaY) < 0.01) {
            return;
        }
        double yawRadiansPerPixel = 0.0015;
        double pitchRadiansPerPixel = 0.0011;
        orbitYawRadians += deltaX * yawRadiansPerPixel;
        orbitPitchRadians = Math.clamp(orbitPitchRadians + deltaY * pitchRadiansPerPixel, MIN_PITCH, MAX_PITCH);
    }

    public static double getOrbitYawRadians() {
        return orbitYawRadians;
    }

    public static double getOrbitPitchRadians() {
        return orbitPitchRadians;
    }

    public static void nudgeYawTowards(double desiredYawRadians, double blend) {
        orbitYawRadians = RpgCamera.lerpAngle(orbitYawRadians, RpgCamera.wrapPi(desiredYawRadians), blend);
    }

    public static double getCurrentZoom() {
        return currentZoom;
    }

    public static double getRadiusForFrame() {
        try {
            if (Double.isFinite(currentZoom) && currentZoom > 0.0) {
                orbitRadius = currentZoom;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return orbitRadius;
    }

    public static void applyScrollZoom(class_1657 player) {
        double scrollDelta = RpgMouseInput.consumeScrollDelta();
        if (scrollDelta == 0.0) {
            return;
        }
        class_1324 cameraDistanceAttribute = player.method_5996(class_5134.field_59674);
        if (cameraDistanceAttribute == null) {
            return;
        }
        cameraDistanceAttribute.method_26835(RpgCamera.initializeAttributes(cameraDistanceAttribute));
        targetZoom = class_3532.method_15350((double)(targetZoom - scrollDelta * ZOOM_STEP), (double)ZOOM_MIN, (double)ZOOM_MAX);
    }

    public static void updateZoom(class_1657 player, double deltaSeconds) {
        class_1324 cameraDistanceAttribute = player.method_5996(class_5134.field_59674);
        if (cameraDistanceAttribute == null) {
            return;
        }
        cameraDistanceAttribute.method_26835(RpgCamera.initializeAttributes(cameraDistanceAttribute));
        double alpha = 1.0 - Math.exp(-ZOOM_SMOOTHING * deltaSeconds);
        currentZoom += (targetZoom - currentZoom) * alpha;
        cameraDistanceAttribute.method_26835(RpgCamera.applyAttributes(cameraDistanceAttribute, currentZoom));
    }

    public static boolean isHitResultWithinPlayerReach(class_1657 player, class_239 hitResult) {
        if (player == null || hitResult == null || hitResult.method_17783() == class_239.class_240.field_1333) {
            return false;
        }
        class_243 playerEyePos = player.method_5836(1.0f);
        double allowedBlockReach = player.method_55754();
        double allowedEntityReach = player.method_55755();
        switch (hitResult.method_17783()) {
            case field_1332: {
                class_3965 blockHit = (class_3965)hitResult;
                class_243 blockHitPosWorld = new class_243(blockHit.method_17784().field_1352, blockHit.method_17784().field_1351, blockHit.method_17784().field_1350);
                double distance = playerEyePos.method_1022(blockHitPosWorld);
                return distance <= allowedBlockReach + 0.05;
            }
            case field_1331: {
                class_3966 entityHit = (class_3966)hitResult;
                class_1297 target = entityHit.method_17782();
                if (target == null) {
                    return false;
                }
                class_243 entityPosWorld = target.method_19538();
                double distance = playerEyePos.method_1022(entityPosWorld);
                return distance <= allowedEntityReach + 0.05;
            }
        }
        return false;
    }

    private static class_1322 initializeAttributes(class_1324 cameraDistanceAttribute) {
        double defaultValue;
        if (!Double.isNaN(targetZoom) && !Double.isNaN(currentZoom)) {
            return RpgCamera.applyAttributes(cameraDistanceAttribute, currentZoom);
        }
        cameraDistanceAttribute.method_6200(CAMERA_ZOOM_ID);
        targetZoom = defaultValue = cameraDistanceAttribute.method_6194();
        currentZoom = defaultValue;
        return RpgCamera.applyAttributes(cameraDistanceAttribute, currentZoom);
    }

    private static class_1322 applyAttributes(class_1324 cameraDistanceAttribute, double desiredZoom) {
        desiredZoom = class_3532.method_15350((double)desiredZoom, (double)ZOOM_MIN, (double)ZOOM_MAX);
        cameraDistanceAttribute.method_6200(CAMERA_ZOOM_ID);
        double defaultValue = cameraDistanceAttribute.method_6194();
        double offsetZoom = desiredZoom - defaultValue;
        return new class_1322(CAMERA_ZOOM_ID, offsetZoom, class_1322.class_1323.field_6328);
    }

    private static double wrapPi(double a) {
        while (a <= -Math.PI) {
            a += Math.PI * 2;
        }
        while (a > Math.PI) {
            a -= Math.PI * 2;
        }
        return a;
    }

    private static double lerpAngle(double from, double to, double t) {
        double diff = RpgCamera.wrapPi(to - from);
        return RpgCamera.wrapPi(from + diff * t);
    }

    public static boolean hasMovedDuringHold() {
        return RpgMouseInput.hasMovedDuringHold();
    }

    public static boolean consumeMovedFlagOnRelease() {
        return RpgMouseInput.consumeMovedFlagOnRelease();
    }
}

