/*
 * Decompiled with CFR 0.152.
 */
package dev.mariany.storagepot.block;

import com.mojang.serialization.MapCodec;
import dev.mariany.storagepot.block.SPBlocks;
import dev.mariany.storagepot.block.entity.StoragePotBlockEntity;
import java.util.Optional;
import net.minecraft.class_10;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1703;
import net.minecraft.class_1743;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8172;
import org.jetbrains.annotations.Nullable;

public class StoragePotBlock
extends class_2237 {
    public static final MapCodec<StoragePotBlock> CODEC = StoragePotBlock.method_54094(StoragePotBlock::new);
    public static final class_2754<class_2350> FACING = class_2741.field_12481;
    private static final class_265 SHAPE = class_2248.method_66404((double)16.0, (double)0.0, (double)16.0);

    public StoragePotBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043));
    }

    public static Optional<class_3965> getExtractionSide(class_1657 player) {
        class_3965 blockHitResult = StoragePotBlock.getBlockHitResult(player);
        if (blockHitResult != null && StoragePotBlock.isExtractionSide(player, blockHitResult)) {
            return Optional.of(blockHitResult);
        }
        return Optional.empty();
    }

    public static boolean isExtractionSide(class_1657 player) {
        return StoragePotBlock.getExtractionSide(player).isPresent();
    }

    public static boolean isExtractionSide(class_1657 player, class_3965 blockHitResult) {
        return StoragePotBlock.isExtractionSide(player, blockHitResult.method_17777(), blockHitResult.method_17780());
    }

    public static boolean isExtractionSide(class_1657 player, class_2338 pos, class_2350 side) {
        Optional optionalFacing;
        class_2680 state = player.method_37908().method_8320(pos);
        if (state.method_26204() instanceof StoragePotBlock && (optionalFacing = state.method_28500(FACING)).isPresent()) {
            return side.equals((Object)((class_2350)optionalFacing.get()).method_10153());
        }
        return false;
    }

    public static class_3965 getBlockHitResult(class_1657 player) {
        class_239 class_2392 = player.method_5745(player.method_55754(), 1.0f, false);
        if (class_2392 instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)class_2392;
            return blockHitResult;
        }
        return null;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)ctx.method_8042());
    }

    protected class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof StoragePotBlockEntity) {
            StoragePotBlockEntity storagePotBlockEntity = (StoragePotBlockEntity)class_25862;
            boolean waxing = stack.method_7909().equals(class_1802.field_20414);
            boolean scraping = stack.method_7909() instanceof class_1743;
            boolean waxed = storagePotBlockEntity.isWaxed();
            if (waxing || scraping) {
                boolean extractionSide = StoragePotBlock.isExtractionSide(player, hit);
                boolean canInsert = storagePotBlockEntity.canInsert(stack);
                boolean isWaxedItem = class_1799.method_31577((class_1799)storagePotBlockEntity.getWaxedItem(), (class_1799)stack);
                if (!(!waxing || waxed || extractionSide && canInsert || !storagePotBlockEntity.wax())) {
                    stack.method_57008(1, (class_1309)player);
                    world.method_43276((class_6880)class_5712.field_28733, pos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)state));
                    world.method_8444((class_1297)player, 3003, pos, 0);
                    return class_1269.field_5812;
                }
                if (scraping && waxed && (!extractionSide || !isWaxedItem) && storagePotBlockEntity.unwax()) {
                    stack.method_61653(1, player);
                    world.method_8396((class_1297)player, pos, class_3417.field_29542, class_3419.field_15245, 1.0f, 1.0f);
                    world.method_8444((class_1297)player, 3004, pos, 0);
                    return class_1269.field_5812;
                }
            }
            if (world.method_8608()) {
                return class_1269.field_5812;
            }
            if (storagePotBlockEntity.add(player, stack, player.method_5715())) {
                storagePotBlockEntity.onChange();
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
                return class_1269.field_5812;
            }
            return class_1269.field_52423;
        }
        return class_1269.field_5811;
    }

    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof StoragePotBlockEntity) {
            StoragePotBlockEntity storagePotBlockEntity = (StoragePotBlockEntity)class_25862;
            world.method_8396(null, pos, class_3417.field_46650, class_3419.field_15245, 1.0f, 1.0f);
            storagePotBlockEntity.wobble(class_8172.class_8837.field_46665);
            world.method_33596((class_1297)player, (class_6880)class_5712.field_28733, pos);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof StoragePotBlockEntity) {
            StoragePotBlockEntity storagePotBlockEntity = (StoragePotBlockEntity)class_25862;
            if (!world.method_8608() && player.method_66324() && !storagePotBlockEntity.method_5442()) {
                class_1799 itemStack = new class_1799((class_1935)SPBlocks.STORAGE_POT);
                itemStack.method_57365(storagePotBlockEntity.method_57590());
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, itemStack);
                itemEntity.method_6988();
                world.method_8649((class_1297)itemEntity);
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new StoragePotBlockEntity(pos, state);
    }

    protected void method_66388(class_2680 state, class_3218 world, class_2338 pos, boolean moved) {
        class_1264.method_66221((class_2680)state, (class_1937)world, (class_2338)pos);
    }

    protected class_2498 method_9573(class_2680 state) {
        return class_2498.field_42771;
    }

    protected void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        class_3218 serverWorld;
        class_2338 blockPos = hit.method_17777();
        if (world instanceof class_3218 && projectile.method_36971(serverWorld = (class_3218)world, blockPos) && projectile.method_54457(serverWorld)) {
            world.method_8651(blockPos, true, (class_1297)projectile);
        }
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        return class_1703.method_7608((class_2586)world.method_8321(pos));
    }

    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654(FACING)));
    }

    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654(FACING)));
    }
}

